/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.DomainPermission;
import com.acciente.oacc.Resource;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.CommonGrantDomainPermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursivePersisterHelper;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import com.acciente.oacc.sql.internal.persister.id.ResourceId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NonRecursiveGrantDomainPermissionSysPersister
extends CommonGrantDomainPermissionSysPersister
implements Serializable {
    private static final long serialVersionUID = 1L;

    public NonRecursiveGrantDomainPermissionSysPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        super(sqlProfile, sqlStrings);
    }

    @Override
    public Set<Resource> getResourcesByDomainSuperUserPermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId) {
        HashSet<Resource> hashSet;
        SQLStatement statement = null;
        try {
            SQLResult resultSet;
            Set<Id<ResourceId>> accessorResourceIds = NonRecursivePersisterHelper.getInheritedAccessorResourceIds(this.sqlStrings, connection, accessorResource);
            HashSet<Id<DomainId>> directDomainIds = new HashSet<Id<DomainId>>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantDomainPermissionSys_withoutInheritance_ResourceDomainId_BY_AccessorID_SysPermissionID_IsWithGrant);
            for (Id<ResourceId> id : accessorResourceIds) {
                statement.setResourceId(1, id);
                statement.setDomainSystemPermissionId(2, DOMAIN_PERMISSION_SUPER_USER.getSystemPermissionId());
                statement.setBoolean(3, false);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    directDomainIds.add(resultSet.getResourceDomainId("AccessedDomainId"));
                }
                resultSet.close();
            }
            NonRecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
            HashSet<Id<DomainId>> accessibleDomainIds = new HashSet<Id<DomainId>>();
            for (Id id : directDomainIds) {
                accessibleDomainIds.addAll(NonRecursivePersisterHelper.getDescendantDomainIdsOrderedByAscendingLevel(this.sqlStrings, connection, id));
            }
            HashSet<Resource> hashSet2 = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResource_withoutInheritance_ResourceId_ExternalId_BY_ResourceClassID_DomainID);
            for (Id id : accessibleDomainIds) {
                statement.setResourceClassId(1, resourceClassId);
                statement.setResourceDomainId(2, id);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    hashSet2.add(resultSet.getResource("ResourceId", "ExternalId"));
                }
                resultSet.close();
            }
            hashSet = hashSet2;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<Resource> getResourcesByDomainSuperUserPermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, Id<DomainId> resourceDomainId) {
        HashSet<Resource> hashSet;
        SQLStatement statement = null;
        try {
            SQLResult resultSet;
            Set<Id<ResourceId>> accessorResourceIds = NonRecursivePersisterHelper.getInheritedAccessorResourceIds(this.sqlStrings, connection, accessorResource);
            HashSet<Id<DomainId>> directDomainIds = new HashSet<Id<DomainId>>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantDomainPermissionSys_withoutInheritance_ResourceDomainId_BY_AccessorID_SysPermissionID_IsWithGrant);
            for (Id<ResourceId> id : accessorResourceIds) {
                statement.setResourceId(1, id);
                statement.setDomainSystemPermissionId(2, DOMAIN_PERMISSION_SUPER_USER.getSystemPermissionId());
                statement.setBoolean(3, false);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    directDomainIds.add(resultSet.getResourceDomainId("AccessedDomainId"));
                }
                resultSet.close();
            }
            NonRecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
            HashSet<Id<DomainId>> accessibleDomainIds = new HashSet<Id<DomainId>>();
            for (Id id : directDomainIds) {
                accessibleDomainIds.addAll(NonRecursivePersisterHelper.getDescendantDomainIdsOrderedByAscendingLevel(this.sqlStrings, connection, id));
            }
            Set<Id<DomainId>> set = NonRecursivePersisterHelper.getDescendantDomainIdsOrderedByAscendingLevel(this.sqlStrings, connection, resourceDomainId);
            accessibleDomainIds.retainAll(set);
            HashSet<Resource> hashSet2 = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResource_withoutInheritance_ResourceId_ExternalId_BY_ResourceClassID_DomainID);
            for (Id id : accessibleDomainIds) {
                statement.setResourceClassId(1, resourceClassId);
                statement.setResourceDomainId(2, id);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    hashSet2.add(resultSet.getResource("ResourceId", "ExternalId"));
                }
                resultSet.close();
            }
            hashSet = hashSet2;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<DomainPermission> getDomainSysPermissionsIncludeInherited(SQLConnection connection, Resource accessorResource, Id<DomainId> resourceDomainId) {
        HashSet<DomainPermission> hashSet;
        SQLStatement statement = null;
        try {
            Set<Id<ResourceId>> accessorResourceIds = NonRecursivePersisterHelper.getInheritedAccessorResourceIds(this.sqlStrings, connection, accessorResource);
            Set<Id<DomainId>> ancestorDomainIds = NonRecursivePersisterHelper.getAncestorDomainIds(this.sqlStrings, connection, resourceDomainId);
            HashSet<DomainPermission> domainPermissions = new HashSet<DomainPermission>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantDomainPermissionSys_withoutInheritance_SysPermissionID_IsWithGrant_BY_AccessorID_DomainID);
            for (Id<ResourceId> accessorResourceId : accessorResourceIds) {
                for (Id<DomainId> domainId : ancestorDomainIds) {
                    statement.setResourceId(1, accessorResourceId);
                    statement.setResourceDomainId(2, domainId);
                    SQLResult resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        domainPermissions.add(NonRecursiveGrantDomainPermissionSysPersister.getDomainSysPermission(resultSet));
                    }
                    resultSet.close();
                }
            }
            hashSet = domainPermissions;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Map<String, Set<DomainPermission>> getDomainSysPermissionsIncludeInherited(SQLConnection connection, Resource accessorResource) {
        HashMap hashMap;
        SQLStatement statement = null;
        try {
            Set<Id<ResourceId>> accessorResourceIds = NonRecursivePersisterHelper.getInheritedAccessorResourceIds(this.sqlStrings, connection, accessorResource);
            HashMap domainPermissionsMap = new HashMap();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantDomainPermissionSys_withoutInheritance_ResourceDomainName_SysPermissionID_IsWithGrant_BY_AccessorID);
            for (Id<ResourceId> accessorResourceId : accessorResourceIds) {
                statement.setResourceId(1, accessorResourceId);
                SQLResult resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    String resourceDomainName = resultSet.getString("DomainName");
                    HashSet<DomainPermission> domainPermissions = (HashSet<DomainPermission>)domainPermissionsMap.get(resourceDomainName);
                    if (domainPermissions == null) {
                        domainPermissions = new HashSet<DomainPermission>();
                        domainPermissionsMap.put(resourceDomainName, domainPermissions);
                    }
                    domainPermissions.add(NonRecursiveGrantDomainPermissionSysPersister.getDomainSysPermission(resultSet));
                }
                resultSet.close();
            }
            NonRecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
            statement = null;
            HashSet directDomainNames = new HashSet(domainPermissionsMap.keySet());
            for (String directDomainName : directDomainNames) {
                Set<String> descendentDomains = NonRecursivePersisterHelper.getDescendantDomainNames(this.sqlStrings, connection, directDomainName);
                for (String descendentDomain : descendentDomains) {
                    HashSet domainPermissions = (HashSet)domainPermissionsMap.get(descendentDomain);
                    if (domainPermissions == null) {
                        domainPermissions = new HashSet();
                        domainPermissionsMap.put(descendentDomain, domainPermissions);
                    }
                    if (descendentDomain.equals(directDomainName)) continue;
                    domainPermissions.addAll((Collection)domainPermissionsMap.get(directDomainName));
                }
            }
            hashMap = domainPermissionsMap;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
        return hashMap;
    }

    @Override
    public void removeAllDomainSysPermissions(SQLConnection connection, Id<DomainId> domainId) {
        SQLStatement statement = null;
        try {
            ArrayList<Id<DomainId>> descendantDomainIds = new ArrayList<Id<DomainId>>(NonRecursivePersisterHelper.getDescendantDomainIdsOrderedByAscendingLevel(this.sqlStrings, connection, domainId));
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantDomainPermissionSys_BY_AccessedDomainID);
            for (int i = descendantDomainIds.size() - 1; i >= 0; --i) {
                statement.setResourceDomainId(1, (Id)descendantDomainIds.get(i));
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
    }
}

