/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.ResourcePermission;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.CommonGrantGlobalResourcePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursivePersisterHelper;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import com.acciente.oacc.sql.internal.persister.id.ResourceId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NonRecursiveGrantGlobalResourcePermissionSysPersister
extends CommonGrantGlobalResourcePermissionSysPersister
implements Serializable {
    private static final long serialVersionUID = 1L;

    public NonRecursiveGrantGlobalResourcePermissionSysPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        super(sqlProfile, sqlStrings);
    }

    @Override
    public Set<Resource> getResourcesByGlobalSysPermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, ResourcePermission resourcePermission) {
        HashSet<Resource> hashSet;
        if (!resourcePermission.isSystemPermission()) {
            throw new IllegalArgumentException("Permission: " + resourcePermission + " is not a system permission");
        }
        SQLStatement statement = null;
        try {
            SQLResult resultSet;
            Set<Id<ResourceId>> accessorResourceIds = NonRecursivePersisterHelper.getInheritedAccessorResourceIds(this.sqlStrings, connection, accessorResource);
            HashSet<Id<DomainId>> directGlobalDomains = new HashSet<Id<DomainId>>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantGlobalResourcePermissionSys_withoutInheritance_ResourceDomainID_BY_AccessorID_ResourceClassID_SysPermissionID_IsWithGrant);
            for (Id<ResourceId> accessorResourceId : accessorResourceIds) {
                statement.setResourceId(1, accessorResourceId);
                statement.setResourceClassId(2, resourceClassId);
                statement.setResourceSystemPermissionId(3, resourcePermission.getSystemPermissionId());
                statement.setBoolean(4, resourcePermission.isWithGrantOption());
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    directGlobalDomains.add(resultSet.getResourceDomainId("DomainId"));
                }
                resultSet.close();
            }
            NonRecursiveGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResource_withoutInheritance_ResourceId_ExternalId_BY_ResourceClassID_DomainID);
            for (Id id : directGlobalDomains) {
                Set<Id<DomainId>> descendentDomainIds = NonRecursivePersisterHelper.getDescendantDomainIdsOrderedByAscendingLevel(this.sqlStrings, connection, id);
                for (Id<DomainId> descendentDomainId : descendentDomainIds) {
                    statement.setResourceClassId(1, resourceClassId);
                    statement.setResourceDomainId(2, descendentDomainId);
                    resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        resources.add(resultSet.getResource("ResourceId", "ExternalId"));
                    }
                    resultSet.close();
                }
            }
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<Resource> getResourcesByGlobalSysPermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, Id<DomainId> resourceDomainId, ResourcePermission resourcePermission) {
        HashSet<Resource> hashSet;
        if (!resourcePermission.isSystemPermission()) {
            throw new IllegalArgumentException("Permission: " + resourcePermission + " is not a system permission");
        }
        SQLStatement statement = null;
        try {
            SQLResult resultSet;
            Set<Id<ResourceId>> accessorResourceIds = NonRecursivePersisterHelper.getInheritedAccessorResourceIds(this.sqlStrings, connection, accessorResource);
            HashSet<Id<DomainId>> directGlobalDomains = new HashSet<Id<DomainId>>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantGlobalResourcePermissionSys_withoutInheritance_ResourceDomainID_BY_AccessorID_ResourceClassID_SysPermissionID_IsWithGrant);
            for (Id<ResourceId> accessorResourceId : accessorResourceIds) {
                statement.setResourceId(1, accessorResourceId);
                statement.setResourceClassId(2, resourceClassId);
                statement.setResourceSystemPermissionId(3, resourcePermission.getSystemPermissionId());
                statement.setBoolean(4, resourcePermission.isWithGrantOption());
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    directGlobalDomains.add(resultSet.getResourceDomainId("DomainId"));
                }
                resultSet.close();
            }
            NonRecursiveGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
            Set<Id<DomainId>> requestedAncestorDomainIds = NonRecursivePersisterHelper.getAncestorDomainIds(this.sqlStrings, connection, resourceDomainId);
            Set<Id<DomainId>> requestedDescendentDomainIds = NonRecursivePersisterHelper.getDescendantDomainIdsOrderedByAscendingLevel(this.sqlStrings, connection, resourceDomainId);
            Set<Object> effectiveDomainIds = Collections.emptySet();
            for (Id hashSet2 : directGlobalDomains) {
                if (!requestedAncestorDomainIds.contains(hashSet2)) continue;
                effectiveDomainIds = requestedDescendentDomainIds;
                break;
            }
            if (effectiveDomainIds.isEmpty()) {
                for (Id id : requestedDescendentDomainIds) {
                    if (!directGlobalDomains.contains(id)) continue;
                    effectiveDomainIds = NonRecursivePersisterHelper.getDescendantDomainIdsOrderedByAscendingLevel(this.sqlStrings, connection, id);
                    break;
                }
            }
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResource_withoutInheritance_ResourceId_ExternalId_BY_ResourceClassID_DomainID);
            for (Id id : effectiveDomainIds) {
                statement.setResourceClassId(1, resourceClassId);
                statement.setResourceDomainId(2, id);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    resources.add(resultSet.getResource("ResourceId", "ExternalId"));
                }
                resultSet.close();
            }
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<ResourcePermission> getGlobalSysPermissionsIncludeInherited(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, Id<DomainId> resourceDomainId) {
        HashSet<ResourcePermission> hashSet;
        SQLStatement statement = null;
        try {
            Set<Id<ResourceId>> accessorResourceIds = NonRecursivePersisterHelper.getInheritedAccessorResourceIds(this.sqlStrings, connection, accessorResource);
            Set<Id<DomainId>> ancestorDomainIds = NonRecursivePersisterHelper.getAncestorDomainIds(this.sqlStrings, connection, resourceDomainId);
            HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantGlobalResourcePermissionSys_withoutInheritance_SysPermissionID_IsWithGrant_BY_AccessorID_AccessedDomainID_ResourceClassID);
            for (Id<ResourceId> accessorResourceId : accessorResourceIds) {
                for (Id<DomainId> domainId : ancestorDomainIds) {
                    statement.setResourceId(1, accessorResourceId);
                    statement.setResourceDomainId(2, domainId);
                    statement.setResourceClassId(3, resourceClassId);
                    SQLResult resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        resourcePermissions.add(NonRecursiveGrantGlobalResourcePermissionSysPersister.getResourceSysPermission(resultSet));
                    }
                    resultSet.close();
                }
            }
            hashSet = resourcePermissions;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Map<String, Map<String, Set<ResourcePermission>>> getGlobalSysPermissionsIncludeInherited(SQLConnection connection, Resource accessorResource) {
        HashMap hashMap;
        SQLStatement statement = null;
        try {
            Set<Id<ResourceId>> accessorResourceIds = NonRecursivePersisterHelper.getInheritedAccessorResourceIds(this.sqlStrings, connection, accessorResource);
            HashMap globalSysPermissionsMap = new HashMap();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantGlobalResourcePermissionSys_withoutInheritance_ResourceDomainName_ResourceClassName_SysPermissionID_IsWithGrant_BY_AccessorID);
            for (Id<ResourceId> accessorResourceId : accessorResourceIds) {
                statement.setResourceId(1, accessorResourceId);
                SQLResult resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    HashSet<ResourcePermission> permissionsForResourceClass;
                    String resourceDomainName = resultSet.getString("DomainName");
                    String resourceClassName = resultSet.getString("ResourceClassName");
                    HashMap<String, HashSet<ResourcePermission>> permissionsForResourceDomain = (HashMap<String, HashSet<ResourcePermission>>)globalSysPermissionsMap.get(resourceDomainName);
                    if (permissionsForResourceDomain == null) {
                        permissionsForResourceDomain = new HashMap<String, HashSet<ResourcePermission>>();
                        globalSysPermissionsMap.put(resourceDomainName, permissionsForResourceDomain);
                    }
                    if ((permissionsForResourceClass = (HashSet<ResourcePermission>)permissionsForResourceDomain.get(resourceClassName)) == null) {
                        permissionsForResourceClass = new HashSet<ResourcePermission>();
                        permissionsForResourceDomain.put(resourceClassName, permissionsForResourceClass);
                    }
                    permissionsForResourceClass.add(NonRecursiveGrantGlobalResourcePermissionSysPersister.getResourceSysPermission(resultSet));
                }
                resultSet.close();
            }
            NonRecursiveGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
            statement = null;
            HashSet directDomainNames = new HashSet(globalSysPermissionsMap.keySet());
            for (String directDomainName : directDomainNames) {
                Set<String> descendentDomains = NonRecursivePersisterHelper.getDescendantDomainNames(this.sqlStrings, connection, directDomainName);
                for (String descendentDomain : descendentDomains) {
                    HashMap permissionsForResourceDomain = (HashMap)globalSysPermissionsMap.get(descendentDomain);
                    if (permissionsForResourceDomain == null) {
                        permissionsForResourceDomain = new HashMap();
                        globalSysPermissionsMap.put(descendentDomain, permissionsForResourceDomain);
                    }
                    if (descendentDomain.equals(directDomainName)) continue;
                    Map sourceResourceClassPermissionsMap = (Map)globalSysPermissionsMap.get(directDomainName);
                    for (String resourceClassName : sourceResourceClassPermissionsMap.keySet()) {
                        HashSet permissionsForResourceClass = (HashSet)permissionsForResourceDomain.get(resourceClassName);
                        if (permissionsForResourceClass == null) {
                            permissionsForResourceClass = new HashSet();
                            permissionsForResourceDomain.put(resourceClassName, permissionsForResourceClass);
                        }
                        permissionsForResourceClass.addAll((Collection)sourceResourceClassPermissionsMap.get(resourceClassName));
                    }
                }
            }
            hashMap = globalSysPermissionsMap;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
        return hashMap;
    }

    @Override
    public void removeAllGlobalSysPermissions(SQLConnection connection, Id<DomainId> accessedDomainId) {
        SQLStatement statement = null;
        try {
            ArrayList<Id<DomainId>> descendantDomainIds = new ArrayList<Id<DomainId>>(NonRecursivePersisterHelper.getDescendantDomainIdsOrderedByAscendingLevel(this.sqlStrings, connection, accessedDomainId));
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantGlobalResourcePermissionSys_BY_AccessedDomainId);
            for (int i = descendantDomainIds.size() - 1; i >= 0; --i) {
                statement.setResourceDomainId(1, (Id)descendantDomainIds.get(i));
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
    }
}

