/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.ResourcePermission;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.CommonGrantResourcePermissionPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursivePersisterHelper;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import com.acciente.oacc.sql.internal.persister.id.ResourceId;
import com.acciente.oacc.sql.internal.persister.id.ResourcePermissionId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class NonRecursiveGrantResourcePermissionPersister
extends CommonGrantResourcePermissionPersister
implements Serializable {
    private static final long serialVersionUID = 1L;

    public NonRecursiveGrantResourcePermissionPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        super(sqlProfile, sqlStrings);
    }

    @Override
    public Set<Resource> getResourcesByResourcePermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, ResourcePermission resourcePermission, Id<ResourcePermissionId> resourcePermissionId) {
        HashSet<Resource> hashSet;
        if (resourcePermission.isSystemPermission()) {
            throw new IllegalArgumentException("Permission: " + resourcePermission + " is not a non-system permission");
        }
        SQLStatement statement = null;
        try {
            Set<Id<ResourceId>> accessorResourceIds = NonRecursivePersisterHelper.getInheritedAccessorResourceIds(this.sqlStrings, connection, accessorResource);
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermission_withoutInheritance_ResourceID_ExternalID_BY_AccessorID_ResourceClassID_PermissionID_IsWithGrant);
            for (Id<ResourceId> accessorResourceId : accessorResourceIds) {
                statement.setResourceId(1, accessorResourceId);
                statement.setResourceClassId(2, resourceClassId);
                statement.setResourcePermissionId(3, resourcePermissionId);
                statement.setBoolean(4, resourcePermission.isWithGrantOption());
                SQLResult resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    resources.add(resultSet.getResource("ResourceId", "ExternalId"));
                }
                resultSet.close();
            }
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantResourcePermissionPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<Resource> getResourcesByResourcePermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, Id<DomainId> resourceDomainId, ResourcePermission resourcePermission, Id<ResourcePermissionId> resourcePermissionId) {
        HashSet<Resource> hashSet;
        if (resourcePermission.isSystemPermission()) {
            throw new IllegalArgumentException("Permission: " + resourcePermission + " is not a non-system permission");
        }
        SQLStatement statement = null;
        try {
            Set<Id<ResourceId>> accessorResourceIds = NonRecursivePersisterHelper.getInheritedAccessorResourceIds(this.sqlStrings, connection, accessorResource);
            Set<Id<DomainId>> descendantDomainIds = NonRecursivePersisterHelper.getDescendantDomainIdsOrderedByAscendingLevel(this.sqlStrings, connection, resourceDomainId);
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermission_withoutInheritance_ResourceID_ExternalID_BY_AccessorID_DomainID_ResourceClassID_PermissionID_IsWithGrant);
            for (Id<ResourceId> accessorResourceId : accessorResourceIds) {
                for (Id<DomainId> descendantDomainId : descendantDomainIds) {
                    statement.setResourceId(1, accessorResourceId);
                    statement.setResourceDomainId(2, descendantDomainId);
                    statement.setResourceClassId(3, resourceClassId);
                    statement.setResourcePermissionId(4, resourcePermissionId);
                    statement.setBoolean(5, resourcePermission.isWithGrantOption());
                    SQLResult resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        resources.add(resultSet.getResource("ResourceId", "ExternalId"));
                    }
                    resultSet.close();
                }
            }
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantResourcePermissionPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<ResourcePermission> getResourcePermissionsIncludeInherited(SQLConnection connection, Resource accessorResource, Resource accessedResource) {
        HashSet<ResourcePermission> hashSet;
        SQLStatement statement = null;
        try {
            Set<Id<ResourceId>> accessorResourceIds = NonRecursivePersisterHelper.getInheritedAccessorResourceIds(this.sqlStrings, connection, accessorResource);
            HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermission_withoutInheritance_ResourceClassName_PermissionName_IsWithGrant_BY_AccessorID_AccessedID);
            for (Id<ResourceId> accessorResourceId : accessorResourceIds) {
                statement.setResourceId(1, accessorResourceId);
                statement.setResourceId(2, accessedResource);
                SQLResult resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    resourcePermissions.add(NonRecursiveGrantResourcePermissionPersister.getResourcePermission(resultSet));
                }
                resultSet.close();
            }
            hashSet = resourcePermissions;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantResourcePermissionPersister.closeStatement(statement);
        return hashSet;
    }
}

