/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.ResourcePermission;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.CommonGrantResourcePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursivePersisterHelper;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import com.acciente.oacc.sql.internal.persister.id.ResourceId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class NonRecursiveGrantResourcePermissionSysPersister
extends CommonGrantResourcePermissionSysPersister
implements Serializable {
    private static final long serialVersionUID = 1L;

    public NonRecursiveGrantResourcePermissionSysPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        super(sqlProfile, sqlStrings);
    }

    @Override
    public Set<Resource> getResourcesByResourceSysPermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, ResourcePermission resourcePermission) {
        HashSet<Resource> hashSet;
        if (!resourcePermission.isSystemPermission()) {
            throw new IllegalArgumentException("Permission: " + resourcePermission + " is not a system permission");
        }
        SQLStatement statement = null;
        try {
            Set<Id<ResourceId>> accessorResourceIds = NonRecursivePersisterHelper.getInheritedAccessorResourceIds(this.sqlStrings, connection, accessorResource);
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermissionSys_withoutInheritance_ResourceID_ExternalID_BY_AccessorID_ResourceClassID_SysPermissionID_IsWithGrant);
            for (Id<ResourceId> accessorResourceId : accessorResourceIds) {
                statement.setResourceId(1, accessorResourceId);
                statement.setResourceClassId(2, resourceClassId);
                statement.setResourceSystemPermissionId(3, resourcePermission.getSystemPermissionId());
                statement.setBoolean(4, resourcePermission.isWithGrantOption());
                SQLResult resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    resources.add(resultSet.getResource("ResourceId", "ExternalId"));
                }
                resultSet.close();
            }
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantResourcePermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<Resource> getResourcesByResourceSysPermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, Id<DomainId> resourceDomainId, ResourcePermission resourcePermission) {
        HashSet<Resource> hashSet;
        if (!resourcePermission.isSystemPermission()) {
            throw new IllegalArgumentException("Permission: " + resourcePermission + " is not a system permission");
        }
        SQLStatement statement = null;
        try {
            Set<Id<ResourceId>> accessorResourceIds = NonRecursivePersisterHelper.getInheritedAccessorResourceIds(this.sqlStrings, connection, accessorResource);
            Set<Id<DomainId>> descendantDomainIds = NonRecursivePersisterHelper.getDescendantDomainIdsOrderedByAscendingLevel(this.sqlStrings, connection, resourceDomainId);
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermissionSys_withoutInheritance_ResourceID_ExternalID_BY_AccessorID_DomainID_ResourceClassID_SysPermissionID_IsWithGrant);
            for (Id<ResourceId> accessorResourceId : accessorResourceIds) {
                for (Id<DomainId> descendantDomainId : descendantDomainIds) {
                    statement.setResourceId(1, accessorResourceId);
                    statement.setResourceDomainId(2, descendantDomainId);
                    statement.setResourceClassId(3, resourceClassId);
                    statement.setResourceSystemPermissionId(4, resourcePermission.getSystemPermissionId());
                    statement.setBoolean(5, resourcePermission.isWithGrantOption());
                    SQLResult resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        resources.add(resultSet.getResource("ResourceId", "ExternalId"));
                    }
                    resultSet.close();
                }
            }
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantResourcePermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<ResourcePermission> getResourceSysPermissionsIncludeInherited(SQLConnection connection, Resource accessorResource, Resource accessedResource) {
        HashSet<ResourcePermission> hashSet;
        SQLStatement statement = null;
        try {
            Set<Id<ResourceId>> accessorResourceIds = NonRecursivePersisterHelper.getInheritedAccessorResourceIds(this.sqlStrings, connection, accessorResource);
            HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermissionSys_withoutInheritance_ResourceClassName_SysPermissionID_IsWithGrant_BY_AccessorID_AccessedID);
            for (Id<ResourceId> accessorResourceId : accessorResourceIds) {
                statement.setResourceId(1, accessorResourceId);
                statement.setResourceId(2, accessedResource);
                SQLResult resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    resourcePermissions.add(NonRecursiveGrantResourcePermissionSysPersister.getResourceSysPermission(resultSet));
                }
                resultSet.close();
            }
            hashSet = resourcePermissions;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveGrantResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveGrantResourcePermissionSysPersister.closeStatement(statement);
        return hashSet;
    }
}

