/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.sql.internal.persister.Persister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceId;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class NonRecursivePersisterHelper {
    protected static Set<Id<ResourceId>> getInheritedAccessorResourceIds(SQLStrings sqlStrings, SQLConnection connection, Resource accessorResource) {
        SQLStatement statement = null;
        HashSet<Id<ResourceId>> allAccessorResourceIds = new HashSet<Id<ResourceId>>();
        allAccessorResourceIds.add(Id.from(accessorResource.getId()));
        HashSet previousAccessorResourceIds = new HashSet(allAccessorResourceIds);
        try {
            statement = connection.prepareStatement(sqlStrings.SQL_findInGrantResourcePermissionSys_directInheritance_ResourceID_BY_AccessorID);
            while (!previousAccessorResourceIds.isEmpty()) {
                HashSet<Id<ResourceId>> newestAccessorResourceIds = new HashSet<Id<ResourceId>>();
                for (Id accessorResourceId : previousAccessorResourceIds) {
                    statement.setResourceId(1, accessorResourceId);
                    SQLResult resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        newestAccessorResourceIds.add(resultSet.getResourceId("ResourceId"));
                    }
                    resultSet.close();
                }
                allAccessorResourceIds.addAll(newestAccessorResourceIds);
                previousAccessorResourceIds = newestAccessorResourceIds;
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Persister.closeStatement(statement);
                throw throwable;
            }
        }
        Persister.closeStatement(statement);
        return allAccessorResourceIds;
    }

    protected static Set<Id<DomainId>> getDescendantDomainIdsOrderedByAscendingLevel(SQLStrings sqlStrings, SQLConnection connection, Id<DomainId> parentDomainId) {
        SQLStatement statement = null;
        LinkedHashSet<Id<DomainId>> allDomainIds = new LinkedHashSet<Id<DomainId>>();
        allDomainIds.add(parentDomainId);
        HashSet previousDomainIds = new HashSet(allDomainIds);
        try {
            statement = connection.prepareStatement(sqlStrings.SQL_findInDomain_DirectDescendantResourceDomainName_BY_DomainID);
            while (!previousDomainIds.isEmpty()) {
                HashSet<Id<DomainId>> newestDomainIds = new HashSet<Id<DomainId>>();
                for (Id domainId : previousDomainIds) {
                    statement.setResourceDomainId(1, domainId);
                    SQLResult resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        newestDomainIds.add(resultSet.getResourceDomainId("DomainId"));
                    }
                    resultSet.close();
                }
                allDomainIds.addAll(newestDomainIds);
                previousDomainIds = newestDomainIds;
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Persister.closeStatement(statement);
                throw throwable;
            }
        }
        Persister.closeStatement(statement);
        return allDomainIds;
    }

    protected static Set<String> getDescendantDomainNames(SQLStrings sqlStrings, SQLConnection connection, String parentDomainName) {
        SQLStatement statement = null;
        HashSet<String> allDomainNames = new HashSet<String>();
        allDomainNames.add(parentDomainName);
        HashSet previousDomainNames = new HashSet(allDomainNames);
        try {
            statement = connection.prepareStatement(sqlStrings.SQL_findInDomain_DirectDescendantResourceDomainName_BY_ResourceDomainName);
            while (!previousDomainNames.isEmpty()) {
                HashSet<String> newestDomainNames = new HashSet<String>();
                for (String domainName : previousDomainNames) {
                    statement.setString(1, domainName);
                    SQLResult resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        newestDomainNames.add(resultSet.getString("DomainName"));
                    }
                    resultSet.close();
                }
                allDomainNames.addAll(newestDomainNames);
                previousDomainNames = newestDomainNames;
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Persister.closeStatement(statement);
                throw throwable;
            }
        }
        Persister.closeStatement(statement);
        return allDomainNames;
    }

    protected static Set<Id<DomainId>> getAncestorDomainIds(SQLStrings sqlStrings, SQLConnection connection, Id<DomainId> domainId) {
        SQLStatement statement = null;
        HashSet<Id<DomainId>> ancestorDomainIds = new HashSet<Id<DomainId>>();
        ancestorDomainIds.add(domainId);
        int previousSize = 0;
        try {
            statement = connection.prepareStatement(sqlStrings.SQL_findInDomain_ParentResourceDomainName_BY_DomainID);
            Id<DomainId> parentDomainId = domainId;
            while (previousSize < ancestorDomainIds.size()) {
                previousSize = ancestorDomainIds.size();
                statement.setResourceDomainId(1, parentDomainId);
                SQLResult resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    parentDomainId = resultSet.getResourceDomainId("DomainId");
                    ancestorDomainIds.add(parentDomainId);
                }
                resultSet.close();
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Persister.closeStatement(statement);
                throw throwable;
            }
        }
        Persister.closeStatement(statement);
        return ancestorDomainIds;
    }
}

