/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.CommonResourcePersister;
import com.acciente.oacc.sql.internal.persister.NonRecursivePersisterHelper;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Set;

public class NonRecursiveResourcePersister
extends CommonResourcePersister
implements Serializable {
    private static final long serialVersionUID = 1L;

    public NonRecursiveResourcePersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        super(sqlProfile, sqlStrings);
    }

    @Override
    public boolean isDomainEmpty(SQLConnection connection, Id<DomainId> domainId) {
        boolean bl;
        SQLStatement statement = null;
        try {
            boolean isEmpty = true;
            Set<Id<DomainId>> descendantDomainIds = NonRecursivePersisterHelper.getDescendantDomainIdsOrderedByAscendingLevel(this.sqlStrings, connection, domainId);
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResource_withoutInheritance_COUNTResourceID_BY_DomainID);
            for (Id<DomainId> descendantDomainId : descendantDomainIds) {
                statement.setResourceDomainId(1, descendantDomainId);
                SQLResult resultSet = statement.executeQuery();
                if (!resultSet.next()) {
                    throw new IllegalArgumentException("Could not read resource count for domain: " + domainId);
                }
                int count = resultSet.getInteger("COUNTResourceID");
                resultSet.close();
                if (count <= 0) continue;
                isEmpty = false;
                break;
            }
            bl = isEmpty;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveResourcePersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveResourcePersister.closeStatement(statement);
        return bl;
    }
}

