/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.CommonDomainPersister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class RecursiveDomainPersister
extends CommonDomainPersister
implements Serializable {
    private static final long serialVersionUID = 1L;

    public RecursiveDomainPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        super(sqlProfile, sqlStrings);
    }

    @Override
    public Set<String> getResourceDomainNameDescendants(SQLConnection connection, String resourceDomainName) {
        HashSet<String> hashSet;
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInDomain_DescendantResourceDomainName_BY_ResourceDomainName);
            statement.setString(1, resourceDomainName);
            SQLResult resultSet = statement.executeQuery();
            HashSet<String> resourceDomainNameDescendants = new HashSet<String>();
            while (resultSet.next()) {
                resourceDomainNameDescendants.add(resultSet.getString("DomainName"));
            }
            hashSet = resourceDomainNameDescendants;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveDomainPersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveDomainPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public void deleteDomain(SQLConnection connection, Id<DomainId> domainId) {
        SQLStatement statement;
        block8: {
            statement = null;
            try {
                if (this.sqlProfile.isRecursiveDeleteEnabled()) {
                    statement = connection.prepareStatement(this.sqlStrings.SQL_removeInDomain_withDescendants_BY_DomainID);
                    statement.setResourceDomainId(1, domainId);
                    int rowCount = statement.executeUpdate();
                    if (rowCount < 1) {
                        throw new IllegalStateException("Security table data update, 1 or more rows expected, got: " + rowCount);
                    }
                    break block8;
                }
                statement = connection.prepareStatement(this.sqlStrings.SQL_findInDomain_DescendantResourceDomainID_BY_DomainID_ORDERBY_DomainLevel);
                statement.setResourceDomainId(1, domainId);
                SQLResult resultSet = statement.executeQuery();
                ArrayList<Id<DomainId>> descendantDomainIds = new ArrayList<Id<DomainId>>();
                while (resultSet.next()) {
                    descendantDomainIds.add(resultSet.getResourceDomainId("DomainId"));
                }
                RecursiveDomainPersister.closeStatement(statement);
                statement = connection.prepareStatement(this.sqlStrings.SQL_removeInDomain_BY_DomainID);
                for (int i = descendantDomainIds.size() - 1; i >= 0; --i) {
                    statement.setResourceDomainId(1, (Id)descendantDomainIds.get(i));
                    this.assertOneRowUpdated(statement.executeUpdate());
                }
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    RecursiveDomainPersister.closeStatement(statement);
                    throw throwable;
                }
            }
        }
        RecursiveDomainPersister.closeStatement(statement);
    }
}

