/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.DomainPermission;
import com.acciente.oacc.Resource;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.CommonGrantDomainPermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RecursiveGrantDomainPermissionSysPersister
extends CommonGrantDomainPermissionSysPersister
implements Serializable {
    private static final long serialVersionUID = 1L;

    public RecursiveGrantDomainPermissionSysPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        super(sqlProfile, sqlStrings);
    }

    @Override
    public Set<Resource> getResourcesByDomainSuperUserPermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId) {
        HashSet<Resource> hashSet;
        SQLStatement statement = null;
        try {
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantDomainPermissionSys_ResourceID_ExternalId_BY_AccessorID_SysPermissionID_IsWithGrant_ResourceClassID);
            statement.setResourceId(1, accessorResource);
            statement.setDomainSystemPermissionId(2, DOMAIN_PERMISSION_SUPER_USER.getSystemPermissionId());
            statement.setBoolean(3, false);
            statement.setResourceClassId(4, resourceClassId);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resources.add(resultSet.getResource("ResourceId", "ExternalId"));
            }
            resultSet.close();
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<Resource> getResourcesByDomainSuperUserPermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, Id<DomainId> resourceDomainId) {
        HashSet<Resource> hashSet;
        SQLStatement statement = null;
        try {
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantDomainPermissionSys_ResourceID_ExternalID_BY_AccessorID_DomainID_SysPermissionID_IsWithGrant_ResourceClassID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceDomainId(2, resourceDomainId);
            statement.setDomainSystemPermissionId(3, DOMAIN_PERMISSION_SUPER_USER.getSystemPermissionId());
            statement.setBoolean(4, false);
            statement.setResourceClassId(5, resourceClassId);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resources.add(resultSet.getResource("ResourceId", "ExternalId"));
            }
            resultSet.close();
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<DomainPermission> getDomainSysPermissionsIncludeInherited(SQLConnection connection, Resource accessorResource, Id<DomainId> resourceDomainId) {
        HashSet<DomainPermission> hashSet;
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantDomainPermissionSys_SysPermissionID_IsWithGrant_BY_AccessorID_DomainID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceDomainId(2, resourceDomainId);
            SQLResult resultSet = statement.executeQuery();
            HashSet<DomainPermission> domainPermissions = new HashSet<DomainPermission>();
            while (resultSet.next()) {
                domainPermissions.add(RecursiveGrantDomainPermissionSysPersister.getDomainSysPermission(resultSet));
            }
            resultSet.close();
            hashSet = domainPermissions;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Map<String, Set<DomainPermission>> getDomainSysPermissionsIncludeInherited(SQLConnection connection, Resource accessorResource) {
        HashMap<String, Set<DomainPermission>> hashMap;
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantDomainPermissionSys_ResourceDomainName_SysPermissionID_IsWithGrant_BY_AccessorID);
            statement.setResourceId(1, accessorResource);
            SQLResult resultSet = statement.executeQuery();
            HashMap<String, Set<DomainPermission>> domainPermissionsMap = new HashMap<String, Set<DomainPermission>>();
            while (resultSet.next()) {
                String resourceDomainName = resultSet.getString("DomainName");
                HashSet<DomainPermission> domainPermissions = (HashSet<DomainPermission>)domainPermissionsMap.get(resourceDomainName);
                if (domainPermissions == null) {
                    domainPermissions = new HashSet<DomainPermission>();
                    domainPermissionsMap.put(resourceDomainName, domainPermissions);
                }
                domainPermissions.add(RecursiveGrantDomainPermissionSysPersister.getDomainSysPermission(resultSet));
            }
            resultSet.close();
            hashMap = domainPermissionsMap;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
        return hashMap;
    }

    @Override
    public void removeAllDomainSysPermissions(SQLConnection connection, Id<DomainId> domainId) {
        SQLStatement statement;
        block7: {
            statement = null;
            try {
                if (this.sqlProfile.isRecursiveDeleteEnabled()) {
                    statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantDomainPermissionSys_withDescendants_BY_AccessedDomainID);
                    statement.setResourceDomainId(1, domainId);
                    statement.executeUpdate();
                    break block7;
                }
                statement = connection.prepareStatement(this.sqlStrings.SQL_findInDomain_DescendantResourceDomainID_BY_DomainID_ORDERBY_DomainLevel);
                statement.setResourceDomainId(1, domainId);
                SQLResult resultSet = statement.executeQuery();
                ArrayList<Id<DomainId>> descendantDomainIds = new ArrayList<Id<DomainId>>();
                while (resultSet.next()) {
                    descendantDomainIds.add(resultSet.getResourceDomainId("DomainId"));
                }
                RecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
                statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantDomainPermissionSys_BY_AccessedDomainID);
                for (int i = descendantDomainIds.size() - 1; i >= 0; --i) {
                    statement.setResourceDomainId(1, (Id)descendantDomainIds.get(i));
                    statement.executeUpdate();
                }
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    RecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
                    throw throwable;
                }
            }
        }
        RecursiveGrantDomainPermissionSysPersister.closeStatement(statement);
    }
}

