/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.ResourcePermission;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.CommonGrantGlobalResourcePermissionPersister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import com.acciente.oacc.sql.internal.persister.id.ResourcePermissionId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RecursiveGrantGlobalResourcePermissionPersister
extends CommonGrantGlobalResourcePermissionPersister
implements Serializable {
    private static final long serialVersionUID = 1L;

    public RecursiveGrantGlobalResourcePermissionPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        super(sqlProfile, sqlStrings);
    }

    @Override
    public Set<Resource> getResourcesByGlobalResourcePermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, ResourcePermission resourcePermission, Id<ResourcePermissionId> resourcePermissionId) {
        HashSet<Resource> hashSet;
        if (resourcePermission.isSystemPermission()) {
            throw new IllegalArgumentException("Permission: " + resourcePermission + " is not a non-system permission");
        }
        SQLStatement statement = null;
        try {
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantGlobalResourcePermission_ResourceID_ExternalID_BY_AccessorID_ResourceClassID_PermissionID_IsWithGrant_ResourceClassID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceClassId(2, resourceClassId);
            statement.setResourcePermissionId(3, resourcePermissionId);
            statement.setBoolean(4, resourcePermission.isWithGrantOption());
            statement.setResourceClassId(5, resourceClassId);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resources.add(resultSet.getResource("ResourceId", "ExternalId"));
            }
            resultSet.close();
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveGrantGlobalResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveGrantGlobalResourcePermissionPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<Resource> getResourcesByGlobalResourcePermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, Id<DomainId> resourceDomainId, ResourcePermission resourcePermission, Id<ResourcePermissionId> resourcePermissionId) {
        HashSet<Resource> hashSet;
        if (resourcePermission.isSystemPermission()) {
            throw new IllegalArgumentException("Permission: " + resourcePermission + " is not a non-system permission");
        }
        SQLStatement statement = null;
        try {
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantGlobalResourcePermission_ResourceID_ExternalID_BY_AccessorID_DomainID_ResourceClassID_PermissionID_IsWithGrant_ResourceClassID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceDomainId(2, resourceDomainId);
            statement.setResourceClassId(3, resourceClassId);
            statement.setResourcePermissionId(4, resourcePermissionId);
            statement.setBoolean(5, resourcePermission.isWithGrantOption());
            statement.setResourceClassId(6, resourceClassId);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resources.add(resultSet.getResource("ResourceId", "ExternalId"));
            }
            resultSet.close();
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveGrantGlobalResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveGrantGlobalResourcePermissionPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<ResourcePermission> getGlobalResourcePermissionsIncludeInherited(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, Id<DomainId> resourceDomainId) {
        HashSet<ResourcePermission> hashSet;
        SQLStatement statement = null;
        try {
            HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantGlobalResourcePermission_PermissionName_IsWithGrant_BY_AccessorID_AccessedDomainID_ResourceClassID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceDomainId(2, resourceDomainId);
            statement.setResourceClassId(3, resourceClassId);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resourcePermissions.add(RecursiveGrantGlobalResourcePermissionPersister.getResourcePermission(resultSet));
            }
            resultSet.close();
            hashSet = resourcePermissions;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveGrantGlobalResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveGrantGlobalResourcePermissionPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Map<String, Map<String, Set<ResourcePermission>>> getGlobalResourcePermissionsIncludeInherited(SQLConnection connection, Resource accessorResource) {
        HashMap<String, Map<String, Set<ResourcePermission>>> hashMap;
        SQLStatement statement = null;
        try {
            HashMap<String, Map<String, Set<ResourcePermission>>> globalPermissionsMap = new HashMap<String, Map<String, Set<ResourcePermission>>>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantGlobalResourcePermission_ResourceDomainName_ResourceClassName_PermissionName_IsWithGrant_BY_AccessorID);
            statement.setResourceId(1, accessorResource);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                HashSet<ResourcePermission> resourcePermissionsForResourceClass;
                String resourceDomainName = resultSet.getString("DomainName");
                String resourceClassName = resultSet.getString("ResourceClassName");
                HashMap<String, HashSet<ResourcePermission>> permissionsForResourceDomain = (HashMap<String, HashSet<ResourcePermission>>)globalPermissionsMap.get(resourceDomainName);
                if (permissionsForResourceDomain == null) {
                    permissionsForResourceDomain = new HashMap<String, HashSet<ResourcePermission>>();
                    globalPermissionsMap.put(resourceDomainName, permissionsForResourceDomain);
                }
                if ((resourcePermissionsForResourceClass = (HashSet<ResourcePermission>)permissionsForResourceDomain.get(resourceClassName)) == null) {
                    resourcePermissionsForResourceClass = new HashSet<ResourcePermission>();
                    permissionsForResourceDomain.put(resourceClassName, resourcePermissionsForResourceClass);
                }
                resourcePermissionsForResourceClass.add(RecursiveGrantGlobalResourcePermissionPersister.getResourcePermission(resultSet));
            }
            resultSet.close();
            hashMap = globalPermissionsMap;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveGrantGlobalResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveGrantGlobalResourcePermissionPersister.closeStatement(statement);
        return hashMap;
    }

    @Override
    public void removeAllGlobalResourcePermissions(SQLConnection connection, Id<DomainId> accessedDomainId) {
        SQLStatement statement;
        block7: {
            statement = null;
            try {
                if (this.sqlProfile.isRecursiveDeleteEnabled()) {
                    statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantGlobalResourcePermission_withDescendants_BY_AccessedDomainId);
                    statement.setResourceDomainId(1, accessedDomainId);
                    statement.executeUpdate();
                    break block7;
                }
                statement = connection.prepareStatement(this.sqlStrings.SQL_findInDomain_DescendantResourceDomainID_BY_DomainID_ORDERBY_DomainLevel);
                statement.setResourceDomainId(1, accessedDomainId);
                SQLResult resultSet = statement.executeQuery();
                ArrayList<Id<DomainId>> descendantDomainIds = new ArrayList<Id<DomainId>>();
                while (resultSet.next()) {
                    descendantDomainIds.add(resultSet.getResourceDomainId("DomainId"));
                }
                RecursiveGrantGlobalResourcePermissionPersister.closeStatement(statement);
                statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantGlobalResourcePermission_BY_AccessedDomainId);
                for (int i = descendantDomainIds.size() - 1; i >= 0; --i) {
                    statement.setResourceDomainId(1, (Id)descendantDomainIds.get(i));
                    statement.executeUpdate();
                }
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    RecursiveGrantGlobalResourcePermissionPersister.closeStatement(statement);
                    throw throwable;
                }
            }
        }
        RecursiveGrantGlobalResourcePermissionPersister.closeStatement(statement);
    }
}

