/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.ResourcePermission;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.CommonGrantResourcePermissionPersister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import com.acciente.oacc.sql.internal.persister.id.ResourcePermissionId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class RecursiveGrantResourcePermissionPersister
extends CommonGrantResourcePermissionPersister
implements Serializable {
    private static final long serialVersionUID = 1L;

    public RecursiveGrantResourcePermissionPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        super(sqlProfile, sqlStrings);
    }

    @Override
    public Set<Resource> getResourcesByResourcePermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, ResourcePermission resourcePermission, Id<ResourcePermissionId> resourcePermissionId) {
        HashSet<Resource> hashSet;
        if (resourcePermission.isSystemPermission()) {
            throw new IllegalArgumentException("Permission: " + resourcePermission + " is not a non-system permission");
        }
        SQLStatement statement = null;
        try {
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermission_ResourceID_ExternalID_BY_AccessorID_ResourceClassID_PermissionID_IsWithGrant);
            statement.setResourceId(1, accessorResource);
            statement.setResourceClassId(2, resourceClassId);
            statement.setResourcePermissionId(3, resourcePermissionId);
            statement.setBoolean(4, resourcePermission.isWithGrantOption());
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resources.add(resultSet.getResource("ResourceId", "ExternalId"));
            }
            resultSet.close();
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveGrantResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveGrantResourcePermissionPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<Resource> getResourcesByResourcePermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, Id<DomainId> resourceDomainId, ResourcePermission resourcePermission, Id<ResourcePermissionId> resourcePermissionId) {
        HashSet<Resource> hashSet;
        if (resourcePermission.isSystemPermission()) {
            throw new IllegalArgumentException("Permission: " + resourcePermission + " is not a non-system permission");
        }
        SQLStatement statement = null;
        try {
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermission_ResourceID_ExternalID_BY_AccessorID_DomainID_ResourceClassID_PermissionID_IsWithGrant);
            statement.setResourceId(1, accessorResource);
            statement.setResourceDomainId(2, resourceDomainId);
            statement.setResourceClassId(3, resourceClassId);
            statement.setResourcePermissionId(4, resourcePermissionId);
            statement.setBoolean(5, resourcePermission.isWithGrantOption());
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resources.add(resultSet.getResource("ResourceId", "ExternalId"));
            }
            resultSet.close();
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveGrantResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveGrantResourcePermissionPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<ResourcePermission> getResourcePermissionsIncludeInherited(SQLConnection connection, Resource accessorResource, Resource accessedResource) {
        HashSet<ResourcePermission> hashSet;
        SQLStatement statement = null;
        try {
            HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermission_ResourceClassName_PermissionName_IsWithGrant_BY_AccessorID_AccessedID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceId(2, accessedResource);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resourcePermissions.add(RecursiveGrantResourcePermissionPersister.getResourcePermission(resultSet));
            }
            resultSet.close();
            hashSet = resourcePermissions;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveGrantResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveGrantResourcePermissionPersister.closeStatement(statement);
        return hashSet;
    }
}

