/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.ResourcePermission;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.CommonGrantResourcePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class RecursiveGrantResourcePermissionSysPersister
extends CommonGrantResourcePermissionSysPersister
implements Serializable {
    private static final long serialVersionUID = 1L;

    public RecursiveGrantResourcePermissionSysPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        super(sqlProfile, sqlStrings);
    }

    @Override
    public Set<Resource> getResourcesByResourceSysPermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, ResourcePermission resourcePermission) {
        HashSet<Resource> hashSet;
        if (!resourcePermission.isSystemPermission()) {
            throw new IllegalArgumentException("Permission: " + resourcePermission + " is not a system permission");
        }
        SQLStatement statement = null;
        try {
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermissionSys_ResourceID_ExternalID_BY_AccessorID_ResourceClassID_SysPermissionID_IsWithGrant);
            statement.setResourceId(1, accessorResource);
            statement.setResourceClassId(2, resourceClassId);
            statement.setResourceSystemPermissionId(3, resourcePermission.getSystemPermissionId());
            statement.setBoolean(4, resourcePermission.isWithGrantOption());
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resources.add(resultSet.getResource("ResourceId", "ExternalId"));
            }
            resultSet.close();
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveGrantResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveGrantResourcePermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<Resource> getResourcesByResourceSysPermission(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, Id<DomainId> resourceDomainId, ResourcePermission resourcePermission) {
        HashSet<Resource> hashSet;
        if (!resourcePermission.isSystemPermission()) {
            throw new IllegalArgumentException("Permission: " + resourcePermission + " is not a system permission");
        }
        SQLStatement statement = null;
        try {
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermissionSys_ResourceID_ExternalID_BY_AccessorID_DomainID_ResourceClassID_SysPermissionID_IsWithGrant);
            statement.setResourceId(1, accessorResource);
            statement.setResourceDomainId(2, resourceDomainId);
            statement.setResourceClassId(3, resourceClassId);
            statement.setResourceSystemPermissionId(4, resourcePermission.getSystemPermissionId());
            statement.setBoolean(5, resourcePermission.isWithGrantOption());
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resources.add(resultSet.getResource("ResourceId", "ExternalId"));
            }
            resultSet.close();
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveGrantResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveGrantResourcePermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public Set<ResourcePermission> getResourceSysPermissionsIncludeInherited(SQLConnection connection, Resource accessorResource, Resource accessedResource) {
        HashSet<ResourcePermission> hashSet;
        SQLStatement statement = null;
        try {
            HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermissionSys_ResourceClassName_SysPermissionID_IsWithGrant_BY_AccessorID_AccessedID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceId(2, accessedResource);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resourcePermissions.add(RecursiveGrantResourcePermissionSysPersister.getResourceSysPermission(resultSet));
            }
            resultSet.close();
            hashSet = resourcePermissions;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveGrantResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveGrantResourcePermissionSysPersister.closeStatement(statement);
        return hashSet;
    }
}

