/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.CommonResourcePersister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import java.io.Serializable;
import java.sql.SQLException;

public class RecursiveResourcePersister
extends CommonResourcePersister
implements Serializable {
    private static final long serialVersionUID = 1L;

    public RecursiveResourcePersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        super(sqlProfile, sqlStrings);
    }

    @Override
    public boolean isDomainEmpty(SQLConnection connection, Id<DomainId> resourceDomainId) {
        boolean bl;
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResource_COUNTResourceID_BY_DomainID);
            statement.setResourceDomainId(1, resourceDomainId);
            SQLResult resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                throw new IllegalArgumentException("Could not read resource count for domain: " + resourceDomainId);
            }
            int count = resultSet.getInteger("COUNTResourceID");
            resultSet.close();
            bl = count == 0;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                RecursiveResourcePersister.closeStatement(statement);
                throw throwable;
            }
        }
        RecursiveResourcePersister.closeStatement(statement);
        return bl;
    }
}

