/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.Persister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import com.acciente.oacc.sql.internal.persister.id.ResourcePermissionId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

public class ResourceClassPermissionPersister
extends Persister
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final SQLProfile sqlProfile;
    private final SQLStrings sqlStrings;

    public ResourceClassPermissionPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        this.sqlProfile = sqlProfile;
        this.sqlStrings = sqlStrings;
    }

    public Id<ResourcePermissionId> getResourceClassPermissionId(SQLConnection connection, Id<ResourceClassId> resourceClassId, String permissionName) {
        Id<ResourcePermissionId> id;
        SQLStatement statement = null;
        try {
            Id<ResourcePermissionId> permissionId = null;
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResourceClassPermission_PermissionID_BY_ResourceClassID_PermissionName);
            statement.setResourceClassId(1, resourceClassId);
            statement.setString(2, permissionName);
            SQLResult resultSet = statement.executeQuery();
            if (resultSet.next()) {
                permissionId = resultSet.getResourcePermissionId("PermissionId");
            }
            resultSet.close();
            id = permissionId;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ResourceClassPermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        ResourceClassPermissionPersister.closeStatement(statement);
        return id;
    }

    public List<String> getPermissionNames(SQLConnection connection, String resourceClassName) {
        LinkedList<String> linkedList;
        SQLStatement statement = null;
        try {
            LinkedList<String> resourceClassNames = new LinkedList<String>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResourceClassPermission_PermissionName_BY_ResourceClassName);
            statement.setString(1, resourceClassName);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resourceClassNames.add(resultSet.getString("PermissionName"));
            }
            linkedList = resourceClassNames;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ResourceClassPermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        ResourceClassPermissionPersister.closeStatement(statement);
        return linkedList;
    }

    public void addResourceClassPermission(SQLConnection connection, Id<ResourceClassId> resourceClassId, String permissionName) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_createInResourceClassPermission_WITH_ResourceClassID_PermissionName);
            statement.setResourceClassId(1, resourceClassId);
            statement.setString(2, permissionName);
            this.assertOneRowInserted(statement.executeUpdate());
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ResourceClassPermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        ResourceClassPermissionPersister.closeStatement(statement);
    }
}

