/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.ResourceClassInternalInfo;
import com.acciente.oacc.sql.internal.persister.Persister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

public class ResourceClassPersister
extends Persister
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final SQLProfile sqlProfile;
    private final SQLStrings sqlStrings;

    public ResourceClassPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        this.sqlProfile = sqlProfile;
        this.sqlStrings = sqlStrings;
    }

    public Id<ResourceClassId> getResourceClassId(SQLConnection connection, String resourceClassName) {
        Id<ResourceClassId> id;
        SQLStatement statement = null;
        try {
            Id<ResourceClassId> resourceClassId = null;
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResourceClass_ResourceClassID_BY_ResourceClassName);
            statement.setString(1, resourceClassName);
            SQLResult resultSet = statement.executeQuery();
            if (resultSet.next()) {
                resourceClassId = resultSet.getResourceClassId("ResourceClassId");
            }
            id = resourceClassId;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ResourceClassPersister.closeStatement(statement);
                throw throwable;
            }
        }
        ResourceClassPersister.closeStatement(statement);
        return id;
    }

    public ResourceClassInternalInfo getResourceClassInfo(SQLConnection connection, String resourceClassName) {
        ResourceClassInternalInfo resourceClassInternalInfo;
        SQLStatement statement = null;
        if (resourceClassName == null) {
            throw new IllegalArgumentException("Resource class name cannot be null");
        }
        try {
            ResourceClassInternalInfo resourceClassInternalInfo2 = null;
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResourceClass_ResourceClassID_ResourceClassName_IsAuthenticatable_IsUnauthenticatedCreateAllowed_BY_ResourceClassName);
            statement.setString(1, resourceClassName.trim());
            SQLResult resultSet = statement.executeQuery();
            if (resultSet.next()) {
                resourceClassInternalInfo2 = new ResourceClassInternalInfo(resultSet.getResourceClassId("ResourceClassId"), resultSet.getString("ResourceClassName"), resultSet.getBoolean("IsAuthenticatable"), resultSet.getBoolean("IsUnauthenticatedCreateAllowed"));
            }
            resourceClassInternalInfo = resourceClassInternalInfo2;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ResourceClassPersister.closeStatement(statement);
                throw throwable;
            }
        }
        ResourceClassPersister.closeStatement(statement);
        return resourceClassInternalInfo;
    }

    public ResourceClassInternalInfo getResourceClassInfoByResourceId(SQLConnection connection, Resource resource) {
        ResourceClassInternalInfo resourceClassInternalInfo;
        SQLStatement statement = null;
        try {
            ResourceClassInternalInfo resourceClassInternalInfo2 = null;
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResourceClass_ResourceClassID_ResourceClassName_IsAuthenticatable_IsUnauthenticatedCreateAllowed_BY_ResourceID);
            statement.setResourceId(1, resource);
            SQLResult resultSet = statement.executeQuery();
            if (resultSet.next()) {
                resourceClassInternalInfo2 = new ResourceClassInternalInfo(resultSet.getResourceClassId("ResourceClassId"), resultSet.getString("ResourceClassName"), resultSet.getBoolean("IsAuthenticatable"), resultSet.getBoolean("IsUnauthenticatedCreateAllowed"));
            }
            if (resourceClassInternalInfo2 == null) {
                throw new IllegalArgumentException("Could not determine resource class for resource: " + resource);
            }
            resourceClassInternalInfo = resourceClassInternalInfo2;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ResourceClassPersister.closeStatement(statement);
                throw throwable;
            }
        }
        ResourceClassPersister.closeStatement(statement);
        return resourceClassInternalInfo;
    }

    public List<String> getResourceClassNames(SQLConnection connection) {
        LinkedList<String> linkedList;
        SQLStatement statement = null;
        try {
            LinkedList<String> resourceClassNames = new LinkedList<String>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResourceClass_ResourceClassName_BY_ALL);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resourceClassNames.add(resultSet.getString("ResourceClassName"));
            }
            linkedList = resourceClassNames;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ResourceClassPersister.closeStatement(statement);
                throw throwable;
            }
        }
        ResourceClassPersister.closeStatement(statement);
        return linkedList;
    }

    public void addResourceClass(SQLConnection connection, String resourceClassName, boolean authenticatable, boolean nonAuthenticatedCreateAllowed) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_createInResourceClass_WITH_ResourceClassName_IsAuthenticatable_IsUnauthenticatedCreateAllowed);
            statement.setString(1, resourceClassName);
            statement.setBoolean(2, authenticatable);
            statement.setBoolean(3, nonAuthenticatedCreateAllowed);
            this.assertOneRowInserted(statement.executeUpdate());
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ResourceClassPersister.closeStatement(statement);
                throw throwable;
            }
        }
        ResourceClassPersister.closeStatement(statement);
    }
}

