/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.sql.internal.persister.Persister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLPasswordStrings;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceId;
import java.io.Serializable;
import java.sql.SQLException;

public class ResourcePasswordPersister
extends Persister
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SQLPasswordStrings sqlPasswordStrings;

    public ResourcePasswordPersister(SQLPasswordStrings sqlPasswordStrings) {
        this.sqlPasswordStrings = sqlPasswordStrings;
    }

    public String getEncryptedBoundPasswordByResourceId(SQLConnection connection, Resource resource) {
        String string;
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlPasswordStrings.SQL_findInResourcePassword_Password_BY_ResourceID);
            statement.setResourceId(1, resource);
            SQLResult resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                throw new IllegalArgumentException(resource + " not found!");
            }
            String encryptedBoundPassword = resultSet.getString("Password");
            if (encryptedBoundPassword == null) {
                throw new IllegalStateException(resource + " has no password set!");
            }
            if (resultSet.next()) {
                throw new IllegalStateException(resource + " maps to more than one resource!");
            }
            string = encryptedBoundPassword;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ResourcePasswordPersister.closeStatement(statement);
                throw throwable;
            }
        }
        ResourcePasswordPersister.closeStatement(statement);
        return string;
    }

    public void setEncryptedBoundPasswordByResourceId(SQLConnection connection, Resource resource, String newEncryptedBoundPassword) {
        this.__setEncryptedBoundPasswordByResourceId(connection, Id.from(resource.getId()), newEncryptedBoundPassword);
    }

    public void setEncryptedBoundPasswordByResourceId(SQLConnection connection, Id<ResourceId> resourceId, String newEncryptedBoundPassword) {
        this.__setEncryptedBoundPasswordByResourceId(connection, resourceId, newEncryptedBoundPassword);
    }

    private void __setEncryptedBoundPasswordByResourceId(SQLConnection connection, Id<ResourceId> resourceId, String newEncryptedBoundPassword) {
        SQLStatement updateStatement;
        SQLStatement insertStatement;
        SQLStatement finderStatement;
        block6: {
            finderStatement = null;
            insertStatement = null;
            updateStatement = null;
            try {
                finderStatement = connection.prepareStatement(this.sqlPasswordStrings.SQL_findInResourcePassword_Password_BY_ResourceID);
                finderStatement.setResourceId(1, resourceId);
                SQLResult resultSet = finderStatement.executeQuery();
                if (!resultSet.next()) {
                    insertStatement = connection.prepareStatement(this.sqlPasswordStrings.SQL_createInResourcePassword_WITH_ResourceID_Password);
                    insertStatement.setResourceId(1, resourceId);
                    insertStatement.setString(2, newEncryptedBoundPassword);
                    this.assertOneRowInserted(insertStatement.executeUpdate());
                    break block6;
                }
                if (resultSet.next()) {
                    throw new IllegalStateException("ResourceId " + resourceId + " maps to more than one resource!");
                }
                updateStatement = connection.prepareStatement(this.sqlPasswordStrings.SQL_updateInResourcePassword_Password_BY_ResourceID);
                updateStatement.setString(1, newEncryptedBoundPassword);
                updateStatement.setResourceId(2, resourceId);
                this.assertOneRowUpdated(updateStatement.executeUpdate());
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    ResourcePasswordPersister.closeStatement(finderStatement);
                    ResourcePasswordPersister.closeStatement(insertStatement);
                    ResourcePasswordPersister.closeStatement(updateStatement);
                    throw throwable;
                }
            }
        }
        ResourcePasswordPersister.closeStatement(finderStatement);
        ResourcePasswordPersister.closeStatement(insertStatement);
        ResourcePasswordPersister.closeStatement(updateStatement);
    }

    public void removeEncryptedBoundPasswordByResourceId(SQLConnection connection, Resource resource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlPasswordStrings.SQL_removeInResourcePassword_BY_ResourceID);
            statement.setResourceId(1, resource);
            this.assertOneRowUpdated(statement.executeUpdate());
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ResourcePasswordPersister.closeStatement(statement);
                throw throwable;
            }
        }
        ResourcePasswordPersister.closeStatement(statement);
    }
}

