/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.DomainCreatePermissions;
import com.acciente.oacc.DomainPermissions;
import com.acciente.oacc.Resource;
import com.acciente.oacc.ResourceCreatePermissions;
import com.acciente.oacc.ResourcePermissions;
import com.acciente.oacc.Resources;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import com.acciente.oacc.sql.internal.persister.id.ResourceId;
import com.acciente.oacc.sql.internal.persister.id.ResourcePermissionId;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLResult {
    private final ResultSet resultSet;

    SQLResult(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public Id<ResourceId> getResourceId(String columnLabel) throws SQLException {
        return Id.from(this.resultSet.getLong(columnLabel));
    }

    public Resource getResource(String columnLabel) throws SQLException {
        return Resources.getInstance(this.resultSet.getLong(columnLabel));
    }

    public Resource getResource(String resourceIdColumnLabel, String externalIdColumnLabel) throws SQLException {
        return Resources.getInstance(this.resultSet.getLong(resourceIdColumnLabel), this.resultSet.getString(externalIdColumnLabel));
    }

    public Id<ResourceId> getNextResourceId(int columnIndex) throws SQLException {
        return Id.from(this.resultSet.getLong(columnIndex));
    }

    public Id<ResourceClassId> getResourceClassId(String columnLabel) throws SQLException {
        return Id.from(this.resultSet.getLong(columnLabel));
    }

    public Id<DomainId> getResourceDomainId(String columnLabel) throws SQLException {
        return Id.from(this.resultSet.getLong(columnLabel));
    }

    public Id<ResourcePermissionId> getResourcePermissionId(String columnLabel) throws SQLException {
        return Id.from(this.resultSet.getLong(columnLabel));
    }

    public String getResourceCreateSysPermissionName(String columnLabel) throws SQLException {
        return ResourceCreatePermissions.getSysPermissionName(this.resultSet.getLong(columnLabel));
    }

    public String getResourceSysPermissionName(String columnLabel) throws SQLException {
        return ResourcePermissions.getSysPermissionName(this.resultSet.getLong(columnLabel));
    }

    public String getDomainCreateSysPermissionName(String columnLabel) throws SQLException {
        return DomainCreatePermissions.getSysPermissionName(this.resultSet.getLong(columnLabel));
    }

    public String getDomainSysPermissionName(String columnLabel) throws SQLException {
        return DomainPermissions.getSysPermissionName(this.resultSet.getLong(columnLabel));
    }

    public Long getSysPermissionId(String columnLabel) throws SQLException {
        return this.resultSet.getLong(columnLabel);
    }

    public boolean getBoolean(String columnLabel) throws SQLException {
        return SQLResult.int2bool(this.resultSet.getInt(columnLabel));
    }

    public int getInteger(String columnLabel) throws SQLException {
        return this.resultSet.getInt(columnLabel);
    }

    public int getInteger(int columnIndex) throws SQLException {
        return this.resultSet.getInt(columnIndex);
    }

    public String getString(String columnLabel) throws SQLException {
        return this.resultSet.getString(columnLabel);
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public void close() throws SQLException {
        this.resultSet.close();
    }

    private static boolean int2bool(int value) {
        return value != 0;
    }
}

