/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import com.acciente.oacc.sql.internal.persister.id.ResourceId;
import com.acciente.oacc.sql.internal.persister.id.ResourcePermissionId;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SQLStatement {
    private final PreparedStatement statement;

    SQLStatement(PreparedStatement statement) {
        this.statement = statement;
    }

    public void setResourceId(int parameterIndex, Id<ResourceId> resourceId) throws SQLException {
        this.statement.setLong(parameterIndex, resourceId.getValue());
    }

    public void setResourceId(int parameterIndex, Resource resource) throws SQLException {
        this.statement.setLong(parameterIndex, resource.getId());
    }

    public void setResourceClassId(int parameterIndex, Id<ResourceClassId> id) throws SQLException {
        this.statement.setLong(parameterIndex, id.getValue());
    }

    public void setResourceDomainId(int parameterIndex, Id<DomainId> id) throws SQLException {
        this.statement.setLong(parameterIndex, id.getValue());
    }

    public void setResourceCreateSystemPermissionId(int parameterIndex, long resourceCreateSystemPermissionId) throws SQLException {
        this.statement.setLong(parameterIndex, resourceCreateSystemPermissionId);
    }

    public void setResourceSystemPermissionId(int parameterIndex, long resourceSystemPermissionId) throws SQLException {
        this.statement.setLong(parameterIndex, resourceSystemPermissionId);
    }

    public void setResourcePermissionId(int parameterIndex, Id<ResourcePermissionId> resourcePermissionId) throws SQLException {
        this.statement.setLong(parameterIndex, resourcePermissionId.getValue());
    }

    public void setDomainCreateSystemPermissionId(int parameterIndex, long domainCreateSystemPermissionId) throws SQLException {
        this.statement.setLong(parameterIndex, domainCreateSystemPermissionId);
    }

    public void setDomainSystemPermissionId(int parameterIndex, long domainSystemPermissionId) throws SQLException {
        this.statement.setLong(parameterIndex, domainSystemPermissionId);
    }

    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.statement.setInt(parameterIndex, SQLStatement.bool2int(value));
    }

    public void setString(int parameterIndex, String value) throws SQLException {
        this.statement.setString(parameterIndex, value);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.statement.setNull(parameterIndex, sqlType);
    }

    SQLResult executeQuery() throws SQLException {
        return new SQLResult(this.statement.executeQuery());
    }

    int executeUpdate() throws SQLException {
        return this.statement.executeUpdate();
    }

    public SQLResult getGeneratedKeys() throws SQLException {
        return new SQLResult(this.statement.getGeneratedKeys());
    }

    void close() throws SQLException {
        this.statement.close();
    }

    private static int bool2int(boolean value) {
        return value ? 1 : 0;
    }
}

