/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.annotation;

import com.alibaba.nacos.spring.context.annotation.EnableNacos;
import com.alibaba.nacos.spring.util.NacosBeanUtils;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotationMetadata;

public class NacosBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
BeanFactoryAware {
    private Environment environment;
    private BeanFactory beanFactory;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AbstractBeanDefinition annotationProcessor = BeanDefinitionBuilder.genericBeanDefinition(PropertySourcesPlaceholderConfigurer.class).getBeanDefinition();
        registry.registerBeanDefinition(PropertySourcesPlaceholderConfigurer.class.getName(), (BeanDefinition)annotationProcessor);
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableNacos.class.getName()));
        NacosBeanUtils.registerGlobalNacosProperties(attributes, registry, (PropertyResolver)this.environment, "globalNacosProperties");
        this.registerNacosAnnotationBeans(registry);
        NacosBeanUtils.invokeNacosPropertySourcePostProcessor(this.beanFactory);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerNacosAnnotationBeans(BeanDefinitionRegistry registry) {
        NacosBeanUtils.registerNacosCommonBeans(registry);
        NacosBeanUtils.registerNacosConfigBeans(registry, this.environment, this.beanFactory);
        NacosBeanUtils.registerNacosDiscoveryBeans(registry);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

