/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.annotation.config;

import com.alibaba.nacos.spring.factory.NacosServiceFactory;
import com.alibaba.nacos.spring.util.NacosBeanUtils;
import com.alibaba.nacos.spring.util.NacosUtils;
import com.alibaba.nacos.spring.util.config.NacosConfigLoader;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

class NacosPropertySourceBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private String dataId;
    private String groupId;
    private String type;
    private Properties properties;
    private ConfigurableEnvironment environment;
    private BeanFactory beanFactory;
    private NacosConfigLoader nacosConfigLoader;

    NacosPropertySourceBuilder() {
    }

    public NacosPropertySourceBuilder name(String name) {
        this.name = name;
        return this;
    }

    public NacosPropertySourceBuilder dataId(String dataId) {
        this.dataId = dataId;
        return this;
    }

    public NacosPropertySourceBuilder groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public NacosPropertySourceBuilder properties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public NacosPropertySourceBuilder type(String type) {
        this.type = type;
        return this;
    }

    public NacosPropertySourceBuilder environment(ConfigurableEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public NacosPropertySourceBuilder beanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        return this;
    }

    public PropertySource build() {
        this.nacosConfigLoader = new NacosConfigLoader(this.environment);
        NacosServiceFactory nacosServiceFactory = NacosBeanUtils.getNacosServiceFactoryBean(this.beanFactory);
        this.nacosConfigLoader.setNacosServiceFactory(nacosServiceFactory);
        String config = this.nacosConfigLoader.load(this.dataId, this.groupId, this.properties);
        if (!StringUtils.hasText((String)config)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(String.format("There is no content for Nacos PropertySource from dataId[%s] , groupId[%s] , properties[%s].", this.dataId, this.groupId, this.properties));
            }
            return null;
        }
        Map<String, Object> properties = NacosUtils.toProperties(this.dataId, this.groupId, config, this.type);
        if (!StringUtils.hasText((String)this.name)) {
            this.name = NacosUtils.buildDefaultPropertySourceName(this.dataId, this.groupId, properties);
        }
        return new MapPropertySource(this.name, properties);
    }

    public NacosConfigLoader getNacosConfigLoader() {
        return this.nacosConfigLoader;
    }
}

