/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.annotation.config;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.spring.context.event.config.NacosConfigReceivedEvent;
import com.alibaba.nacos.spring.util.NacosUtils;
import com.alibaba.nacos.spring.util.PlaceholderHelper;
import com.alibaba.spring.beans.factory.annotation.AbstractAnnotationBeanPostProcessor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SpringValueAnnotationBeanPostProcessor
extends AbstractAnnotationBeanPostProcessor
implements BeanFactoryAware,
EnvironmentAware,
ApplicationListener<NacosConfigReceivedEvent> {
    public static final String BEAN_NAME = "StringValueAnnotationBeanPostProcessor";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Map<String, List<StringValueTarget>> placeholderStringValueTargetMap = new HashMap<String, List<StringValueTarget>>();
    private ConfigurableListableBeanFactory beanFactory;
    private Environment environment;
    private BeanExpressionResolver exprResolver;
    private BeanExpressionContext exprContext;

    public SpringValueAnnotationBeanPostProcessor() {
        super(new Class[]{Value.class});
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("StringValueAnnotationBeanPostProcessor requires a ConfigurableListableBeanFactory");
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        this.exprResolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
        this.exprContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected Object doGetInjectedBean(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) throws Exception {
        Object value = this.resolveStringValue(attributes.getString("value"));
        Member member = injectedElement.getMember();
        if (member instanceof Field) {
            return this.convertIfNecessary((Field)member, value);
        }
        if (member instanceof Method) {
            return this.convertIfNecessary((Method)member, value);
        }
        return null;
    }

    protected String buildInjectedObjectCacheKey(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) {
        return bean.getClass().getName() + attributes;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.doWithFields(bean, beanName);
        this.doWithMethods(bean, beanName);
        return super.postProcessBeforeInitialization(bean, beanName);
    }

    public void onApplicationEvent(NacosConfigReceivedEvent event) {
        if (StringUtils.isEmpty((Object)((Object)event))) {
            return;
        }
        Map<String, Object> updateProperties = NacosUtils.toProperties(event.getContent(), event.getType());
        for (Map.Entry<String, List<StringValueTarget>> entry : this.placeholderStringValueTargetMap.entrySet()) {
            String newValue;
            String key = this.environment.resolvePlaceholders(entry.getKey());
            if (!updateProperties.containsKey(key) || (newValue = this.environment.getProperty(key)) == null) continue;
            List<StringValueTarget> beanPropertyList = entry.getValue();
            for (StringValueTarget target : beanPropertyList) {
                String md5String = MD5Utils.md5Hex((String)newValue, (String)"UTF-8");
                boolean isUpdate = !target.lastMD5.equals(md5String);
                if (!isUpdate) continue;
                target.updateLastMD5(md5String);
                Object evaluatedValue = this.resolveStringValue(target.stringValueExpr);
                if (target.method == null) {
                    this.setField(target, evaluatedValue);
                    continue;
                }
                this.setMethod(target, evaluatedValue);
            }
        }
    }

    private Object resolveStringValue(String strVal) {
        String value = this.beanFactory.resolveEmbeddedValue(strVal);
        if (this.exprResolver != null && value != null) {
            return this.exprResolver.evaluate(value, this.exprContext);
        }
        return value;
    }

    private Object convertIfNecessary(Field field, Object value) {
        TypeConverter converter = this.beanFactory.getTypeConverter();
        return converter.convertIfNecessary(value, field.getType(), field);
    }

    private Object convertIfNecessary(Method method, Object value) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] arguments = new Object[paramTypes.length];
        TypeConverter converter = this.beanFactory.getTypeConverter();
        if (arguments.length == 1) {
            return converter.convertIfNecessary(value, paramTypes[0], new MethodParameter(method, 0));
        }
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = converter.convertIfNecessary(value, paramTypes[i], new MethodParameter(method, i));
        }
        return arguments;
    }

    private void doWithFields(final Object bean, final String beanName) {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException {
                Value annotation = (Value)AnnotationUtils.getAnnotation((AnnotatedElement)field, Value.class);
                SpringValueAnnotationBeanPostProcessor.this.doWithAnnotation(beanName, bean, annotation, field.getModifiers(), null, field);
            }
        });
    }

    private void doWithMethods(final Object bean, final String beanName) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException {
                Value annotation = (Value)AnnotationUtils.getAnnotation((Method)method, Value.class);
                SpringValueAnnotationBeanPostProcessor.this.doWithAnnotation(beanName, bean, annotation, method.getModifiers(), method, null);
            }
        });
    }

    private void doWithAnnotation(String beanName, Object bean, Value annotation, int modifiers, Method method, Field field) {
        if (annotation != null) {
            if (Modifier.isStatic(modifiers)) {
                return;
            }
            Set<String> placeholderList = PlaceholderHelper.findPlaceholderKeys(annotation.value());
            for (String placeholder : placeholderList) {
                StringValueTarget stringValueTarget = new StringValueTarget(bean, beanName, method, field, annotation.value());
                this.put2ListMap(this.placeholderStringValueTargetMap, placeholder, stringValueTarget);
            }
        }
    }

    private <K, V> void put2ListMap(Map<K, List<V>> map, K key, V value) {
        List<V> valueList = map.get(key);
        if (valueList == null) {
            valueList = new ArrayList<V>();
        }
        valueList.add(value);
        map.put(key, valueList);
    }

    private void setMethod(StringValueTarget stringValueTarget, Object propertyValue) {
        block3: {
            Method method = stringValueTarget.method;
            ReflectionUtils.makeAccessible((Method)method);
            try {
                method.invoke(stringValueTarget.bean, this.convertIfNecessary(method, propertyValue));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Update value with {} (method) in {} (bean) with {}", new Object[]{method.getName(), stringValueTarget.beanName, propertyValue});
                }
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error("Can't update value with " + method.getName() + " (method) in " + stringValueTarget.beanName + " (bean)", e);
            }
        }
    }

    private void setField(StringValueTarget stringValueTarget, Object propertyValue) {
        block3: {
            Object bean = stringValueTarget.bean;
            Field field = stringValueTarget.field;
            String fieldName = field.getName();
            try {
                ReflectionUtils.makeAccessible((Field)field);
                field.set(bean, this.convertIfNecessary(field, propertyValue));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Update value of the {} (field) in {} (bean) with {}", new Object[]{fieldName, stringValueTarget.beanName, propertyValue});
                }
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error("Can't update value of the " + fieldName + " (field) in " + stringValueTarget.beanName + " (bean)", e);
            }
        }
    }

    private static class StringValueTarget {
        private final Object bean;
        private final String beanName;
        private final Method method;
        private final Field field;
        private String lastMD5;
        private final String stringValueExpr;

        StringValueTarget(Object bean, String beanName, Method method, Field field, String stringValueExpr) {
            this.bean = bean;
            this.beanName = beanName;
            this.method = method;
            this.field = field;
            this.lastMD5 = "";
            this.stringValueExpr = stringValueExpr;
        }

        protected void updateLastMD5(String newMD5) {
            this.lastMD5 = newMD5;
        }
    }
}

