/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.util;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.springframework.util.StringUtils;

public class PlaceholderHelper {
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private static final String VALUE_SEPARATOR = ":";
    private static final String SIMPLE_PLACEHOLDER_PREFIX = "{";

    public static Set<String> findPlaceholderKeys(String propertyString) {
        HashSet placeholderKeys = Sets.newHashSet();
        if (Strings.isNullOrEmpty((String)propertyString) || !propertyString.contains(PLACEHOLDER_PREFIX) || !propertyString.contains(PLACEHOLDER_SUFFIX)) {
            return placeholderKeys;
        }
        propertyString = propertyString.substring(propertyString.indexOf(PLACEHOLDER_PREFIX));
        Stack<String> stack = new Stack<String>();
        stack.push(propertyString);
        while (!stack.isEmpty()) {
            String remainingPart;
            String strVal = (String)stack.pop();
            int startIndex = strVal.indexOf(PLACEHOLDER_PREFIX);
            if (startIndex == -1) {
                placeholderKeys.add(strVal);
                continue;
            }
            int endIndex = PlaceholderHelper.findPlaceholderEndIndex(strVal, startIndex);
            if (endIndex == -1) continue;
            String placeholderCandidate = strVal.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
            if (placeholderCandidate.startsWith(PLACEHOLDER_PREFIX)) {
                stack.push(placeholderCandidate);
            } else {
                int separatorIndex = placeholderCandidate.indexOf(VALUE_SEPARATOR);
                if (separatorIndex == -1) {
                    stack.push(placeholderCandidate);
                } else {
                    stack.push(placeholderCandidate.substring(0, separatorIndex));
                    String defaultValuePart = PlaceholderHelper.normalizeToPlaceholder(placeholderCandidate.substring(separatorIndex + VALUE_SEPARATOR.length()));
                    if (!Strings.isNullOrEmpty((String)defaultValuePart)) {
                        stack.push(defaultValuePart);
                    }
                }
            }
            if (endIndex + PLACEHOLDER_SUFFIX.length() >= strVal.length() - 1 || Strings.isNullOrEmpty((String)(remainingPart = PlaceholderHelper.normalizeToPlaceholder(strVal.substring(endIndex + PLACEHOLDER_SUFFIX.length()))))) continue;
            stack.push(remainingPart);
        }
        return placeholderKeys;
    }

    private static String normalizeToPlaceholder(String strVal) {
        int startIndex = strVal.indexOf(PLACEHOLDER_PREFIX);
        if (startIndex == -1) {
            return null;
        }
        int endIndex = strVal.lastIndexOf(PLACEHOLDER_SUFFIX);
        if (endIndex == -1) {
            return null;
        }
        return strVal.substring(startIndex, endIndex + PLACEHOLDER_SUFFIX.length());
    }

    private static int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + PLACEHOLDER_PREFIX.length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            if (StringUtils.substringMatch((CharSequence)buf, (int)index, (CharSequence)PLACEHOLDER_SUFFIX)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += PLACEHOLDER_SUFFIX.length();
                    continue;
                }
                return index;
            }
            if (StringUtils.substringMatch((CharSequence)buf, (int)index, (CharSequence)SIMPLE_PLACEHOLDER_PREFIX)) {
                ++withinNestedPlaceholder;
                index += SIMPLE_PLACEHOLDER_PREFIX.length();
                continue;
            }
            ++index;
        }
        return -1;
    }
}

