/*
 * Decompiled with CFR 0.152.
 */
package com.carrotgarden.osgi.anno.scr.conv;

public enum PropertyType {
    STRING(String.class),
    LONG(Long.class),
    DOUBLE(Double.class),
    FLOAT(Float.class),
    INTEGER(Integer.class),
    BYTE(Byte.class),
    CHARACTER(Character.class),
    BOOLEAN(Boolean.class),
    SHORT(Short.class);

    public final Class<?> klaz;
    public final String value;
    private static final PropertyType[] ENUM_VALS;

    private PropertyType(Class<?> klaz) {
        this.klaz = klaz;
        this.value = klaz.getSimpleName();
    }

    public static PropertyType from(String value) {
        for (PropertyType known : ENUM_VALS) {
            if (!known.value.equalsIgnoreCase(value)) continue;
            return known;
        }
        return STRING;
    }

    public static PropertyType from(Class<?> klaz) {
        for (PropertyType known : ENUM_VALS) {
            if (known.klaz != klaz) continue;
            return known;
        }
        return STRING;
    }

    public static boolean isValidType(Class<?> klaz) {
        for (PropertyType known : ENUM_VALS) {
            if (known.klaz != klaz) continue;
            return true;
        }
        return false;
    }

    public static String getList() {
        StringBuilder text = new StringBuilder(128);
        text.append(" ");
        for (PropertyType known : ENUM_VALS) {
            text.append(known.value);
            text.append(" ");
        }
        return text.toString();
    }

    static {
        ENUM_VALS = PropertyType.values();
    }
}

