/*
 * Decompiled with CFR 0.152.
 */
package com.carrotgarden.osgi.anno.scr.make;

import com.carrotgarden.osgi.anno.scr.bean.AggregatorBean;
import com.carrotgarden.osgi.anno.scr.bean.ComponentBean;
import com.carrotgarden.osgi.anno.scr.bean.PropertyBean;
import com.carrotgarden.osgi.anno.scr.bean.PropertyFileBean;
import com.carrotgarden.osgi.anno.scr.bean.ProvideBean;
import com.carrotgarden.osgi.anno.scr.bean.ReferenceBean;
import com.carrotgarden.osgi.anno.scr.bean.ServiceBean;
import com.carrotgarden.osgi.anno.scr.conv.PropertyType;
import com.carrotgarden.osgi.anno.scr.util.Util;
import com.carrotgarden.osgi.anno.scr.util.UtilAsm;
import com.carrotgarden.osgi.anno.scr.util.UtilJdk;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Builder {
    private static final Logger log = LoggerFactory.getLogger(Builder.class);
    private final Set<String> unwantedServiceSet;

    public Builder(Set<String> unwantedServiceSet) {
        this.unwantedServiceSet = unwantedServiceSet == null ? new HashSet<String>() : unwantedServiceSet;
    }

    private void applyComponent(ComponentBean component, Class<?> type, ClassNode classNode) throws Exception {
        ClassLoader loader;
        ConfigurationPolicy policy;
        Boolean immediate;
        String factory;
        AnnotationNode annoNode = UtilAsm.componentAnno(classNode);
        if (annoNode == null) {
            return;
        }
        String name = UtilAsm.asString(annoNode, "name");
        component.name = name != null ? name : type.getName();
        Boolean enabled = UtilAsm.asBoolean(annoNode, "enabled");
        if (enabled != null) {
            component.enabled = enabled;
        }
        if ((factory = UtilAsm.asString(annoNode, "factory")) != null) {
            component.factory = factory;
        }
        if ((immediate = UtilAsm.asBoolean(annoNode, "immediate")) != null) {
            component.immediate = immediate;
        }
        if ((policy = (ConfigurationPolicy)UtilAsm.asEnum(loader = type.getClassLoader(), annoNode, "configurationPolicy")) != null) {
            component.configPolicy = policy;
        }
        component.implementation.klaz = type.getName();
        Boolean servicefactory = UtilAsm.asBoolean(annoNode, "servicefactory");
        if (servicefactory != null) {
            component.service.servicefactory = servicefactory;
        }
        this.applyPropertyKeyValue(component, annoNode, type);
        this.applyPropertyFileEntry(component, annoNode, type);
        this.applyServiceDeclared(component, annoNode, type);
    }

    private void applyLifecycle(ComponentBean component, Class<?> type, ClassNode classNode) {
        int countActivate = 0;
        int countDeactivate = 0;
        int countModified = 0;
        List mothodList = classNode.methods;
        for (MethodNode methodNode : mothodList) {
            String methodName = methodNode.name;
            List<AnnotationNode> annoList = UtilAsm.combine(methodNode);
            if (Util.isListNone(annoList)) continue;
            for (AnnotationNode annoNode : annoList) {
                String annoDesc = annoNode.desc;
                if (UtilAsm.isActivateDesc(annoDesc)) {
                    component.activate = methodName;
                    ++countActivate;
                }
                if (UtilAsm.isDeactivateDesc(annoDesc)) {
                    component.deactivate = methodName;
                    ++countDeactivate;
                }
                if (!UtilAsm.isModifiedDesc(annoDesc)) continue;
                component.modified = methodName;
                ++countModified;
            }
        }
        if (countActivate > 1) {
            throw new IllegalStateException("duplicate @Activate in class : " + type);
        }
        if (countDeactivate > 1) {
            throw new IllegalStateException("duplicate @Deactivate in class : " + type);
        }
        if (countModified > 1) {
            throw new IllegalStateException("duplicate @Modified in class : " + type);
        }
    }

    private void applyPropertyEmbedded(ComponentBean component, Class<?> type, ClassNode node) throws Exception {
        List fieldList = node.fields;
        if (Util.isListNone(fieldList)) {
            return;
        }
        for (FieldNode fieldNode : fieldList) {
            Object value;
            AnnotationNode annoNode = UtilAsm.propertyAnno(fieldNode);
            if (annoNode == null) continue;
            String annoName = UtilAsm.asString(annoNode, "name");
            String fieldName = fieldNode.name;
            Field field = type.getDeclaredField(fieldName);
            field.setAccessible(true);
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                throw new IllegalArgumentException("property field must be static : " + type + " / " + fieldName);
            }
            if (!Modifier.isFinal(modifiers)) {
                throw new IllegalArgumentException("property field must be final : " + type + " / " + fieldName);
            }
            if (!PropertyType.isValidType(field.getType())) {
                throw new IllegalArgumentException("property field type must be one of : [" + PropertyType.getList() + "] " + type + " / " + fieldName + " / " + field.getType());
            }
            String name = Util.isValidText(annoName) ? annoName : fieldName;
            try {
                value = field.get(null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("property annotated value is invalid : " + type + " / " + fieldName, e);
            }
            PropertyBean bean = new PropertyBean();
            bean.name = name;
            bean.type = PropertyType.from(value.getClass()).value;
            bean.value = "" + value;
            component.propertySet.remove(bean);
            component.propertySet.add(bean);
        }
    }

    private void applyPropertyFileEntry(ComponentBean bean, AnnotationNode annoNode, Class<?> type) {
        List<String> entryList = UtilAsm.asStringList(annoNode, "properties");
        if (Util.isListNone(entryList)) {
            return;
        }
        String annoDesc = annoNode.desc;
        for (String entry : entryList) {
            if (!Util.isValidText(entry)) {
                throw new IllegalArgumentException("property file entry must not be empty : " + type + " / " + annoDesc);
            }
            PropertyFileBean propBean = new PropertyFileBean();
            propBean.entry = entry;
            bean.propertyFileSet.remove(propBean);
            bean.propertyFileSet.add(propBean);
        }
    }

    private void applyPropertyKeyValue(ComponentBean bean, AnnotationNode annoNode, Class<?> klaz) {
        List<String> entryList = UtilAsm.asStringList(annoNode, "property");
        if (Util.isListNone(entryList)) {
            return;
        }
        String annoDesc = annoNode.desc;
        for (String entry : entryList) {
            String type;
            String name;
            if (!Util.isValidText(entry)) {
                throw new IllegalStateException("property must not be empty : " + klaz + " / " + annoDesc);
            }
            if (!entry.contains("=")) {
                throw new IllegalStateException("property must contain '=' : " + klaz + " / " + annoDesc);
            }
            int indexEquals = entry.indexOf("=");
            String nameType = entry.substring(0, indexEquals);
            if (nameType.length() == 0) {
                throw new IllegalStateException("property name must not be empty : " + klaz + " / " + annoDesc);
            }
            if (nameType.contains(":")) {
                int indexColon = nameType.indexOf(":");
                name = nameType.substring(0, indexColon);
                type = PropertyType.from((String)nameType.substring((int)(indexColon + 1))).value;
                if (name.length() == 0) {
                    throw new IllegalStateException("property name must not be empty : " + klaz + " / " + annoDesc);
                }
            } else {
                name = nameType;
                type = PropertyType.STRING.value;
            }
            String value = entry.substring(indexEquals + 1);
            PropertyBean propBean = new PropertyBean();
            propBean.name = name;
            propBean.type = type;
            propBean.value = value;
            bean.propertySet.remove(propBean);
            bean.propertySet.add(propBean);
        }
    }

    private void applyReference(ComponentBean component, Class<?> type, ClassNode classNode) throws Exception {
        List methodList = classNode.methods;
        if (Util.isListNone(methodList)) {
            return;
        }
        for (MethodNode methodNode : methodList) {
            AnnotationNode annoNode = UtilAsm.referenceAnno(methodNode);
            if (annoNode == null) continue;
            ClassLoader loader = type.getClassLoader();
            if (!UtilAsm.isValidBindParam(loader, methodNode)) {
                throw new IllegalStateException("invalid parameters for reference : " + methodNode.desc);
            }
            Set<ReferenceBean> referenceSet = component.referenceSet;
            ReferenceBean bean = this.makeReference(type, methodNode, annoNode);
            if (referenceSet.contains(bean)) {
                throw new IllegalStateException("duplicate reference : " + methodNode.desc);
            }
            referenceSet.add(bean);
        }
    }

    private void applyServiceDeclared(ComponentBean component, AnnotationNode annoNode, Class<?> type) throws Exception {
        ClassLoader loader = type.getClassLoader();
        List<Class<?>> serviceList = UtilAsm.asClassList(loader, annoNode, "service");
        if (Util.isListNone(serviceList)) {
            return;
        }
        Set<ProvideBean> provideSet = component.service.provideSet;
        provideSet.clear();
        for (Class<?> service : serviceList) {
            if (!service.isAssignableFrom(type)) {
                throw new IllegalArgumentException("annotated service must also be implemented : " + service + " / " + type);
            }
            ProvideBean bean = new ProvideBean();
            bean.type = service.getName();
            provideSet.add(bean);
        }
    }

    private void applyServiceInferred(ComponentBean component, Class<?> type) {
        Class<?>[] ifaceArray = type.getInterfaces();
        if (ifaceArray.length == 0) {
            return;
        }
        ServiceBean service = component.service;
        for (Class<?> iface : ifaceArray) {
            ProvideBean bean = new ProvideBean();
            bean.type = iface.getName();
            if (service.provideSet.contains(bean)) continue;
            service.provideSet.add(bean);
        }
    }

    private void finalizeProvidedServices(ComponentBean bean) {
        if (bean.service.provideSet.isEmpty()) {
            bean.service = null;
            return;
        }
        if (this.unwantedServiceSet.isEmpty()) {
            return;
        }
        TreeSet<ProvideBean> provideSet = new TreeSet<ProvideBean>();
        for (ProvideBean provide : bean.service.provideSet) {
            if (this.unwantedServiceSet.contains(provide.type)) continue;
            provideSet.add(provide);
        }
        if (provideSet.isEmpty()) {
            bean.service = null;
        } else {
            bean.service.provideSet = provideSet;
        }
    }

    public AggregatorBean makeAggregator(List<Class<?>> klazList) throws Exception {
        AggregatorBean aggregator = new AggregatorBean();
        for (Class<?> klaz : klazList) {
            aggregator.componentList.add(this.makeComponent(klaz));
        }
        return aggregator;
    }

    private ComponentBean makeComponent(Class<?> klaz) throws Exception {
        ComponentBean bean = new ComponentBean();
        List<Class<?>> typeList = UtilJdk.inheritanceList(klaz);
        if (Util.isListNone(typeList)) {
            return bean;
        }
        for (Class<?> type : typeList) {
            ClassNode node = UtilAsm.classNode(type);
            this.applyServiceInferred(bean, type);
            this.applyPropertyEmbedded(bean, type, node);
            this.applyReference(bean, type, node);
            this.applyLifecycle(bean, type, node);
            this.applyComponent(bean, type, node);
        }
        this.finalizeProvidedServices(bean);
        return bean;
    }

    private ReferenceBean makeReference(Class<?> type, MethodNode bindMethod, AnnotationNode annoNode) throws Exception {
        ReferencePolicy policy;
        String name;
        String bindType;
        ReferenceBean reference = new ReferenceBean();
        String bindName = bindMethod.name;
        reference.type = bindType = UtilAsm.firstParamType(bindMethod).getClassName();
        String target = UtilAsm.asString(annoNode, "target");
        if (target != null) {
            reference.target = target;
        }
        if ((name = UtilAsm.asString(annoNode, "name")) != null) {
            reference.name = name;
        } else {
            String nameDefault;
            String nameType = bindType;
            String nameTarget = Util.isValidText(target) ? target : "*";
            reference.name = nameDefault = nameType + "/" + nameTarget;
        }
        ClassLoader loader = type.getClassLoader();
        ReferenceCardinality cardinality = (ReferenceCardinality)UtilAsm.asEnum(loader, annoNode, "cardinality");
        if (cardinality != null) {
            reference.cardinality = cardinality;
        }
        if ((policy = (ReferencePolicy)UtilAsm.asEnum(loader, annoNode, "policy")) != null) {
            reference.policy = policy;
        }
        reference.bind = bindName;
        reference.unbind = Util.unbindName(bindName);
        UtilJdk.assertBindUnbindMatch(type, bindType, reference.bind, reference.unbind);
        return reference;
    }
}

