/*
 * Decompiled with CFR 0.152.
 */
package com.carrotgarden.osgi.anno.scr.make;

import com.carrotgarden.osgi.anno.scr.bean.AggregatorBean;
import com.carrotgarden.osgi.anno.scr.make.Builder;
import com.carrotgarden.osgi.anno.scr.util.UtilAsm;
import com.carrotgarden.osgi.anno.scr.util.UtilJdk;
import com.thoughtworks.xstream.XStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Maker {
    private static final Logger log = LoggerFactory.getLogger(Maker.class);
    private final XStream xstream = new XStream();
    private final Builder builder;
    static final boolean INIT_NOT = false;
    static final boolean INIT_YES = true;

    public Maker() {
        this(new HashSet<String>());
    }

    public Maker(Set<String> excludedServiceSet) {
        this.xstream.autodetectAnnotations(true);
        this.builder = new Builder(excludedServiceSet);
    }

    public String make(Class<?> ... klazArray) throws Throwable {
        LinkedList klazList = new LinkedList();
        for (Class<?> klaz : klazArray) {
            if (UtilJdk.isAbstract(klaz) || !UtilAsm.hasComponentAnno(klaz)) continue;
            klazList.add(klaz);
        }
        if (klazList.isEmpty()) {
            return null;
        }
        AggregatorBean bean = this.builder.makeAggregator(klazList);
        return this.xstream.toXML((Object)bean);
    }

    public String make(ClassLoader loader, String ... nameArray) throws Throwable {
        LinkedList klazList = new LinkedList();
        for (String name : nameArray) {
            Class<?> klaz = Class.forName(name, false, loader);
            if (UtilJdk.isAbstract(klaz) || !UtilAsm.hasComponentAnno(klaz)) continue;
            Class.forName(name, true, loader);
            klazList.add(klaz);
        }
        if (klazList.isEmpty()) {
            return null;
        }
        AggregatorBean bean = this.builder.makeAggregator(klazList);
        return this.xstream.toXML((Object)bean);
    }
}

