/*
 * Decompiled with CFR 0.152.
 */
package com.carrotgarden.osgi.anno.scr.util;

import com.carrotgarden.osgi.anno.scr.util.Util;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Property;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

public class UtilAsm {
    public static final String DESC_CONFIGURATION_POLICY = Type.getDescriptor(ConfigurationPolicy.class);
    public static final String DESC_COMPONENT = Type.getDescriptor(Component.class);
    public static final String DESC_ACTIVATE = Type.getDescriptor(Activate.class);
    public static final String DESC_DEACTIVATE = Type.getDescriptor(Deactivate.class);
    public static final String DESC_MODIFIED = Type.getDescriptor(Modified.class);
    public static final String DESC_PROPERTY = Type.getDescriptor(Property.class);
    public static final String DESC_REFERENCE = Type.getDescriptor(Reference.class);
    public static final String DESC_REFERENCE_CARDINALITY = Type.getDescriptor(ReferenceCardinality.class);
    public static final String DESC_REFERENCE_POLICY = Type.getDescriptor(ReferencePolicy.class);
    public static final int SKIP_MODE = 7;

    public static Boolean asBoolean(AnnotationNode node, String name) {
        List entryList = node.values;
        if (Util.isListNone(entryList)) {
            return null;
        }
        for (int k = 0; k < entryList.size(); k += 2) {
            String entryName = (String)entryList.get(k);
            if (!entryName.equals(name)) continue;
            Boolean entryValue = (Boolean)entryList.get(k + 1);
            return entryValue;
        }
        return null;
    }

    public static List<Class<?>> asClassList(ClassLoader loader, AnnotationNode node, String name) throws Exception {
        List entryList = node.values;
        if (Util.isListNone(entryList)) {
            return null;
        }
        for (int k = 0; k < entryList.size(); k += 2) {
            String entryName = (String)entryList.get(k);
            if (!entryName.equals(name)) continue;
            ArrayList klazList = new ArrayList();
            List entryValue = (List)entryList.get(k + 1);
            for (Type type : entryValue) {
                Class<?> klaz = loader.loadClass(type.getClassName());
                klazList.add(klaz);
            }
            return klazList;
        }
        return null;
    }

    public static <E extends Enum<E>> E asEnum(ClassLoader loader, AnnotationNode node, String name) throws Exception {
        List entryList = node.values;
        if (Util.isListNone(entryList)) {
            return null;
        }
        for (int k = 0; k < entryList.size(); k += 2) {
            String entryName = (String)entryList.get(k);
            if (!entryName.equals(name)) continue;
            String[] entryValue = (String[])entryList.get(k + 1);
            String desc = entryValue[0];
            String value = entryValue[1];
            String klazName = Type.getType((String)desc).getClassName();
            Class<?> klaz = loader.loadClass(klazName);
            for (Enum entry : (Enum[])klaz.getEnumConstants()) {
                if (!entry.name().equals(value)) continue;
                return (E)entry;
            }
            throw new IllegalStateException("invalid enum klaz=" + klaz);
        }
        return null;
    }

    public static String asString(AnnotationNode node, String name) {
        List entryList = node.values;
        if (Util.isListNone(entryList)) {
            return null;
        }
        for (int k = 0; k < entryList.size(); k += 2) {
            String entryName = (String)entryList.get(k);
            if (!entryName.equals(name)) continue;
            String entryValue = (String)entryList.get(k + 1);
            return entryValue;
        }
        return null;
    }

    public static List<String> asStringList(AnnotationNode node, String name) {
        List entryList = node.values;
        if (Util.isListNone(entryList)) {
            return null;
        }
        for (int k = 0; k < entryList.size(); k += 2) {
            String entryName = (String)entryList.get(k);
            if (!entryName.equals(name)) continue;
            List entryValue = (List)entryList.get(k + 1);
            return entryValue;
        }
        return null;
    }

    public static ClassNode classNode(Class<?> klaz) throws Exception {
        String name = klaz.getName();
        String path = name.replace('.', '/') + ".class";
        ClassLoader loader = klaz.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        InputStream stream = loader.getResourceAsStream(path);
        ClassReader reader = new ClassReader(stream);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 7);
        return node;
    }

    public static List<AnnotationNode> combine(ClassNode node) {
        return Util.concatenate(node.invisibleAnnotations, node.visibleAnnotations);
    }

    public static List<AnnotationNode> combine(FieldNode node) {
        return Util.concatenate(node.invisibleAnnotations, node.visibleAnnotations);
    }

    public static List<AnnotationNode> combine(MethodNode node) {
        return Util.concatenate(node.invisibleAnnotations, node.visibleAnnotations);
    }

    public static AnnotationNode componentAnno(ClassNode node) {
        List<AnnotationNode> annoList = UtilAsm.combine(node);
        if (Util.isListNone(annoList)) {
            return null;
        }
        for (AnnotationNode annoNode : annoList) {
            if (!UtilAsm.isComponentDesc(annoNode.desc)) continue;
            return annoNode;
        }
        return null;
    }

    public static Type firstParamType(MethodNode node) {
        return UtilAsm.parameterArray(node)[0];
    }

    public static boolean hasComponentAnno(Class<?> klaz) throws Exception {
        ClassNode node = UtilAsm.classNode(klaz);
        AnnotationNode anno = UtilAsm.componentAnno(node);
        return anno != null;
    }

    public static boolean isActivateDesc(String desc) {
        return DESC_ACTIVATE.equals(desc);
    }

    public static boolean isComponentDesc(String desc) {
        return DESC_COMPONENT.equals(desc);
    }

    public static boolean isDeactivateDesc(String desc) {
        return DESC_DEACTIVATE.equals(desc);
    }

    public static boolean isModifiedDesc(String desc) {
        return DESC_MODIFIED.equals(desc);
    }

    public static boolean isPropertyDesc(String desc) {
        return DESC_PROPERTY.equals(desc);
    }

    public static boolean isReferenceDesc(String desc) {
        return DESC_REFERENCE.equals(desc);
    }

    public static boolean isValidBindParam(ClassLoader loader, MethodNode node) throws Exception {
        Type[] array = UtilAsm.parameterArray(node);
        switch (array.length) {
            case 1: {
                Class<?> klaz1 = loader.loadClass(array[0].getClassName());
                return klaz1.isInterface();
            }
            case 2: {
                Class<?> klaz1 = loader.loadClass(array[0].getClassName());
                Class<?> klaz2 = loader.loadClass(array[1].getClassName());
                return klaz1.isInterface() && Map.class.isAssignableFrom(klaz2);
            }
        }
        return false;
    }

    public static Type[] parameterArray(MethodNode node) {
        return Type.getMethodType((String)node.desc).getArgumentTypes();
    }

    public static AnnotationNode propertyAnno(FieldNode node) {
        List<AnnotationNode> annoList = UtilAsm.combine(node);
        if (Util.isListNone(annoList)) {
            return null;
        }
        for (AnnotationNode annoNode : annoList) {
            if (!UtilAsm.isPropertyDesc(annoNode.desc)) continue;
            return annoNode;
        }
        return null;
    }

    public static AnnotationNode referenceAnno(MethodNode node) {
        List<AnnotationNode> annoList = UtilAsm.combine(node);
        if (Util.isListNone(annoList)) {
            return null;
        }
        for (AnnotationNode annoNode : annoList) {
            if (!UtilAsm.isReferenceDesc(annoNode.desc)) continue;
            return annoNode;
        }
        return null;
    }

    private UtilAsm() {
    }
}

