/*
 * Decompiled with CFR 0.152.
 */
package com.carrotgarden.osgi.anno.scr.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Property;
import org.osgi.service.component.annotations.Reference;

public class UtilJdk {
    public static void assertBindUnbindMatch(Class<?> klaz, String typeName, String nameBind, String nameUnbind) {
        Method[] methodArray = klaz.getDeclaredMethods();
        int countBind = 0;
        int countUnbind = 0;
        Method methodBind = null;
        Method methodUnbind = null;
        block4: for (Method method : methodArray) {
            boolean isParamMatch;
            Class<?>[] paramArray = method.getParameterTypes();
            switch (paramArray.length) {
                default: {
                    continue block4;
                }
                case 1: {
                    isParamMatch = typeName.equals(paramArray[0].getName());
                    break;
                }
                case 2: {
                    boolean bl = isParamMatch = typeName.equals(paramArray[0].getName()) && Map.class.isAssignableFrom(paramArray[1]);
                }
            }
            if (!isParamMatch) continue;
            if (method.getName().equals(nameBind)) {
                methodBind = method;
                ++countBind;
            }
            if (!method.getName().equals(nameUnbind)) continue;
            methodUnbind = method;
            ++countUnbind;
        }
        if (countBind == 1 && countUnbind == 1) {
            return;
        }
        throw new IllegalStateException("mismatch :  klaz=" + klaz.getName() + " type=" + typeName + " bind=" + methodBind + " unbind=" + methodUnbind + "");
    }

    private static Class<?> bindType(Method bindMethod) {
        Class<?>[] paramArary = bindMethod.getParameterTypes();
        return paramArary[0];
    }

    private static boolean hasClassComponentAnno(Class<?> klaz) {
        return klaz.isAnnotationPresent(Component.class);
    }

    private static boolean hasFieldPropertyAnno(Class<?> klaz) {
        Field[] fieldArray;
        for (Field field : fieldArray = klaz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Property.class)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasInterfaces(Class<?> klaz) {
        return klaz.getInterfaces().length > 0;
    }

    private static boolean hasMethodReferenceAnno(Class<?> klaz) {
        Method[] methodArray;
        for (Method method : methodArray = klaz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Reference.class)) continue;
            return true;
        }
        return false;
    }

    public static List<Class<?>> inheritanceList(Class<?> klaz) {
        LinkedList list = new LinkedList();
        Class<?> type = klaz;
        while (type != null) {
            list.addFirst(type);
            type = type.getSuperclass();
        }
        return list;
    }

    public static boolean isAbstract(Class<?> klaz) {
        return Modifier.isAbstract(klaz.getModifiers());
    }

    private static boolean isComponent(Class<?> klaz) {
        if (klaz == null) {
            return false;
        }
        if (klaz.isAnnotationPresent(Component.class)) {
            return true;
        }
        return UtilJdk.isComponent(klaz.getSuperclass());
    }

    private static boolean isValid(Object[] array) {
        return array != null && array.length > 0;
    }

    private static boolean isValidBindParam(Class<?>[] paramArray) {
        if (paramArray == null) {
            return false;
        }
        switch (paramArray.length) {
            case 0: {
                return false;
            }
            case 1: {
                return paramArray[0].isInterface();
            }
            case 2: {
                return paramArray[0].isInterface() && Map.class.isAssignableFrom(paramArray[1]);
            }
        }
        return false;
    }

    private static String methodName(Class<? extends Annotation> annoType, Class<?> klazType) {
        Method[] methodArray;
        for (Method method : methodArray = klazType.getDeclaredMethods()) {
            Annotation anno = method.getAnnotation(annoType);
            if (anno == null) continue;
            return method.getName();
        }
        return null;
    }

    public static <T> T readField(Object instance, String fieldName) {
        try {
            Field field = instance.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(instance);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Can not read field.", e);
        }
    }

    private UtilJdk() {
    }
}

