/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.grpc.util;

import com.clickhouse.client.internal.google.common.io.BaseEncoding;
import com.clickhouse.client.internal.grpc.ExperimentalApi;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8024")
public final class CertificateUtils {
    public static X509Certificate[] getX509Certificates(InputStream inputStream) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certs = factory.generateCertificates(inputStream);
        return certs.toArray(new X509Certificate[0]);
    }

    public static PrivateKey getPrivateKey(InputStream inputStream) throws UnsupportedEncodingException, IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        while ((line = reader.readLine()) != null && !"-----BEGIN PRIVATE KEY-----".equals(line)) {
        }
        StringBuilder keyContent = new StringBuilder();
        while ((line = reader.readLine()) != null && !"-----END PRIVATE KEY-----".equals(line)) {
            keyContent.append(line);
        }
        byte[] decodedKeyBytes = BaseEncoding.base64().decode(keyContent.toString());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decodedKeyBytes);
        return keyFactory.generatePrivate(keySpec);
    }
}

