/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.DmJdbcUtil;
import dm.jdbc.util.StringUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DmdbDatabaseMetaData_bs
implements DatabaseMetaData {
    private DmdbConnection_bs connection;
    private final String m_esp;
    private boolean m_priv = false;
    int procedureResultUnknown = 0;
    int procedureNoResult = 1;
    int procedureReturnsResult = 2;
    int procedureColumnUnknown = 0;
    int procedureColumnIn = 1;
    int procedureColumnInOut = 2;
    int procedureColumnOut = 4;
    int procedureColumnReturn = 5;
    int procedureColumnResult = 3;
    int procedureNoNulls = 0;
    int procedureNullable = 1;
    int procedureNullableUnknown = 2;
    int columnNoNulls = 0;
    int columnNullable = 1;
    int columnNullableUnknown = 2;
    int bestRowTemporary = 0;
    int bestRowTransaction = 1;
    int bestRowSession = 2;
    int bestRowUnknown = 0;
    int bestRowNotPseudo = 1;
    int bestRowPseudo = 2;
    int versionColumnUnknown = 0;
    int versionColumnNotPseudo = 1;
    int versionColumnPseudo = 2;
    int importedKeyCascade = 0;
    int importedKeyRestrict = 1;
    int importedKeySetNull = 2;
    int importedKeyNoAction = 3;
    int importedKeySetDefault = 4;
    int importedKeyInitiallyDeferred = 5;
    int importedKeyInitiallyImmediate = 6;
    int importedKeyNotDeferrable = 7;
    int typeNoNulls = 0;
    int typeNullable = 1;
    int typeNullableUnknown = 2;
    int typePredNone = 0;
    int typePredChar = 1;
    int typePredBasic = 2;
    int typeSearchable = 3;
    short tableIndexStatistic = 0;
    short tableIndexClustered = 1;
    short tableIndexHashed = (short)2;
    short tableIndexOther = (short)3;
    short attributeNoNulls = 0;
    short attributeNullable = 1;
    short attributeNullableUnknown = (short)2;
    int XOpen = 1;
    int sqlStateSQL99 = 2;

    public DmdbDatabaseMetaData_bs(DmdbConnection_bs conn) {
        this.connection = conn;
        this.m_esp = " ESCAPE '!' ";
        this.m_priv = this.connection.isDbmdChkPrv();
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return this.connection.getUrl();
    }

    public String getUserName() throws SQLException {
        return this.connection.getCurrentUserName();
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        if (StringUtil.isNotEmpty(this.connection.getDatabaseProductName())) {
            return this.connection.getDatabaseProductName();
        }
        if (this.connection.isCompatibleOracle()) {
            return "Oracle";
        }
        return "DM DBMS";
    }

    public String getDatabaseProductVersion() throws SQLException {
        ResultSet rs = DmJdbcUtil.executeQuery(this.connection, "select top 1 * from v$version where banner like 'DM Database Server%'");
        if (rs.next()) {
            String str = rs.getString(1);
            int endIndex = str.indexOf("-Build");
            str = endIndex != -1 ? str.substring(0, endIndex) : str;
            int startIndex = str.lastIndexOf("V");
            return startIndex != -1 ? str.substring(startIndex + 1) : str;
        }
        return this.connection.getDmServerVersion();
    }

    public String getDriverName() throws SQLException {
        return "dm.jdbc.driver.DmDriver";
    }

    public String getDriverVersion() throws SQLException {
        String s = "3.0";
        if (DmdbType.JDBC_VERSION >= 4) {
            s = "4.0";
        }
        String version = "7.6.0.142";
        try {
            String[] versionStr = version.split("\\.");
            int i = versionStr.length - 1;
            while (i > 0) {
                if (Integer.parseInt(versionStr[i]) != 0) break;
                versionStr[i] = null;
                --i;
            }
            version = "";
            i = 0;
            while (i < versionStr.length) {
                if (!StringUtil.isEmpty(versionStr[i])) {
                    if (i != 0) {
                        version = String.valueOf(version) + ".";
                    }
                    version = String.valueOf(version) + versionStr[i];
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            version = "7.6.0.142";
        }
        s = String.valueOf(s) + "." + version + " (Build " + "2017.06.02" + ")";
        return s;
    }

    public int getDriverMajorVersion() {
        return DmdbType.JDBC_VERSION;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        StringBuffer sql = new StringBuffer("");
        sql.append("BREAK,BROWSE,BULK,CHECKPOINT,CLUSTERED,COMMITTED,COMPUTE,");
        sql.append(" CONFIRM,CONTROLROW,DATABASE,DBCC,DISK,DISTRIBUTED,DUMMY,");
        sql.append(" DUMP,ERRLVL,ERROREXIT,EXIT,FILE,FILLFACTOR,FLOPPY,HOLDLOCK,");
        sql.append(" IDENTITY_INSERT,IDENTITYCOL,IF,KILL,LINENO,LOAD,MIRROREXIT,");
        sql.append("NONCLUSTERED,OFF,OFFSETS,ONCE,OVER,PERCENT,PERM,PERMANENT,PLAN, PRINT,");
        sql.append("AFTER,ASSIGN,AUDIT,BEFORE,BITMAP,CACHE,CALL,CHAIN,CLUSTER,CYCLE,");
        sql.append(" DATABASE, DATAFILE, DEBUG, #DECODE, #DELETING, DISABLE,");
        sql.append(" EACH,ELSEIF,END,EXCLUSIVE, EXIT,FILLFACTOR, FUNCTION,");
        sql.append(" HEXTORAW,IDENTIFIED,IF, IFNULL,INCREASE, INDEX, ");
        sql.append(" INITIAL,INTENTION,ISNULL,ISOPEN,MAXVALUE,");
        sql.append(" MINVALUE,MODIFY,NATURAL,NEW, NEXT, NOAUDIT, NOCACHE,NOCYCLE,");
        sql.append(" NOTFOUND,  NVL, OFF, OLD, OUT,PENDANT, PERCENT, PRINT, PRIOR,");
        sql.append("RAISE,RAWTOHEX,READ,RENAME,RETURN,REVERSE,ROLE,ROWCOUNT,ROWNUM,SAVEPOINT,SERIALIZABLE,");
        sql.append(" SEQUENCE, SHARE, STATEMENT,TIES, TIMESTAMPADD, TIMESTAMPDIFF,");
        sql.append("TOP,TRIGGER,TRIGGERS,TRUNCATE,TYPECAST,UNCOMMITED,UNTIL,VSIZE,WHILE,LOGIN,");
        sql.append("EXTERNALLY,SESSION_PER_USER,CONNECT_IDLE_TIME,FAILED_LOGIN_ATTEMPS,");
        sql.append("PASSWORD_LIFE_TIME,PASSWORD_REUSE_TIME,PASSWORD_REUSE_MAX,");
        sql.append("PASSWORD_LOCK_TIME,PASSWORD_GRACE_TIME,POLICY,CATEGORY,UNLIMITED");
        return sql.toString();
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE,CEIL,COSH,LN,SINH,TANH";
    }

    public String getStringFunctions() throws SQLException {
        return "ASCII,CHAR,CONCAT,DIFFERENCE,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,UCASE,BIT_LENGTH,CHAR_LENGTH,CHARACTER_LENGTH,CHR,INITCAP,INSSTR,INSTR,INSTRB,LEFTSTR,LENGTHB,OCTET_LENGTH,LOWER,LPAD,POSITION,REPEATSTR,REVERSE,RIGHTSTR,RPAD,SUBSTR,SUBSTRB,TO_CHAR,TRANSLATE,TRIM,UPPER";
    }

    public String getSystemFunctions() throws SQLException {
        return "IFNULL,USER,CUR_DATABASE,DBID,EXTENT,PAGE,SESSID,UID,TABLEDEF,VSIZE,SET_TABLE_OPTION,SET_INDEX_OPTION,CFALGORITHMSENCRYPT,CFALGORITHMSDECRYPT,BFALGORITHMSENCRYPT,BFALGORITHMSDECRYPT,LABEL_TO_CHAR,LABEL_FROM_CHAR,LABEL_CMP,LABEL_STR_CMP";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR,ADD_DAYS,ADD_MONTHS,ADD_WEEKS,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,DATEADD,DATEDIFF,DATEPART,DAYS_BETWEEN,EXTRACT,GETDATE,LAST_DAY,MONTHS_BETWEEN,NEXT_DAY,ROUND,SYSDATE,TO_DATE,TRUNC,WEEKDAY,YEARS_BETWEEN";
    }

    public String getSearchStringEscape() throws SQLException {
        return "!";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return true;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        boolean supportsconvert = false;
        if (toType == 91) {
            switch (fromType) {
                case -1: 
                case 1: 
                case 12: 
                case 91: 
                case 2005: {
                    supportsconvert = true;
                    break;
                }
            }
        }
        if (toType == 3 || toType == 2 || toType == -6 || toType == 4 || toType == 6 || toType == 8 || toType == 7 || toType == 5 || toType == -5 || toType == 1 || toType == 12 || toType == -7 || toType == 16 || toType == -1) {
            switch (fromType) {
                case -7: 
                case -6: 
                case -5: 
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 16: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        if (toType == 91) {
            switch (fromType) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 91: 
                case 93: 
                case 2005: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        if (toType == 92) {
            switch (fromType) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 92: 
                case 93: 
                case 2005: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        if (toType == 93) {
            switch (fromType) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 91: 
                case 92: 
                case 93: 
                case 2005: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        if (toType == 2004) {
            switch (fromType) {
                case -4: 
                case 2004: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        if (toType == 2005) {
            switch (fromType) {
                case -1: 
                case 2005: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        return supportsconvert;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "SCHEMA";
    }

    public String getProcedureTerm() throws SQLException {
        return "PROCEDURE";
    }

    public String getCatalogTerm() throws SQLException {
        return "CATALOG";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return this.connection.getMaxRowSize();
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 128;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 64;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 64;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 1024;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 1024;
    }

    public int getMaxConnections() throws SQLException {
        return 256;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 128;
    }

    public int getMaxIndexLength() throws SQLException {
        return 1020;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 128;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 128;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        return 8000;
    }

    public int getMaxStatements() throws SQLException {
        return 128;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 128;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 50;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 128;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 2 || level == 1 || level == 4 || level == 8;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return !this.connection.getDDL_Autocommit();
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.connection.getDDL_Autocommit();
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.connection.getDDL_Autocommit();
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return !this.connection.getDDL_Autocommit();
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String procClause;
        if (this.connection.isCompatibleOracle() && StringUtil.isNotEmpty(catalog)) {
            try {
                return this.getPkgProcedures(schemaPattern, catalog, procedureNamePattern, 0);
            }
            catch (SQLException sQLException) {}
        }
        if (schemaPattern != null && schemaPattern.equals("")) {
            throw new SQLException("There is not a procedure without a schema!");
        }
        if (procedureNamePattern != null && procedureNamePattern.equals("")) {
            return null;
        }
        String schemaname = schemaPattern == null ? "%" : StringUtil.getEscStringName(schemaPattern);
        String procname = procedureNamePattern == null ? "%" : StringUtil.getEscStringName(procedureNamePattern);
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS PROCEDURE_CAT, SCHEMAS.NAME AS PROCEDURE_SCHEM,");
        sql.append("PROCS.NAME AS PROCEDURE_NAME, 'RESERVED1' AS RESERVED1,'RESERVED2' AS RESERVED2,'RESERVED3' AS RESERVED3, NULL AS REMARKS, 1 AS PROCEDURE_TYPE");
        sql.append(" FROM ");
        String schemaClause = this.makeSchemaClause(schemaname);
        sql.append(schemaClause);
        sql.append(" SCHEMAS, ");
        sql.append(" (SELECT * FROM SYS.SYSOBJECTS WHERE SUBTYPE$='PROC' ");
        if (!this.connection.isCompatibleOracle()) {
            sql.append("AND INFO1&0x01=1 ");
        }
        if ((procClause = this.makeClause_objWithoutPrec(procname)) != null) {
            sql.append(" AND NAME ");
            sql.append(procClause);
        }
        sql.append(")PROCS");
        sql.append(" WHERE SCHEMAS.ID = PROCS.SCHID");
        sql.append(" ORDER BY PROCEDURE_SCHEM ASC,PROCEDURE_NAME ASC;");
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    private ResultSet getPkgProcedures(String schName, String pkgName, String procName, int procType) throws SQLException {
        String procClause;
        String pkgClause;
        String schemaClause;
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT PACAGES.NAME AS PROCEDURE_CAT, SCHEMAS.NAME AS PROCEDURE_SCHEM,");
        sql.append("PROCS.MTDNAME AS PROCEDURE_NAME, 'RESERVED1' AS RESERVED1,'RESERVED2' AS RESERVED2,'RESERVED3' AS RESERVED3, NULL AS REMARKS, CASE PROCS.IS_PROC WHEN 'Y' THEN 1 ELSE  2 END AS PROCEDURE_TYPE");
        sql.append(" FROM SYS.SYSOBJECTS SCHEMAS, SYS.SYSOBJECTS PACAGES, SYS.V$PKGPROCS PROCS");
        sql.append(" WHERE");
        sql.append(" PROCS.PKGID = PACAGES.ID");
        sql.append(" AND PACAGES.SCHID = SCHEMAS.ID");
        if (procType == 1) {
            sql.append(" AND PROCS.IS_PROC = 'Y'");
        } else if (procType == 2) {
            sql.append(" AND PROCS.IS_PROC = 'N'");
        }
        if (StringUtil.isNotEmpty(schName) && (schemaClause = this.makeClause_objWithoutPrec(schName = StringUtil.getEscStringName(schName))) != null) {
            sql.append(" AND SCHEMAS.NAME ");
            sql.append(schemaClause);
        }
        if (StringUtil.isNotEmpty(pkgName) && (pkgClause = this.makeClause_objWithoutPrec(pkgName = StringUtil.getEscStringName(pkgName))) != null) {
            sql.append(" AND PROCS.PKGNAME ");
            sql.append(pkgClause);
        }
        if (StringUtil.isNotEmpty(procName) && (procClause = this.makeClause_objWithoutPrec(procName = StringUtil.getEscStringName(procName))) != null) {
            sql.append(" AND PROCS.MTDNAME ");
            sql.append(procClause);
        }
        sql.append("ORDER BY PROCEDURE_SCHEM ASC, PROCEDURE_CAT ASC, PROCEDURE_NAME ASC;");
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    private ResultSet getPkgProcedureColumns(String schName, String pkgName, String procName, String colName, int procType) throws SQLException {
        String colClause;
        String procClause;
        String pkgClause;
        String schemaClause;
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT ");
        sql.append("PACAGES.NAME AS PROCEDURE_CAT, ");
        sql.append("SCHEMAS.NAME AS PROCEDURE_SCHEM, ");
        sql.append("PROCS.MTDNAME AS PROCEDURE_NAME, ");
        sql.append("CASE TRIM(ARG.IOFLAG) WHEN 'R' THEN NULL ELSE ARG.NAME END AS COLUMN_NAME, ");
        sql.append("CASE TRIM(ARG.IOFLAG)");
        sql.append(" WHEN 'I' THEN 1");
        sql.append(" WHEN 'O' THEN 4");
        sql.append(" WHEN 'IO' THEN 2");
        sql.append(" WHEN 'R' THEN 5");
        sql.append(" END AS COLUMN_TYPE, ");
        sql.append(this.makeDataTypeClause("ARG.TYPE$", "ARG.SCALE"));
        sql.append("AS DATA_TYPE, ");
        sql.append(this.makeDataTypeNameClause("ARG.TYPE$"));
        sql.append("AS TYPE_NAME, ");
        sql.append("CASE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        sql.append("AS \"PRECISION\", ");
        sql.append("CASE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        sql.append("AS LENGTH, ");
        sql.append("CASE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) END ");
        sql.append("AS SCALE, ");
        sql.append("10 AS RADIX, ");
        sql.append("1 AS NULLABLE, ");
        sql.append("NULL AS REMARKS, ");
        sql.append("ARG.DEFVAL AS COLUMN_DEF, ");
        sql.append("NULL AS SQL_DATA_TYPE, ");
        sql.append("NULL AS SQL_DATETIME_SUB, ");
        sql.append("NULL AS CHAR_OCTET_LENGTH, ");
        sql.append("ARG.PARAMID AS ORDINAL_POSITION, ");
        sql.append("CASE ARG.NULLABLE WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE, ");
        sql.append("NULL AS SPECIFIC_NAME ");
        sql.append("FROM SYS.SYSOBJECTS SCHEMAS, SYS.SYSOBJECTS PACAGES, SYS.V$PKGPROCS PROCS, SYS.V$PKGPROCPARAMS ARG");
        sql.append(" WHERE");
        sql.append(" PROCS.PKGID = PACAGES.ID");
        sql.append(" AND PACAGES.SCHID = SCHEMAS.ID");
        sql.append(" AND ARG.PKGID = PROCS.PKGID");
        sql.append(" AND ARG.MTDID = PROCS.MTDID");
        if (procType == 1) {
            sql.append(" AND PROCS.IS_PROC = 'Y'");
        } else if (procType == 2) {
            sql.append(" AND PROCS.IS_PROC = 'N'");
        }
        if (StringUtil.isNotEmpty(schName) && (schemaClause = this.makeClause_objWithoutPrec(schName = StringUtil.getEscStringName(schName))) != null) {
            sql.append(" AND SCHEMAS.NAME ");
            sql.append(schemaClause);
        }
        if (StringUtil.isNotEmpty(pkgName) && (pkgClause = this.makeClause_objWithoutPrec(pkgName = StringUtil.getEscStringName(pkgName))) != null) {
            sql.append(" AND PROCS.PKGNAME ");
            sql.append(pkgClause);
        }
        if (StringUtil.isNotEmpty(procName) && (procClause = this.makeClause_objWithoutPrec(procName = StringUtil.getEscStringName(procName))) != null) {
            sql.append(" AND PROCS.MTDNAME ");
            sql.append(procClause);
        }
        if (StringUtil.isNotEmpty(colName) && (colClause = this.makeClause_objWithoutPrec(colName = StringUtil.getEscStringName(colName))) != null) {
            sql.append(" AND ARG.NAME ");
            sql.append(colClause);
        }
        sql.append(" ORDER BY PROCEDURE_SCHEM ASC, PROCEDURE_CAT ASC, PROCEDURE_NAME ASC, ORDINAL_POSITION ASC;");
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (this.connection.isCompatibleOracle() && StringUtil.isNotEmpty(catalog)) {
            try {
                return this.getPkgProcedureColumns(schemaPattern, catalog, procedureNamePattern, columnNamePattern, 0);
            }
            catch (SQLException sQLException) {}
        }
        if (schemaPattern != null && schemaPattern.equals("")) {
            throw new SQLException("There is not a procedure without a schema!");
        }
        if (procedureNamePattern != null && procedureNamePattern.equals("") || columnNamePattern != null && columnNamePattern.equals("")) {
            return null;
        }
        String schemaname = schemaPattern == null ? "%" : StringUtil.getEscStringName(schemaPattern);
        String procname = procedureNamePattern == null ? "%" : StringUtil.getEscStringName(procedureNamePattern);
        String colname = columnNamePattern == null ? "%" : StringUtil.getEscStringName(columnNamePattern);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT ");
        sql.append("NULL AS PROCEDURE_CAT, ");
        sql.append("USERS.NAME AS PROCEDURE_SCHEM, ");
        sql.append("PROCS.NAME AS PROCEDURE_NAME, ");
        if (this.connection.isCompatibleOracle()) {
            sql.append("CASE ARG.INFO1 WHEN 3 THEN NULL ELSE ARG.NAME END AS COLUMN_NAME, ");
        } else {
            sql.append("ARG.NAME AS COLUMN_NAME,");
        }
        sql.append("CASE ARG.INFO1 WHEN 0 THEN 1 WHEN 1 THEN 4 WHEN 2 THEN 2 WHEN 3 THEN 5 END AS COLUMN_TYPE, ");
        sql.append(this.makeDataTypeClause("ARG.TYPE$", "ARG.SCALE"));
        sql.append("AS DATA_TYPE, ");
        sql.append(this.makeDataTypeNameClause("ARG.TYPE$"));
        sql.append("AS TYPE_NAME, ");
        sql.append("CASE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        sql.append("AS \"PRECISION\", ");
        sql.append("CASE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END ");
        sql.append("AS LENGTH, ");
        sql.append("CASE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) END ");
        sql.append("AS SCALE, ");
        sql.append("10 AS RADIX, ");
        sql.append("1 AS NULLABLE, ");
        sql.append("NULL AS REMARKS, ");
        sql.append("ARG.DEFVAL AS COLUMN_DEF, ");
        sql.append("NULL AS SQL_DATA_TYPE, ");
        sql.append("NULL AS SQL_DATETIME_SUB, ");
        sql.append("NULL AS CHAR_OCTET_LENGTH, ");
        sql.append("ARG.COLID AS ORDINAL_POSITION, ");
        sql.append("CASE ARG.NULLABLE$ WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE, ");
        sql.append("NULL AS SPECIFIC_NAME ");
        sql.append("FROM ");
        String schemaClause = this.makeSchemaClause(schemaname);
        sql.append(schemaClause);
        sql.append(" USERS, ");
        String procClause = this.makeProcClause(procname);
        sql.append(procClause);
        sql.append(" PROCS, ");
        sql.append("SYS.SYSCOLUMNS ARG ");
        sql.append("WHERE USERS.ID = PROCS.SCHID AND PROCS.ID = ARG.ID ");
        String columnClause = this.makeClause_objWithoutPrec(colname);
        if (columnClause != null) {
            sql.append(" AND ARG.NAME ");
            sql.append(columnClause);
        }
        sql.append(" ORDER BY PROCEDURE_SCHEM ASC,PROCEDURE_NAME ASC, ORDINAL_POSITION ASC;");
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (schemaPattern != null && schemaPattern.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (tableNamePattern != null && tableNamePattern.equals("")) {
            return null;
        }
        String schemaname = schemaPattern == null ? "%" : StringUtil.getEscStringName(schemaPattern);
        String procname = tableNamePattern == null ? "%" : StringUtil.getEscStringName(tableNamePattern);
        String selectClause = "SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS TABLE_CAT, SCHEMAS.NAME AS TABLE_SCHEM, TABS.NAME AS TABLE_NAME, CASE TABS.SUBTYPE$ WHEN 'UTAB' THEN 'TABLE' WHEN 'VIEW' THEN 'VIEW' WHEN 'STAB' THEN 'SYSTEM TABLE' WHEN 'SYNOM' THEN 'SYNONYM' END AS TABLE_TYPE, (SELECT COMMENT$ FROM SYSTABLECOMMENTS WHERE SCHNAME = SCHEMAS.NAME AND TVNAME = TABS.NAME) AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SELF_REFERENCING_COL_NAME, NULL AS REF_GENERATION ";
        String schemaClause = this.makeSchemaClause(schemaname);
        String tableClause = this.makeClause_objWithoutPrec(procname);
        String fromClause = " FROM " + schemaClause + " SCHEMAS," + " (SELECT * FROM SYS.SYSOBJECTS ";
        String typeClause = this.makeTableTypeClause(types);
        if (typeClause != null || tableClause != null) {
            fromClause = String.valueOf(fromClause) + " WHERE ";
            if (typeClause != null) {
                fromClause = String.valueOf(fromClause) + typeClause;
                if (tableClause != null) {
                    fromClause = String.valueOf(fromClause) + " AND NAME " + tableClause;
                }
            } else if (tableClause != null) {
                fromClause = String.valueOf(fromClause) + " NAME " + tableClause;
            }
        }
        fromClause = String.valueOf(fromClause) + ") TABS";
        String whereClause = " WHERE TABS.SCHID = SCHEMAS.ID ";
        if (this.m_priv) {
            whereClause = String.valueOf(whereClause) + " AND (SCHEMAS.PID = UID() OR EXISTS (SELECT * FROM SYS.SYSGRANTS WHERE (URID = UID() OR URID = 67108866) AND (TABS.ID = OBJID AND (PRIVID = -1 OR PRIVID = 8192)))) ";
        }
        String orderClause = " ORDER BY TABLE_TYPE ASC,TABLE_SCHEM ASC,TABLE_NAME ASC;";
        String sql = String.valueOf(selectClause) + fromClause + whereClause + orderClause;
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    private String makeSchemaClause(String schemaname) {
        String schemaClause = null;
        schemaClause = this.getEscape(schemaname) ? (schemaname.equalsIgnoreCase("%") ? "(SELECT ID, NAME, PID FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCH') " : "(SELECT ID, NAME, PID FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCH' AND NAME LIKE '" + schemaname + "' " + this.m_esp + " ) ") : "(SELECT ID, NAME, PID FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCH' AND NAME = '" + schemaname + "' ) ";
        return schemaClause;
    }

    private String makeTableClause(String tabName) {
        String clause = null;
        clause = this.getEscape(tabName) ? (tabName.equalsIgnoreCase("%") ? "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ IN('UTAB', 'STAB', 'VIEW')) " : "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ IN('UTAB', 'STAB', 'VIEW') AND NAME LIKE '" + tabName + "' " + this.m_esp + " ) ") : "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ IN('UTAB', 'STAB', 'VIEW') AND NAME = '" + tabName + "' ) ";
        return clause;
    }

    private String makeTableClause_utab(String tabName) {
        String clause = null;
        clause = this.getEscape(tabName) ? (tabName.equalsIgnoreCase("%") ? "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'UTAB') " : "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'UTAB' AND NAME LIKE '" + tabName + "' " + this.m_esp + " ) ") : "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'UTAB' AND NAME = '" + tabName + "' ) ";
        return clause;
    }

    private String makeProcClause(String procName) {
        String clause = null;
        clause = this.getEscape(procName) ? (procName.equalsIgnoreCase("%") ? "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'PROC' " : "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'PROC' AND NAME LIKE '" + procName + "' " + this.m_esp) : "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'PROC' AND NAME = '" + procName + "' ";
        if (clause != null) {
            if (!this.connection.isCompatibleOracle()) {
                clause = String.valueOf(clause) + " AND INFO1&0X01 = 1";
            }
            clause = String.valueOf(clause) + ")";
        }
        return clause;
    }

    private String makeFuncClause(String funcName) {
        String clause = null;
        clause = this.getEscape(funcName) ? (funcName.equalsIgnoreCase("%") ? "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'PROC' AND INFO1&0X01 = 0) " : "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'PROC' AND INFO1&0X01 = 0 AND NAME LIKE '" + funcName + "' " + this.m_esp + " ) ") : "(SELECT ID, SCHID, NAME FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'PROC' AND INFO1&0X01 = 0 AND NAME = '" + funcName + "' ) ";
        return clause;
    }

    private String makeClause_objWithoutPrec(String tpname) {
        String tableClause = null;
        if (this.getEscape(tpname)) {
            if (!tpname.equalsIgnoreCase("%")) {
                tableClause = "LIKE '" + tpname + "' " + this.m_esp;
            }
        } else {
            tableClause = "= '" + tpname + "' ";
        }
        return tableClause;
    }

    private String makeTableTypeClause(String[] types) {
        String typeClause = "";
        String retTypeClause = "(";
        String subpartitionClause = "CAST((INFO3 & 0x00FF & 0x003F) AS INT) != 9 AND CAST((INFO3 & 0x00FF & 0x003F) AS INT) != 27 AND CAST((INFO3 & 0x00FF & 0x003F) AS INT) != 29 AND CAST((INFO3 & 0x00FF & 0x003F) AS INT) != 25 AND CAST((INFO3 & 0x00FF & 0x003F) AS INT) != 12 AND CAST((INFO3 & 0x00FF & 0x003F) AS INT) != 7 AND CAST((INFO3 & 0x00FF & 0x003F) AS INT) != 21 AND CAST((INFO3 & 0x00FF & 0x003F) AS INT) != 23 AND CAST((INFO3 & 0x00FF & 0x003F) AS INT) != 18 AND CAST((INFO3 & 0x00FF & 0x003F) AS INT) != 5";
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                if (types[i].equalsIgnoreCase("TABLE")) {
                    typeClause = String.valueOf(typeClause) + "OR (SUBTYPE$='UTAB' AND " + subpartitionClause + ")";
                } else if (types[i].equalsIgnoreCase("VIEW")) {
                    typeClause = String.valueOf(typeClause) + "OR SUBTYPE$='VIEW' ";
                } else if (types[i].equalsIgnoreCase("SYSTEM TABLE")) {
                    typeClause = String.valueOf(typeClause) + "OR SUBTYPE$='STAB' ";
                } else if (types[i].equalsIgnoreCase("SYNONYM")) {
                    typeClause = String.valueOf(typeClause) + "OR SUBTYPE$='SYNOM' ";
                }
                ++i;
            }
            if (typeClause.length() > 3) {
                retTypeClause = String.valueOf(retTypeClause) + typeClause.substring(3);
                retTypeClause = String.valueOf(retTypeClause) + ")";
                return retTypeClause;
            }
        }
        return null;
    }

    public ResultSet getSchemas() throws SQLException {
        String sql = new String("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NAME AS TABLE_SCHEM, NULL AS TABLE_CATALOG ");
        sql = String.valueOf(sql) + " FROM SYS.SYSOBJECTS USERS WHERE TYPE$='SCH'";
        sql = String.valueOf(sql) + " ORDER BY TABLE_SCHEM ASC;";
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getCatalogs() throws SQLException {
        String sql = "SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS TABLE_CAT FROM SYS.SYSDUAL WHERE 1=2;";
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getTableTypes() throws SQLException {
        String sql = "(SELECT 'SYSTEM TABLE' AS TABLE_TYPE FROM SYS.SYSDUAL UNION SELECT 'TABLE' AS TABLE_TYPE FROM SYS.SYSDUAL) UNION SELECT 'VIEW' AS TABLE_TYPE FROM SYS.SYSDUAL ";
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (schemaPattern != null && schemaPattern.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (tableNamePattern != null && tableNamePattern.equals("") || columnNamePattern != null && columnNamePattern.equals("")) {
            return null;
        }
        String schemaname = schemaPattern == null ? "%" : StringUtil.getEscStringName(schemaPattern);
        String tablename = tableNamePattern == null ? "%" : StringUtil.getEscStringName(tableNamePattern);
        String columnname = columnNamePattern == null ? "%" : StringUtil.getEscStringName(columnNamePattern);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT ");
        sql.append("NULL AS TABLE_CAT, ");
        sql.append("SCHS.NAME AS TABLE_SCHEM, ");
        sql.append("TABS.NAME AS TABLE_NAME, ");
        sql.append("COLS.NAME AS COLUMN_NAME, ");
        sql.append(this.makeDataTypeClause("COLS.TYPE$", "COLS.SCALE"));
        sql.append("AS DATA_TYPE,");
        sql.append(this.makeDataTypeNameClause("COLS.TYPE$"));
        sql.append("AS TYPE_NAME,");
        sql.append("CASE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END ");
        sql.append("AS COLUMN_SIZE,");
        sql.append("CASE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END ");
        sql.append("AS BUFFER_LENGTH,");
        sql.append("CASE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) END ");
        sql.append("AS DECIMAL_DIGITS,");
        sql.append("10 AS NUM_PREC_RADIX,");
        sql.append("CASE COLS.NULLABLE$ WHEN 'Y' THEN 1 ELSE 0 END AS NULLABLE,");
        sql.append("(SELECT COMMENT$ FROM SYSCOLUMNCOMMENTS WHERE SCHNAME=SCHS.NAME AND TVNAME=TABS.NAME AND COLNAME=COLS.NAME) AS REMARKS,");
        sql.append("COLS.DEFVAL AS COLUMN_DEF,");
        sql.append("0 AS SQL_DATA_TYPE,");
        sql.append("0 AS SQL_DATETIME_SUB,");
        sql.append("CASE SF_GET_OCT_LENGTH(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT)) ");
        sql.append("WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_OCT_LENGTH(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT)) END ");
        sql.append("AS CHAR_OCTET_LENGTH,");
        sql.append("COLS.COLID + 1 AS ORDINAL_POSITION,");
        sql.append("CASE COLS.NULLABLE$ WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE,");
        sql.append("NULL AS SCOPE_CATLOG,");
        sql.append("NULL AS SCOPE_SCHEMA,");
        sql.append("NULL AS SCOPE_TABLE,");
        sql.append("0 AS SOURCE_DATA_TYPE ");
        sql.append("FROM ");
        String schemaClause = this.makeSchemaClause(schemaname);
        sql.append(schemaClause);
        sql.append(" AS SCHS, ");
        String tabClause = this.makeTableClause(tablename);
        sql.append(tabClause);
        sql.append(" AS TABS, ");
        sql.append("SYS.SYSCOLUMNS AS COLS");
        sql.append(" WHERE TABS.ID = COLS.ID AND SCHS.ID = TABS.SCHID ");
        String colClause = this.makeClause_objWithoutPrec(columnname);
        if (colClause != null) {
            sql.append("AND COLS.NAME ");
            sql.append(colClause);
        }
        sql.append(" ORDER BY TABLE_SCHEM ASC,TABLE_NAME ASC,ORDINAL_POSITION ASC;");
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    private String makeDataTypeNameClause(String typeColName) {
        return "CASE INSTR(" + typeColName + ",'CLASS',1,1) WHEN 0 THEN " + typeColName + " ELSE SF_GET_CLASS_NAME(" + typeColName + ") END ";
    }

    private String makeDataTypeClause(String typeColName, String scaleColName) {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append("CASE " + typeColName);
        if (this.connection.isCompatibleOracle()) {
            sBuffer.append(" WHEN 'NUMBER' THEN 3");
            sBuffer.append(" WHEN 'NUMERIC' THEN 3");
        } else {
            sBuffer.append(" WHEN 'NUMBER' THEN 2");
            sBuffer.append(" WHEN 'NUMERIC' THEN 2");
        }
        sBuffer.append(" WHEN 'TIMESTAMP' THEN 93");
        sBuffer.append(" WHEN 'CHARACTER' THEN 1");
        sBuffer.append(" WHEN 'VARCHAR' THEN 12");
        sBuffer.append(" WHEN 'VARCHAR2' THEN 12");
        sBuffer.append(" WHEN 'DEC' THEN 3");
        sBuffer.append(" WHEN 'DECIMAL' THEN 3");
        sBuffer.append(" WHEN 'BIT' THEN -7");
        sBuffer.append(" WHEN 'INT' THEN 4");
        sBuffer.append(" WHEN 'INTEGER' THEN 4");
        sBuffer.append(" WHEN 'BIGINT' THEN -5");
        sBuffer.append(" WHEN 'BYTE' THEN -6");
        sBuffer.append(" WHEN 'TINYINT' THEN -6");
        sBuffer.append(" WHEN 'SMALLINT' THEN 5");
        sBuffer.append(" WHEN 'BINARY' THEN -2");
        sBuffer.append(" WHEN 'VARBINARY' THEN -3");
        sBuffer.append(" WHEN 'FLOAT' THEN 6");
        sBuffer.append(" WHEN 'DOUBLE' THEN 8");
        sBuffer.append(" WHEN 'REAL' THEN 7");
        sBuffer.append(" WHEN 'DOUBLE PRECISION' THEN 8");
        sBuffer.append(" WHEN 'DATE' THEN 91");
        sBuffer.append(" WHEN 'TIME' THEN 92");
        sBuffer.append(" WHEN 'DATETIME' THEN 93");
        sBuffer.append(" WHEN 'TEXT' THEN -1");
        sBuffer.append(" WHEN 'LONGVARCHAR' THEN -1");
        sBuffer.append(" WHEN 'IMAGE' THEN -4");
        sBuffer.append(" WHEN 'LONGVARBINARY' THEN -4");
        sBuffer.append(" WHEN 'BLOB' THEN 2004");
        sBuffer.append(" WHEN 'CLOB' THEN 2005");
        sBuffer.append(" WHEN 'CURSOR' THEN -10");
        sBuffer.append(" WHEN 'BOOL' THEN 16");
        sBuffer.append(" WHEN 'BOOLEAN' THEN 16");
        sBuffer.append(" ELSE SF_GET_DATA_TYPE(" + typeColName + ", CAST(" + scaleColName + " AS INT), 3)");
        sBuffer.append(" END ");
        return sBuffer.toString();
    }

    private boolean getEscape(String str) {
        boolean flag = false;
        int len = str.length();
        if (len == 1) {
            return str.charAt(0) == '%' || str.charAt(0) == '_';
        }
        int i = len - 1;
        while (i >= 0) {
            if (str.charAt(i) == '%' || str.charAt(i) == '_') {
                flag = true;
            }
            --i;
        }
        return flag;
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        if (table == null) {
            throw new SQLException("NULL TABLE NAME");
        }
        if (schema != null && schema.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (table != null && table.equals("") || columnNamePattern != null && columnNamePattern.equals("")) {
            return null;
        }
        String schemaname = schema == null ? this.connection.getCurrentUserName() : schema;
        String tablename = table;
        String columnname = columnNamePattern == null ? "%" : columnNamePattern;
        schemaname = StringUtil.getEscStringName(schemaname);
        tablename = StringUtil.getEscStringName(tablename);
        columnname = StringUtil.getEscStringName(columnname);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS TABLE_CAT,'");
        sql.append(schemaname);
        sql.append("' AS TABLE_SCHEM, '");
        sql.append(tablename);
        sql.append("' AS TABLE_NAME, ");
        sql.append("COLS.NAME AS COLUMN_NAME, ");
        sql.append("GRANTORS.NAME AS GRANTOR,");
        sql.append("GRANTEES.NAME AS GRANTEE,");
        sql.append("SF_GET_SYS_PRIV(CAST (COLGRANTS.PRIVID AS INT)) AS PRIVILEGE, ");
        sql.append("CASE COLGRANTS.GRANTABLE WHEN 'Y' THEN 'YES' WHEN 'N' THEN 'NO' END AS IS_GRANTABLE ");
        sql.append("FROM SYS.SYSGRANTS COLGRANTS, ");
        sql.append("SYS.SYSCOLUMNS COLS, ");
        sql.append("SYS.SYSOBJECTS GRANTORS, ");
        sql.append("(SELECT ID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='USER' OR SUBTYPE$='ROLE') GRANTEES,");
        sql.append("(SELECT ID, NAME, SCHID FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCHOBJ' AND SUBTYPE$ = 'UTAB') TABS ");
        sql.append("WHERE TABS.SCHID = ");
        sql.append("(SELECT ID FROM SYS.SYSOBJECTS WHERE TYPE$ = 'SCH' AND NAME = '");
        sql.append(schemaname);
        sql.append("') AND TABS.NAME = '");
        sql.append(tablename);
        sql.append("' AND COLGRANTS.OBJID = TABS.ID ");
        String colClause = this.makeClause_objWithoutPrec(columnname);
        if (colClause != null) {
            sql.append("AND COLS.NAME ");
            sql.append(colClause);
        }
        sql.append(" AND COLGRANTS.GRANTOR = GRANTORS.ID AND COLGRANTS.URID = GRANTEES.ID AND ");
        sql.append("COLGRANTS.COLID = COLS.COLID AND COLGRANTS.OBJID = COLS.ID");
        sql.append(" ORDER BY COLUMN_NAME ASC,PRIVILEGE ASC;");
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (schemaPattern != null && schemaPattern.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (tableNamePattern != null && tableNamePattern.equals("")) {
            return null;
        }
        String schemaname = schemaPattern == null ? "%" : StringUtil.getEscStringName(schemaPattern);
        String tablename = tableNamePattern == null ? "%" : StringUtil.getEscStringName(tableNamePattern);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS TABLE_CAT,");
        sql.append("USERS.NAME AS TABLE_SCHEM, ");
        sql.append("TABS.NAME AS TABLE_NAME,");
        sql.append("GRANTORS.NAME AS GRANTOR,");
        sql.append("GRANTEES.NAME AS GRANTEE,");
        sql.append("SF_GET_SYS_PRIV(CAST (TVGRANTS.PRIVID AS INT)) AS PRIVILEGE,");
        sql.append("CASE TVGRANTS.GRANTABLE WHEN 'Y' THEN 'YES' WHEN 'N' THEN 'NO' END AS IS_GRANTABLE");
        sql.append(" FROM ");
        String scheClause = this.makeSchemaClause(schemaname);
        sql.append(scheClause);
        sql.append(" USERS, ");
        String utbClause = this.makeTableClause_utab(tablename);
        sql.append(utbClause);
        sql.append(" TABS, ");
        sql.append("SYS.SYSGRANTS TVGRANTS, SYS.SYSOBJECTS AS GRANTORS, SYS.SYSOBJECTS AS GRANTEES ");
        sql.append("WHERE ");
        sql.append("GRANTORS.TYPE$ = 'UR' AND GRANTORS.SUBTYPE$ = 'USER' AND ");
        sql.append("GRANTEES.TYPE$ = 'UR' AND GRANTEES.SUBTYPE$ = 'USER' AND ");
        sql.append("TABS.SCHID = USERS.ID AND ");
        sql.append("TVGRANTS.OBJID = TABS.ID AND TVGRANTS.URID = GRANTEES.ID AND ");
        sql.append("TVGRANTS.GRANTOR = GRANTORS.ID AND TVGRANTS.PRIVID <> -1");
        sql.append("ORDER BY  TABLE_SCHEM ASC, TABLE_NAME ASC,  PRIVILEGE ASC;");
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String tab2;
        String sch2;
        String tab;
        if (schema != null && schema.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (table != null && table.equals("")) {
            return null;
        }
        String sch = schema == null ? "%" : schema;
        String string = tab = table == null ? "%" : table;
        if (this.connection.getCaseSensitive()) {
            sch2 = StringUtil.getEscStringName(sch);
            tab2 = StringUtil.getEscStringName(tab);
        } else {
            sch2 = StringUtil.getEscStringName(sch).toUpperCase();
            tab2 = StringUtil.getEscStringName(tab).toUpperCase();
        }
        String sql = "";
        ResultSet pk = this.getPrimaryKeys(catalog, schema, table);
        if (pk.next()) {
            sql = String.valueOf(sql) + "SELECT /*+ MAX_OPT_N_TABLES(5) */ '" + scope + "' as \"SCOPE\",COLS.NAME AS COLUMN_NAME," + this.makeDataTypeClause("COLS.TYPE$", "COLS.SCALE") + "AS DATA_TYPE, " + this.makeDataTypeNameClause("COLS.TYPE$") + "AS TYPE_NAME, " + "CASE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS COLUMN_SIZE,CASE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS BUFFER_LENGTH,CASE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) END AS DECIMAL_DIGITS,0 AS PSEUDO_COLUMN";
            sql = String.valueOf(sql) + " FROM SYS.SYSCOLUMNS COLS WHERE COLS.NAME IN (SELECT COLS.NAME FROM SYS.SYSINDEXES SYSIND,SYS.SYSCOLUMNS COLS, (SELECT ID, PID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS IND_OBJ, SYS.SYSCONS AS CONS WHERE CONS.TABLEID = (SELECT ID FROM SYS.SYSOBJECTS WHERE SUBTYPE$='UTAB' AND NAME = '" + tab2 + "' AND SCHID = (SELECT ID FROM " + "SYS.SYSOBJECTS WHERE TYPE$='SCH' AND NAME = '" + sch2 + "')) AND COLS.ID = CONS.TABLEID AND IND_OBJ.ID = CONS.INDEXID AND IND_OBJ.ID = SYSIND.ID AND CONS.TYPE$ = 'P' AND SF_COL_IS_IDX_KEY(SYSIND.KEYNUM, SYSIND.KEYINFO,COLS.COLID)=1) " + "AND COLS.ID = (SELECT ID FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='UTAB' AND NAME = '" + tab2 + "' AND SCHID = (SELECT ID FROM " + "SYS.SYSOBJECTS WHERE TYPE$='SCH' AND NAME = '" + sch2 + "'))";
            if (!nullable) {
                sql = String.valueOf(sql) + " AND COLS.NULLABLE$ = 'N'";
            }
        } else {
            sql = String.valueOf(sql) + "select /*+ MAX_OPT_N_TABLES(5) */ '" + scope + "' as \"SCOPE\",'ROWID' as COLUMN_NAME,-2 as DATA_TYPE,'LONG' as TYPE_NAME,8 as COLUMN_SIZE,8 as BUFFER_LENGTH,0 as DECIMAL_DIGITS,0 as PSEUDO_COLUMN";
        }
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        if (schema != null && schema.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (table != null && table.equals("")) {
            return null;
        }
        String sql = "";
        sql = String.valueOf(sql) + "SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL AS \"SCOPE\",COLS.NAME AS COLUMN_NAME, ";
        sql = String.valueOf(sql) + this.makeDataTypeClause("COLS.TYPE$", "COLS.SCALE") + "AS DATA_TYPE, ";
        sql = String.valueOf(sql) + this.makeDataTypeNameClause("COLS.TYPE$") + "AS TYPE_NAME, ";
        sql = String.valueOf(sql) + "CASE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_COLUMN_SIZE(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS COLUMN_SIZE,CASE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_BUFFER_LEN(COLS.TYPE$, CAST (COLS.LENGTH$ AS INT), CAST (COLS.SCALE AS INT)) END AS BUFFER_LENGTH,CASE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE SF_GET_DECIMAL_DIGITS(COLS.TYPE$, CAST (COLS.SCALE AS INT)) END AS DECIMAL_DIGITS,0 AS PSEUDO_COLUMN";
        sql = String.valueOf(sql) + " FROM SYS.SYSCOLUMNS COLS WHERE 1 = 2;";
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            throw new SQLException("NULL TABLE NAME");
        }
        if (schema != null && schema.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (table != null && table.equals("")) {
            return null;
        }
        String schemaname = schema == null ? this.connection.getCurrentUserName() : StringUtil.getEscStringName(schema);
        String tablename = StringUtil.getEscStringName(table);
        String sql = "SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS TABLE_CAT, '" + schemaname + "' AS TABLE_SCHEM,'" + tablename + "' AS TABLE_NAME,COLS.NAME AS COLUMN_NAME,SF_GET_INDEX_KEY_SEQ(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID) AS KEY_SEQ,CONS.NAME AS PK_NAME" + " FROM " + "SYS.SYSINDEXES INDS, (SELECT OBJ.NAME, CON.ID, CON.TYPE$, CON.TABLEID, CON.COLID, CON.INDEXID FROM " + "SYS.SYSCONS AS CON, " + "SYS.SYSOBJECTS AS OBJ WHERE OBJ.SUBTYPE$='CONS' AND OBJ.ID=CON.ID) CONS, " + "SYS.SYSCOLUMNS COLS, (SELECT NAME ,ID FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='UTAB' AND NAME = '" + tablename + "' AND SCHID=(SELECT ID FROM " + "SYS.SYSOBJECTS WHERE NAME = '" + schemaname + "' AND TYPE$='SCH')) TAB, (SELECT ID, NAME FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX')OBJ_INDS WHERE CONS.TYPE$='P' " + "AND CONS.INDEXID=INDS.ID AND INDS.ID=OBJ_INDS.ID AND TAB.ID=COLS.ID AND CONS.TABLEID=TAB.ID " + "AND SF_COL_IS_IDX_KEY(INDS.KEYNUM, INDS.KEYINFO,COLS.COLID)=1" + " ORDER BY COLUMN_NAME ASC;";
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String tab2;
        String sch2;
        String schemaname;
        if (table == null) {
            throw new SQLException("NULL TABLE NAME");
        }
        String string = schemaname = schema == null ? this.connection.getCurrentUserName() : schema;
        if (table != null && table.equals("")) {
            return null;
        }
        String tablename = table;
        if (this.connection.getCaseSensitive()) {
            sch2 = StringUtil.getEscStringName(schemaname);
            tab2 = StringUtil.getEscStringName(tablename);
        } else {
            sch2 = StringUtil.getEscStringName(schemaname).toUpperCase();
            tab2 = StringUtil.getEscStringName(tablename).toUpperCase();
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS PKTABLE_CAT,");
        strBuf.append("T_REFED.SCHNAME AS PKTABLE_SCHEM, ");
        strBuf.append("T_REFED.NAME AS PKTABLE_NAME, ");
        strBuf.append("T_REFED.REFED_COL_NAME AS PKCOLUMN_NAME, NULL AS FKTABLE_CAT, '");
        strBuf.append(sch2);
        strBuf.append("' AS FKTABLE_SCHEM, '");
        strBuf.append(tab2);
        strBuf.append("' AS FKTABLE_NAME, T_REF.REF_COL_NAME AS FKCOLUMN_NAME, ");
        strBuf.append("T_REF.REF_KEYNO AS KEY_SEQ, SF_GET_UPD_RULE(T_REF.FACTION) AS UPDATE_RULE, SF_GET_DEL_RULE(T_REF.FACTION) AS DELETE_RULE, ");
        strBuf.append("T_REF.REF_CONS_NAME AS FK_NAME, T_REFED.REFED_CONS_NAME AS PK_NAME, ");
        strBuf.append("0 AS DEFERRABILITY ");
        strBuf.append("FROM ");
        strBuf.append("(SELECT T_REF_CONS.FINDEXID AS REFED_ID, T_REF_CONS.NAME AS REF_CONS_NAME, ");
        strBuf.append("SF_GET_INDEX_KEY_SEQ(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID) AS REF_KEYNO, T_REF_COL.NAME AS REF_COL_NAME, T_REF_CONS.FACTION AS FACTION ");
        strBuf.append("FROM ");
        strBuf.append("(SELECT NAME, INDEXID, FINDEXID, TABLEID, FACTION, CONS.TYPE$ as TYPE FROM SYS.SYSCONS CONS, SYS.SYSOBJECTS OBJECTS WHERE CONS.ID = OBJECTS.ID) AS T_REF_CONS, ");
        strBuf.append("(SELECT NAME, ID FROM SYS.SYSOBJECTS WHERE SUBTYPE$='UTAB' AND NAME= '");
        strBuf.append(tab2);
        strBuf.append("' AND SCHID = (SELECT ID FROM SYS.SYSOBJECTS WHERE TYPE$='SCH' AND NAME = '");
        strBuf.append(sch2);
        strBuf.append("')) AS T_REF_TAB, ");
        strBuf.append("SYS.SYSINDEXES AS T_REF_IND, ");
        strBuf.append("(SELECT ID, PID FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REF_INDS_OBJ, ");
        strBuf.append("SYS.SYSCOLUMNS AS T_REF_COL ");
        strBuf.append("WHERE ");
        strBuf.append("T_REF_TAB.ID = T_REF_CONS.TABLEID AND T_REF_CONS.TYPE='F' AND T_REF_TAB.ID = T_REF_INDS_OBJ.PID AND T_REF_TAB.ID = T_REF_COL.ID ");
        strBuf.append("AND T_REF_CONS.INDEXID = T_REF_INDS_OBJ.ID AND T_REF_IND.ID = T_REF_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID)=1) AS T_REF, ");
        strBuf.append("(SELECT T_REFED_CONS.INDEXID AS REFED_ID, T_REFED_TAB.SCH_NAME AS SCHNAME, ");
        strBuf.append("T_REFED_TAB.TAB_NAME AS NAME, T_REFED_IND.ID AS REFED_IND_ID, ");
        strBuf.append("T_REFED_CONS.NAME AS REFED_CONS_NAME, SF_GET_INDEX_KEY_SEQ(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID) AS REFED_KEYNO, ");
        strBuf.append("T_REFED_COL.NAME AS REFED_COL_NAME FROM ");
        strBuf.append("(SELECT NAME, INDEXID, FINDEXID, TABLEID, FACTION, CONS.TYPE$ as TYPE FROM SYS.SYSCONS CONS, SYS.SYSOBJECTS OBJECTS WHERE CONS.ID = OBJECTS.ID) AS T_REFED_CONS, ");
        strBuf.append("(SELECT TAB.ID AS ID, TAB.NAME AS TAB_NAME, SCH.NAME AS SCH_NAME FROM ");
        strBuf.append("SYS.SYSOBJECTS TAB, ");
        strBuf.append("SYS.SYSOBJECTS SCH WHERE TAB.SUBTYPE$='UTAB' AND SCH.TYPE$='SCH' AND TAB.SCHID=SCH.ID) AS T_REFED_TAB, ");
        strBuf.append("SYS.SYSINDEXES AS T_REFED_IND, (SELECT ID, PID, NAME FROM ");
        strBuf.append("SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REFED_INDS_OBJ, ");
        strBuf.append("SYS.SYSCOLUMNS AS T_REFED_COL WHERE ");
        strBuf.append("T_REFED_TAB.ID = T_REFED_CONS.TABLEID AND T_REFED_CONS.TYPE='P' AND T_REFED_TAB.ID = T_REFED_INDS_OBJ.PID AND T_REFED_TAB.ID = T_REFED_COL.ID");
        strBuf.append(" AND T_REFED_CONS.INDEXID = T_REFED_INDS_OBJ.ID AND T_REFED_IND.ID = T_REFED_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID)=1) AS T_REFED ");
        strBuf.append("WHERE T_REF.REFED_ID = T_REFED.REFED_ID AND T_REF.REF_KEYNO = T_REFED.REFED_KEYNO ");
        strBuf.append("ORDER BY FKTABLE_CAT ASC, FKTABLE_SCHEM ASC, FKTABLE_NAME ASC, KEY_SEQ ASC");
        String sql = strBuf.toString();
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String tab2;
        String sch2;
        String schemaname;
        if (table == null) {
            throw new SQLException("NULL TABLE NAME");
        }
        String string = schemaname = schema == null ? this.connection.getCurrentUserName() : schema;
        if (table != null && table.equals("")) {
            return null;
        }
        String tablename = table;
        if (this.connection.getCaseSensitive()) {
            sch2 = StringUtil.getEscStringName(schemaname);
            tab2 = StringUtil.getEscStringName(tablename);
        } else {
            sch2 = StringUtil.getEscStringName(schemaname).toUpperCase();
            tab2 = StringUtil.getEscStringName(tablename).toUpperCase();
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS PKTABLE_CAT, '");
        strBuf.append(sch2);
        strBuf.append("' AS PKTABLE_SCHEM, '");
        strBuf.append(tab2);
        strBuf.append("' AS PKTABLE_NAME, T_REFED.REFED_COL_NAME AS PKCOLUMN_NAME, ");
        strBuf.append("NULL AS FKTABLE_CAT, T_REF.REF_SCH_NAME AS FKTABLE_SCHEM, ");
        strBuf.append("T_REF.REF_TAB_NAME AS FKTABLE_NAME, T_REF.REF_COL_NAME AS FKCOLUMN_NAME, ");
        strBuf.append("T_REF.REF_KEYNO AS KEY_SEQ, SF_GET_UPD_RULE(T_REF.FACTION) AS UPDATE_RULE, SF_GET_DEL_RULE(T_REF.FACTION) AS DELETE_RULE, ");
        strBuf.append("(SELECT NAME FROM SYS.SYSOBJECTS WHERE ID = T_REF.REF_CONS_ID) AS FK_NAME, (SELECT NAME FROM SYS.SYSOBJECTS WHERE ID = T_REFED.REFED_CONS_ID) AS PK_NAME, ");
        strBuf.append("0 AS DEFERRABILITY FROM ");
        strBuf.append("(SELECT T_REF_TAB.SCH_NAME AS REF_SCH_NAME, T_REF_TAB.TAB_NAME AS REF_TAB_NAME, ");
        strBuf.append("T_REF_CONS.ID AS REF_CONS_ID, SF_GET_INDEX_KEY_SEQ(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID) AS REF_KEYNO, ");
        strBuf.append("T_REF_COL.NAME AS REF_COL_NAME, T_REF_CONS.FINDEXID AS REFED_ID, T_REF_CONS.FACTION AS FACTION FROM ");
        strBuf.append("SYS.SYSCONS AS T_REF_CONS, ");
        strBuf.append("(SELECT TAB.ID AS ID, TAB.NAME AS TAB_NAME, SCH.NAME AS SCH_NAME FROM ");
        strBuf.append("SYS.SYSOBJECTS TAB, ");
        strBuf.append("SYS.SYSOBJECTS SCH WHERE TAB.SUBTYPE$='UTAB' AND SCH.TYPE$='SCH' AND TAB.SCHID=SCH.ID) AS T_REF_TAB, ");
        strBuf.append("SYS.SYSINDEXES AS T_REF_IND,");
        strBuf.append("(SELECT ID, PID, NAME FROM ");
        strBuf.append("SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REF_INDS_OBJ, ");
        strBuf.append("SYS.SYSCOLUMNS AS T_REF_COL WHERE ");
        strBuf.append("T_REF_TAB.ID = T_REF_CONS.TABLEID AND T_REF_CONS.TYPE$='F' AND T_REF_TAB.ID = T_REF_INDS_OBJ.PID AND T_REF_TAB.ID = T_REF_COL.ID ");
        strBuf.append("AND T_REF_CONS.INDEXID = T_REF_INDS_OBJ.ID AND T_REF_IND.ID = T_REF_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REF_IND.KEYNUM, T_REF_IND.KEYINFO, T_REF_COL.COLID)=1) AS T_REF, ");
        strBuf.append("(SELECT T_REFED_CONS.ID AS REFED_CONS_ID, SF_GET_INDEX_KEY_SEQ(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID) AS REFED_KEYNO, ");
        strBuf.append("T_REFED_COL.NAME AS REFED_COL_NAME, T_REFED_CONS.INDEXID AS REFED_ID FROM ");
        strBuf.append("SYS.SYSCONS AS T_REFED_CONS, (SELECT NAME, ID FROM ");
        strBuf.append("SYS.SYSOBJECTS WHERE SUBTYPE$='UTAB' AND NAME= '");
        strBuf.append(tab2);
        strBuf.append("' AND SCHID=(SELECT ID FROM ");
        strBuf.append("SYS.SYSOBJECTS WHERE TYPE$='SCH' AND NAME= '");
        strBuf.append(sch2);
        strBuf.append("')) AS T_REFED_TAB, ");
        strBuf.append("SYS.SYSINDEXES AS T_REFED_IND, ");
        strBuf.append("(SELECT ID, PID, NAME FROM ");
        strBuf.append("SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REFED_INDS_OBJ, ");
        strBuf.append("SYS.SYSCOLUMNS AS T_REFED_COL WHERE ");
        strBuf.append("T_REFED_TAB.ID = T_REFED_CONS.TABLEID AND T_REFED_CONS.TYPE$='P' AND T_REFED_TAB.ID = T_REFED_INDS_OBJ.PID AND T_REFED_TAB.ID = T_REFED_COL.ID ");
        strBuf.append("AND T_REFED_CONS.INDEXID = T_REFED_INDS_OBJ.ID AND T_REFED_IND.ID = T_REFED_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REFED_IND.KEYNUM, T_REFED_IND.KEYINFO, T_REFED_COL.COLID)=1) AS T_REFED ");
        strBuf.append(" WHERE T_REF.REFED_ID = T_REFED.REFED_ID AND ");
        strBuf.append("T_REF.REF_KEYNO = T_REFED.REFED_KEYNO ORDER BY FKTABLE_CAT ASC, ");
        strBuf.append("FKTABLE_SCHEM ASC, FKTABLE_NAME ASC, KEY_SEQ ASC");
        String sql = strBuf.toString();
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String ftab2;
        String fsch2;
        String ptab2;
        String psch2;
        if (primaryTable == null || foreignTable == null) {
            throw new SQLException("NULL TABLE NAME");
        }
        if (primarySchema != null && primarySchema.equals("") || foreignSchema != null && foreignSchema.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (primaryTable != null && primaryTable.equals("") || foreignTable != null && foreignTable.equals("")) {
            return null;
        }
        String pschemaname = primarySchema == null ? this.connection.getCurrentUserName() : primarySchema;
        String ptablename = primaryTable;
        String fschemaname = foreignSchema == null ? this.connection.getCurrentUserName() : foreignSchema;
        String ftablename = foreignTable;
        if (this.connection.getCaseSensitive()) {
            psch2 = StringUtil.getEscStringName(pschemaname);
            ptab2 = StringUtil.getEscStringName(ptablename);
            fsch2 = StringUtil.getEscStringName(fschemaname);
            ftab2 = StringUtil.getEscStringName(ftablename);
        } else {
            psch2 = StringUtil.getEscStringName(pschemaname).toUpperCase();
            ptab2 = StringUtil.getEscStringName(ptablename).toUpperCase();
            fsch2 = StringUtil.getEscStringName(fschemaname).toUpperCase();
            ftab2 = StringUtil.getEscStringName(ftablename).toUpperCase();
        }
        String sql = "SELECT /*+ MAX_OPT_N_TABLES(5) */ NULL AS PKTABLE_CAT, '" + psch2 + "' AS PKTABLE_SCHEM,'" + ptab2 + "' AS PKTABLE_NAME,T_REFED.REFED_COL_NAME AS PKCOLUMN_NAME, NULL AS FKTABLE_CAT, '" + fsch2 + "' AS FKTABLE_SCHEM,'" + ftab2 + "' AS FKTABLE_NAME,T_REF.REF_COL_NAME AS FKCOLUMN_NAME,T_REF.REF_KEYNO AS KEY_SEQ, SF_GET_UPD_RULE(FACTION) AS UPDATE_RULE, SF_GET_DEL_RULE(FACTION) AS DELETE_RULE,T_REF.REF_CONS_NAME AS FK_NAME,T_REFED.REFED_CONS_NAME AS PK_NAME,0 AS DEFERRABILITY";
        sql = String.valueOf(sql) + " FROM (SELECT T_REF_CONS.FINDEXID AS REFED_IND_ID,T_REF_INDS_OBJ.NAME AS REF_CONS_NAME, SF_GET_INDEX_KEY_SEQ(T_REF_INDS.KEYNUM, T_REF_INDS.KEYINFO, T_REF_COL.COLID) AS REF_KEYNO,T_REF_COL.NAME AS REF_COL_NAME, T_REF_CONS.FACTION AS FACTION FROM SYS.SYSCONS AS T_REF_CONS,(SELECT NAME,ID FROM SYS.SYSOBJECTS WHERE SUBTYPE$='UTAB' AND NAME = '" + ftab2 + "' AND SCHID = (SELECT ID FROM " + "SYS.SYSOBJECTS WHERE TYPE$='SCH' AND NAME = '" + fsch2 + "')) AS T_REF_TAB, " + "SYS.SYSINDEXES AS T_REF_INDS, (SELECT ID, PID, NAME FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REF_INDS_OBJ, " + "SYS.SYSCOLUMNS AS T_REF_COL WHERE " + "T_REF_TAB.ID = T_REF_CONS.TABLEID AND T_REF_CONS.TYPE$='F' AND T_REF_TAB.ID = T_REF_INDS_OBJ.PID AND T_REF_TAB.ID = T_REF_COL.ID " + "AND T_REF_CONS.INDEXID = T_REF_INDS_OBJ.ID AND T_REF_INDS.ID = T_REF_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REF_INDS.KEYNUM, T_REF_INDS.KEYINFO, T_REF_COL.COLID)=1) AS T_REF, ";
        sql = String.valueOf(sql) + "(SELECT T_REFED_INDS.ID AS REFED_IND_ID,T_REFED_INDS_OBJ.NAME AS REFED_CONS_NAME, SF_GET_INDEX_KEY_SEQ(T_REFED_INDS.KEYNUM, T_REFED_INDS.KEYINFO, T_REFED_COL.COLID) AS REFED_KEYNO,T_REFED_COL.NAME AS REFED_COL_NAME FROM SYS.SYSCONS AS T_REFED_CONS, (SELECT NAME, ID FROM SYS.SYSOBJECTS WHERE SUBTYPE$='UTAB' AND NAME = '" + ptab2 + "' AND SCHID = (SELECT ID FROM " + "SYS.SYSOBJECTS WHERE TYPE$='SCH' AND NAME = '" + psch2 + "' )) AS T_REFED_TAB, " + "SYS.SYSINDEXES AS T_REFED_INDS, (SELECT ID, PID, NAME FROM " + "SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS T_REFED_INDS_OBJ," + "SYS.SYSCOLUMNS AS T_REFED_COL WHERE " + "T_REFED_TAB.ID = T_REFED_CONS.TABLEID AND T_REFED_CONS.TYPE$='P' AND T_REFED_TAB.ID = T_REFED_INDS_OBJ.PID AND T_REFED_TAB.ID = T_REFED_COL.ID " + "AND T_REFED_CONS.INDEXID = T_REFED_INDS_OBJ.ID AND T_REFED_INDS.ID = T_REFED_INDS_OBJ.ID AND SF_COL_IS_IDX_KEY(T_REFED_INDS.KEYNUM, T_REFED_INDS.KEYINFO, T_REFED_COL.COLID)=1) AS T_REFED";
        sql = String.valueOf(sql) + " WHERE T_REF.REFED_IND_ID = T_REFED.REFED_IND_ID AND T_REF.REF_KEYNO = T_REFED.REFED_KEYNO ORDER BY FKTABLE_CAT ASC,FKTABLE_SCHEM ASC,FKTABLE_NAME ASC,KEY_SEQ ASC";
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getTypeInfo() throws SQLException {
        String sql = "select TYPEINFO.TYPE_NAME, TYPEINFO.DTYPE, TYPEINFO.PRECISION, TYPEINFO.LITERAL_PREFIX, TYPEINFO.LITERAL_SUFFIX, TYPEINFO.CREATE_PARAMS, TYPEINFO.NULLABLE, TYPEINFO.CASE_SENSITIVE, TYPEINFO.SEARCHABLE,TYPEINFO.UNSIGNED_ATTRIBUTE, TYPEINFO.FIXED_PREC_SCALE, TYPEINFO.AUTO_INCREMENT, TYPEINFO.LOCAL_TYPE_NAME, TYPEINFO.MINIMUM_SCALE, TYPEINFO.MAXIMUM_SCALE, TYPEINFO.SQL_DATA_TYPE, TYPEINFO.SQL_DATETIME_SUB, TYPEINFO.NUM_PREC_RADIX from (";
        sql = String.valueOf(sql) + "SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT TYPE_NAME AS TYPE_NAME,";
        sql = String.valueOf(sql) + " CASE DATA_TYPE WHEN 101 THEN 2000 WHEN 102 THEN 2000 WHEN 103 THEN 2000 WHEN 104 THEN 2000 WHEN 105 THEN 2000 WHEN 106 THEN 2000 WHEN 107 THEN 2000 WHEN 108 THEN 2000 WHEN 109 THEN 2000 WHEN 110 THEN 2000 WHEN 111 THEN 2000 WHEN 112 THEN 2000 WHEN 113 THEN 2000 ELSE DATA_TYPE END AS DTYPE,";
        sql = String.valueOf(sql) + " COLUMN_SIZE AS \"PRECISION\",LITERAL_PREFIX AS LITERAL_PREFIX,LITERAL_SUFFIX AS LITERAL_SUFFIX,CREATE_PARAMS AS CREATE_PARAMS,NULLABLE$ AS NULLABLE,CASE_SENSITIVE AS CASE_SENSITIVE,SEARCHABLE AS SEARCHABLE,UNSIGNED_ATTRIBUTE AS UNSIGNED_ATTRIBUTE,FIXED_PREC_SCALE AS FIXED_PREC_SCALE,AUTO_UNIQUE_VALUE AS AUTO_INCREMENT,LOCAL_TYPE_NAME AS LOCAL_TYPE_NAME,MINIMUM_SCALE AS MINIMUM_SCALE,MAXIMUM_SCALE AS MAXIMUM_SCALE,NULL AS SQL_DATA_TYPE,NULL AS SQL_DATETIME_SUB,NUM_PREC_RADIX AS NUM_PREC_RADIX";
        sql = String.valueOf(sql) + " FROM SYS.SYSTYPEINFOS WHERE (TYPE_VERSION = 'O3' OR TYPE_VERSION = 'J3') AND TYPE_NAME <> 'double precision' AND TYPE_NAME <> 'image' AND TYPE_NAME <> 'text' AND TYPE_NAME <> 'money'";
        sql = String.valueOf(sql) + " ORDER BY DTYPE) TYPEINFO;";
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (schema != null && schema.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (table != null && table.equals("")) {
            return null;
        }
        String schemaname = schema == null ? "%" : StringUtil.getEscStringName(schema);
        String tablename = table == null ? "%" : StringUtil.getEscStringName(table);
        String schemaClause = this.makeSchemaClause(schemaname);
        String tableClause = this.makeTableClause_utab(tablename);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT /*+ MAX_OPT_N_TABLES(5) */ DISTINCT NULL");
        sql.append(" AS TABLE_CAT,USERS.NAME AS TABLE_SCHEM,TAB.NAME AS TABLE_NAME, ");
        sql.append("CASE INDS.ISUNIQUE WHEN 'Y' THEN 0 ELSE 1 END AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, ");
        sql.append("OBJ_INDS.NAME AS INDEX_NAME, ");
        sql.append("CASE INDS.XTYPE & 0x01 WHEN 0 THEN 1 ");
        sql.append("ELSE 3 END AS \"TYPE\", ");
        sql.append("SF_GET_INDEX_KEY_SEQ(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID) AS ORDINAL_POSITION, ");
        sql.append("COLS.NAME AS COLUMN_NAME, ");
        sql.append("SF_GET_INDEX_KEY_ORDER(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID) AS ASC_OR_DESC, ");
        sql.append("0 AS CARDINALITY, 0 AS PAGES, NULL AS FILTER_CONDITION ");
        sql.append(" FROM ");
        sql.append(schemaClause);
        sql.append(" AS USERS, ");
        sql.append(tableClause);
        sql.append(" AS TAB, ");
        sql.append("(SELECT ID, PID, NAME FROM SYS.SYSOBJECTS WHERE SUBTYPE$='INDEX') AS OBJ_INDS,");
        sql.append("SYS.SYSINDEXES AS INDS,");
        sql.append("SYS.SYSCOLUMNS AS COLS ");
        sql.append("WHERE TAB.ID=COLS.ID AND TAB.ID=OBJ_INDS.PID ");
        sql.append("AND INDS.ID=OBJ_INDS.ID AND TAB.SCHID = USERS.ID AND ");
        sql.append("SF_COL_IS_IDX_KEY(INDS.KEYNUM, INDS.KEYINFO, COLS.COLID)=1");
        if (unique) {
            sql.append(" AND INDS.ISUNIQUE = 'Y' ORDER BY NON_UNIQUE ASC,TYPE ASC,INDEX_NAME ASC,ORDINAL_POSITION ASC;");
        } else {
            sql.append(" ORDER BY NON_UNIQUE ASC,TYPE ASC,INDEX_NAME ASC,ORDINAL_POSITION ASC;");
        }
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003 || type == 1004;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return true;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        DmdbColumn[] fields = new DmdbColumn[7];
        fields[0] = new DmdbColumn(this.connection);
        fields[0].getDesc().setName("TYPE_CAT");
        fields[0].getDesc().setDType(2);
        fields[0].getDesc().setPrec(128);
        fields[0].getDesc().setScale(0);
        fields[0].getDesc().setNullable(true);
        fields[1] = new DmdbColumn(this.connection);
        fields[1].getDesc().setName("TYPE_SCHEM");
        fields[1].getDesc().setDType(2);
        fields[1].getDesc().setPrec(128);
        fields[1].getDesc().setScale(0);
        fields[1].getDesc().setNullable(true);
        fields[2] = new DmdbColumn(this.connection);
        fields[2].getDesc().setName("TYPE_NAME");
        fields[2].getDesc().setDType(2);
        fields[2].getDesc().setPrec(128);
        fields[2].getDesc().setScale(0);
        fields[2].getDesc().setNullable(false);
        fields[3] = new DmdbColumn(this.connection);
        fields[3].getDesc().setName("CLASS_NAME");
        fields[3].getDesc().setDType(2);
        fields[3].getDesc().setPrec(128);
        fields[3].getDesc().setScale(0);
        fields[3].getDesc().setNullable(false);
        fields[4] = new DmdbColumn(this.connection);
        fields[4].getDesc().setName("DATA_TYPE");
        fields[4].getDesc().setDType(7);
        fields[4].getDesc().setPrec(4);
        fields[4].getDesc().setScale(0);
        fields[4].getDesc().setNullable(false);
        fields[5] = new DmdbColumn(this.connection);
        fields[5].getDesc().setName("REMARKS");
        fields[5].getDesc().setDType(2);
        fields[5].getDesc().setPrec(1024);
        fields[5].getDesc().setScale(0);
        fields[5].getDesc().setNullable(false);
        fields[6] = new DmdbColumn(this.connection);
        fields[6].getDesc().setName("BASE_TYPE");
        fields[6].getDesc().setDType(6);
        fields[6].getDesc().setPrec(2);
        fields[6].getDesc().setScale(0);
        fields[6].getDesc().setNullable(false);
        DmdbInfo dmInfo = new DmdbInfo();
        dmInfo.setColumnsInfo(fields);
        String s1 = catalog;
        String s2 = schemaPattern;
        String s3 = typeNamePattern;
        if (s1 == null) {
            s1 = this.connection.getCatalog();
        }
        if (s2 == null) {
            s2 = "%";
        }
        if (s3 == null) {
            s3 = "%";
        }
        dmInfo.setRowCount(0L);
        DmdbResultSet_bs rs = new DmdbResultSet_bs(dmInfo, false);
        return rs;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        DmdbColumn[] field = new DmdbColumn[6];
        field[0] = new DmdbColumn(this.connection);
        field[0].getDesc().setName("TYPE_CAT");
        field[0].getDesc().setDType(2);
        field[0].getDesc().setPrec(128);
        field[0].getDesc().setScale(0);
        field[0].getDesc().setNullable(true);
        field[1] = new DmdbColumn(this.connection);
        field[1].getDesc().setName("TYPE_SCHEM");
        field[1].getDesc().setDType(2);
        field[1].getDesc().setPrec(128);
        field[1].getDesc().setScale(0);
        field[1].getDesc().setNullable(true);
        field[2] = new DmdbColumn(this.connection);
        field[2].getDesc().setName("TYPE_NAME");
        field[2].getDesc().setDType(2);
        field[2].getDesc().setPrec(128);
        field[2].getDesc().setScale(0);
        field[2].getDesc().setNullable(false);
        field[3] = new DmdbColumn(this.connection);
        field[3].getDesc().setName("SUPERTYPE_CAT");
        field[3].getDesc().setDType(2);
        field[3].getDesc().setPrec(128);
        field[3].getDesc().setScale(0);
        field[3].getDesc().setNullable(true);
        field[4] = new DmdbColumn(this.connection);
        field[4].getDesc().setName("SUPERTYPE_SCHEM");
        field[4].getDesc().setDType(2);
        field[4].getDesc().setPrec(128);
        field[4].getDesc().setScale(0);
        field[4].getDesc().setNullable(true);
        field[5] = new DmdbColumn(this.connection);
        field[5].getDesc().setName("SUPERTYPE_NAME");
        field[5].getDesc().setDType(2);
        field[5].getDesc().setPrec(128);
        field[5].getDesc().setScale(0);
        field[5].getDesc().setNullable(false);
        DmdbInfo dmInfo = new DmdbInfo();
        dmInfo.setColumnsInfo(field);
        String s1 = catalog;
        String s2 = schemaPattern;
        String s3 = typeNamePattern;
        if (s1 == null) {
            s1 = this.connection.getCatalog();
        }
        if (s2 == null) {
            s2 = "%";
        }
        if (s3 == null) {
            s3 = "%";
        }
        dmInfo.setRowCount(0L);
        DmdbResultSet_bs rs = new DmdbResultSet_bs(dmInfo, false);
        return rs;
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        DmdbColumn[] field = new DmdbColumn[4];
        field[0] = new DmdbColumn(this.connection);
        field[0].getDesc().setName("TABLE_CAT");
        field[0].getDesc().setDType(2);
        field[0].getDesc().setPrec(128);
        field[0].getDesc().setScale(0);
        field[0].getDesc().setNullable(true);
        field[1] = new DmdbColumn(this.connection);
        field[1].getDesc().setName("TABLE_SCHEM");
        field[1].getDesc().setDType(2);
        field[1].getDesc().setPrec(128);
        field[1].getDesc().setScale(0);
        field[1].getDesc().setNullable(true);
        field[2] = new DmdbColumn(this.connection);
        field[2].getDesc().setName("TABLE_NAME");
        field[2].getDesc().setDType(2);
        field[2].getDesc().setPrec(128);
        field[2].getDesc().setScale(0);
        field[2].getDesc().setNullable(false);
        field[3] = new DmdbColumn(this.connection);
        field[3].getDesc().setName("SUPERTABLE_NAME");
        field[3].getDesc().setDType(2);
        field[3].getDesc().setPrec(128);
        field[3].getDesc().setScale(0);
        field[3].getDesc().setNullable(false);
        DmdbInfo dmInfo = new DmdbInfo();
        dmInfo.setColumnsInfo(field);
        String s1 = catalog;
        String s2 = schemaPattern;
        String s3 = tableNamePattern;
        if (s1 == null) {
            s1 = this.connection.getCatalog();
        }
        if (s2 == null) {
            s2 = "%";
        }
        if (s3 == null) {
            s3 = "%";
        }
        dmInfo.setRowCount(0L);
        DmdbResultSet_bs rs = new DmdbResultSet_bs(dmInfo, false);
        return rs;
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        DmdbColumn[] field = new DmdbColumn[21];
        field[0] = new DmdbColumn(this.connection);
        field[0].getDesc().setName("TYPE_CAT");
        field[0].getDesc().setDType(2);
        field[0].getDesc().setPrec(128);
        field[0].getDesc().setScale(0);
        field[0].getDesc().setNullable(true);
        field[1] = new DmdbColumn(this.connection);
        field[1].getDesc().setName("TYPE_SCHEM");
        field[1].getDesc().setDType(2);
        field[1].getDesc().setPrec(128);
        field[1].getDesc().setScale(0);
        field[1].getDesc().setNullable(true);
        field[2] = new DmdbColumn(this.connection);
        field[2].getDesc().setName("TYPE_NAME");
        field[2].getDesc().setDType(2);
        field[2].getDesc().setPrec(128);
        field[2].getDesc().setScale(0);
        field[2].getDesc().setNullable(false);
        field[3] = new DmdbColumn(this.connection);
        field[3].getDesc().setName("ATTR_NAME");
        field[3].getDesc().setDType(2);
        field[3].getDesc().setPrec(128);
        field[3].getDesc().setScale(0);
        field[3].getDesc().setNullable(false);
        field[4] = new DmdbColumn(this.connection);
        field[4].getDesc().setName("DATA_TYPE");
        field[4].getDesc().setDType(7);
        field[4].getDesc().setPrec(4);
        field[4].getDesc().setScale(0);
        field[4].getDesc().setNullable(false);
        field[5] = new DmdbColumn(this.connection);
        field[5].getDesc().setName("ATTR_TYPE_NAME");
        field[5].getDesc().setDType(2);
        field[5].getDesc().setPrec(128);
        field[5].getDesc().setScale(0);
        field[5].getDesc().setNullable(false);
        field[6] = new DmdbColumn(this.connection);
        field[6].getDesc().setName("ATTR_SIZE");
        field[6].getDesc().setDType(7);
        field[6].getDesc().setPrec(4);
        field[6].getDesc().setScale(0);
        field[6].getDesc().setNullable(false);
        field[7] = new DmdbColumn(this.connection);
        field[7].getDesc().setName("DECIMAL_DIGITS");
        field[7].getDesc().setDType(7);
        field[7].getDesc().setPrec(4);
        field[7].getDesc().setScale(0);
        field[7].getDesc().setNullable(false);
        field[8] = new DmdbColumn(this.connection);
        field[8].getDesc().setName("NUM_PREC_RADIX");
        field[8].getDesc().setDType(7);
        field[8].getDesc().setPrec(4);
        field[8].getDesc().setScale(0);
        field[8].getDesc().setNullable(false);
        field[9] = new DmdbColumn(this.connection);
        field[9].getDesc().setName("NULLABLE");
        field[9].getDesc().setDType(7);
        field[9].getDesc().setPrec(4);
        field[9].getDesc().setScale(0);
        field[9].getDesc().setNullable(false);
        field[10] = new DmdbColumn(this.connection);
        field[10].getDesc().setName("REMARKS");
        field[10].getDesc().setDType(2);
        field[10].getDesc().setPrec(128);
        field[10].getDesc().setScale(0);
        field[10].getDesc().setNullable(false);
        field[11] = new DmdbColumn(this.connection);
        field[11].getDesc().setName("ATTR_DEF");
        field[11].getDesc().setDType(2);
        field[11].getDesc().setPrec(128);
        field[11].getDesc().setScale(0);
        field[11].getDesc().setNullable(true);
        field[12] = new DmdbColumn(this.connection);
        field[12].getDesc().setName("SQL_DATA_TYPE");
        field[12].getDesc().setDType(7);
        field[12].getDesc().setPrec(4);
        field[12].getDesc().setScale(0);
        field[12].getDesc().setNullable(false);
        field[13] = new DmdbColumn(this.connection);
        field[13].getDesc().setName("SQL_DATETIME_SUB");
        field[13].getDesc().setDType(7);
        field[13].getDesc().setPrec(4);
        field[13].getDesc().setScale(0);
        field[13].getDesc().setNullable(false);
        field[14] = new DmdbColumn(this.connection);
        field[14].getDesc().setName("CHAR_OCTET_LENGTH");
        field[14].getDesc().setDType(7);
        field[14].getDesc().setPrec(4);
        field[14].getDesc().setScale(0);
        field[14].getDesc().setNullable(false);
        field[15] = new DmdbColumn(this.connection);
        field[15].getDesc().setName("ORDINAL_POSITION");
        field[15].getDesc().setDType(7);
        field[15].getDesc().setPrec(4);
        field[15].getDesc().setScale(0);
        field[15].getDesc().setNullable(false);
        field[16] = new DmdbColumn(this.connection);
        field[16].getDesc().setName("IS_NULLABLE");
        field[16].getDesc().setDType(2);
        field[16].getDesc().setPrec(128);
        field[16].getDesc().setScale(0);
        field[16].getDesc().setNullable(false);
        field[17] = new DmdbColumn(this.connection);
        field[17].getDesc().setName("SCOPE_CATALOG");
        field[17].getDesc().setDType(2);
        field[17].getDesc().setPrec(128);
        field[17].getDesc().setScale(0);
        field[17].getDesc().setNullable(false);
        field[18] = new DmdbColumn(this.connection);
        field[18].getDesc().setName("SCOPE_SCHEMA");
        field[18].getDesc().setDType(2);
        field[18].getDesc().setPrec(128);
        field[18].getDesc().setScale(0);
        field[18].getDesc().setNullable(false);
        field[19] = new DmdbColumn(this.connection);
        field[19].getDesc().setName("SCOPE_TABLE");
        field[19].getDesc().setDType(2);
        field[19].getDesc().setPrec(128);
        field[19].getDesc().setScale(0);
        field[19].getDesc().setNullable(false);
        field[20] = new DmdbColumn(this.connection);
        field[20].getDesc().setName("SOURCE_DATA_TYPE");
        field[20].getDesc().setDType(6);
        field[20].getDesc().setPrec(2);
        field[20].getDesc().setScale(0);
        field[20].getDesc().setNullable(false);
        DmdbInfo dmInfo = new DmdbInfo();
        dmInfo.setColumnsInfo(field);
        dmInfo.setRowCount(0L);
        DmdbResultSet_bs rs = new DmdbResultSet_bs(dmInfo, false);
        return rs;
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 2 || holdability == 1;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        String[] versions = this.getDatabaseProductVersion().split("\\.");
        return Integer.parseInt(versions[0]);
    }

    public int getDatabaseMinorVersion() throws SQLException {
        String[] versions = this.getDatabaseProductVersion().split("\\.");
        return Integer.parseInt(versions[1]);
    }

    public int getJDBCMajorVersion() throws SQLException {
        return DmdbType.JDBC_VERSION;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        return this.XOpen;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }

    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (schemaPattern != null && schemaPattern.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        String catalog2 = catalog == null ? this.connection.getCatalog() : StringUtil.getEscStringName(catalog.trim());
        String schemaname = schemaPattern == null ? "%" : StringUtil.getEscStringName(schemaPattern);
        String sql = "";
        sql = catalog2 == null ? "SELECT DISTINCT NAME AS TABLE_SCHEM, NULL AS TABLE_CATALOG FROM " : "SELECT DISTINCT NAME AS TABLE_SCHEM, '" + catalog2 + "' AS TABLE_CATALOG FROM ";
        sql = this.getEscape(schemaname) ? (!schemaname.equalsIgnoreCase("%") ? String.valueOf(sql) + "SYS.SYSOBJECTS USERS WHERE TYPE$='SCH' AND NAME LIKE '" + schemaname + "'" + this.m_esp : String.valueOf(sql) + "SYS.SYSOBJECTS USERS WHERE TYPE$='SCH' ") : String.valueOf(sql) + "SYS.SYSOBJECTS USERS WHERE TYPE$='SCH' AND NAME = '" + schemaname + "'";
        sql = String.valueOf(sql) + " ORDER BY TABLE_SCHEM ASC;";
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        if (this.connection.isCompatibleOracle() && StringUtil.isNotEmpty(catalog)) {
            try {
                return this.getPkgProcedures(schemaPattern, catalog, functionNamePattern, 2);
            }
            catch (SQLException sQLException) {}
        }
        if (schemaPattern != null && schemaPattern.equals("")) {
            throw new SQLException("There is not a procedure without a schema!");
        }
        if (functionNamePattern != null && functionNamePattern.equals("")) {
            return null;
        }
        String catalog2 = catalog == null ? this.connection.getCatalog() : StringUtil.getEscStringName(catalog.trim());
        String schemaname = schemaPattern == null ? "%" : StringUtil.getEscStringName(schemaPattern);
        String funcname = functionNamePattern == null ? "%" : StringUtil.getEscStringName(functionNamePattern);
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT DISTINCT ");
        if (catalog2 == null) {
            sql.append("NULL");
        } else {
            sql.append("'" + catalog2 + "'");
        }
        sql.append(" AS FUNCTION_CAT, SCHEMAS.NAME AS FUNCTION_SCHEM, FUNCS.NAME AS FUNCTION_NAME, NULL AS REMARKS, 2 AS FUNCTION_TYPE, FUNCS.NAME AS SPECIFIC_NAME");
        sql.append(" FROM ");
        sql.append("(SELECT * FROM SYS.SYSOBJECTS WHERE SUBTYPE$='PROC' AND INFO1&0x01=0");
        String funClause = this.makeClause_objWithoutPrec(funcname);
        if (funClause != null) {
            sql.append(" AND NAME ");
            sql.append(funClause);
        }
        sql.append(")FUNCS, ");
        String schemaClause = this.makeSchemaClause(schemaname);
        sql.append(schemaClause);
        sql.append("SCHEMAS");
        sql.append(" ORDER BY FUNCTION_SCHEM ASC,FUNCTION_NAME ASC;");
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }

    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        if (this.connection.isCompatibleOracle() && StringUtil.isNotEmpty(catalog)) {
            try {
                return this.getPkgProcedureColumns(schemaPattern, catalog, functionNamePattern, columnNamePattern, 2);
            }
            catch (SQLException sQLException) {}
        }
        if (schemaPattern != null && schemaPattern.equals("")) {
            throw new SQLException("There is not a procedure without a schema!");
        }
        if (functionNamePattern != null && functionNamePattern.equals("") || columnNamePattern != null && columnNamePattern.equals("")) {
            return null;
        }
        String catalog2 = catalog == null ? this.connection.getCatalog() : StringUtil.getEscStringName(catalog.trim());
        String schemaname = schemaPattern == null ? "%" : StringUtil.getEscStringName(schemaPattern);
        String funcname = functionNamePattern == null ? "%" : StringUtil.getEscStringName(functionNamePattern);
        String colname = columnNamePattern == null ? "%" : StringUtil.getEscStringName(columnNamePattern);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT ");
        if (catalog2 == null) {
            sql.append("NULL");
        } else {
            sql.append("'" + catalog2 + "'");
        }
        sql.append(" AS FUNCTION_CAT,");
        sql.append("USERS.NAME AS FUNCTION_SCHEM,");
        sql.append("FUNCS.NAME AS FUNCTION_NAME,");
        if (this.connection.isCompatibleOracle()) {
            sql.append("CASE ARG.INFO1 WHEN 3 THEN NULL ELSE ARG.NAME END AS COLUMN_NAME, ");
        } else {
            sql.append("ARG.NAME AS COLUMN_NAME,");
        }
        sql.append("CASE ARG.INFO1 WHEN 0 THEN 1 WHEN 1 THEN 3 WHEN 2 THEN 2 WHEN 3 THEN 4 END AS COLUMN_TYPE,");
        sql.append(this.makeDataTypeClause("ARG.TYPE$", "ARG.SCALE"));
        sql.append("AS DATA_TYPE,");
        sql.append(this.makeDataTypeNameClause("ARG.TYPE$"));
        sql.append("AS TYPE_NAME,");
        sql.append("CASE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_COLUMN_SIZE(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END AS \"PRECISION\",");
        sql.append("CASE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_BUFFER_LEN(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT), CAST (ARG.SCALE AS INT)) END AS LENGTH,");
        sql.append("CASE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_DECIMAL_DIGITS(ARG.TYPE$, CAST (ARG.SCALE AS INT)) END AS SCALE,");
        sql.append("10 AS RADIX,");
        sql.append("1 AS NULLABLE,");
        sql.append("NULL AS REMARKS, ");
        sql.append("CASE SF_GET_OCT_LENGTH(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT)) WHEN -2 THEN NULL ");
        sql.append("ELSE SF_GET_OCT_LENGTH(ARG.TYPE$, CAST (ARG.LENGTH$ AS INT)) END AS CHAR_OCTET_LENGTH, ");
        sql.append("CASE ARG.INFO1 WHEN 3 THEN 0 ELSE ARG.COLID + 1 END AS ORDINAL_POSITION, ");
        sql.append("CASE ARG.NULLABLE$ WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE, ");
        sql.append("FUNCS.NAME AS SPECIFIC_NAME");
        sql.append(" FROM ");
        String schemaClause = this.makeSchemaClause(schemaname);
        sql.append(schemaClause);
        sql.append(" AS USERS, ");
        String funClause = this.makeFuncClause(funcname);
        sql.append(funClause);
        sql.append(" AS FUNCS, ");
        sql.append("SYS.SYSCOLUMNS ARG ");
        sql.append("WHERE ");
        String argClause = this.makeClause_objWithoutPrec(colname);
        if (argClause != null) {
            sql.append("ARG.NAME ");
            sql.append(argClause);
            sql.append(" AND ");
        }
        sql.append(" USERS.ID = FUNCS.SCHID AND FUNCS.ID = ARG.ID");
        sql.append(" ORDER BY FUNCTION_SCHEM ASC,FUNCTION_NAME ASC;");
        return DmJdbcUtil.executeQuery(this.connection, sql.toString());
    }
}

