/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.log;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.log.ILogger;
import dm.jdbc.log.LogWriter;
import dm.jdbc.util.DmJdbcUtil;
import dm.jdbc.util.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Logger
implements ILogger {
    public Logger(String name) {
    }

    public boolean isDebugEnabled() {
        return DmSvcConf.logLevel >= 5;
    }

    public boolean isErrorEnabled() {
        return DmSvcConf.logLevel >= 1;
    }

    public boolean isInfoEnabled() {
        return DmSvcConf.logLevel >= 4;
    }

    public boolean isWarnEnabled() {
        return DmSvcConf.logLevel >= 2;
    }

    public boolean isSqlEnabled() {
        return DmSvcConf.logLevel >= 3;
    }

    public void debug(Object message) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(DmJdbcUtil.formatTime("[DEBUG - ", "] ")) + message.toString());
            }
        }
        catch (Exception exception) {}
    }

    public void debug(Object message, Throwable t) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(DmJdbcUtil.formatTime("[DEBUG - ", "] ")) + message.toString());
                this.printStackTrace(t);
            }
        }
        catch (Exception exception) {}
    }

    public void info(Object message) {
        try {
            if (this.isInfoEnabled()) {
                this.println(String.valueOf(DmJdbcUtil.formatTime("[INFO  - ", "] ")) + message.toString());
            }
        }
        catch (Exception exception) {}
    }

    public void info(Object source, String method, String info) {
        try {
            if (this.isInfoEnabled()) {
                this.println(String.valueOf(DmJdbcUtil.formatTime("[INFO  - ", "] ")) + Logger.formatTrace(source, method, info));
            }
        }
        catch (Exception exception) {}
    }

    public void info(Object source, String method, Object ... params) {
        try {
            if (this.isInfoEnabled()) {
                this.println(String.valueOf(DmJdbcUtil.formatTime("[INFO  - ", "] ")) + Logger.formatTrace(source, method, params));
            }
        }
        catch (Exception exception) {}
    }

    public void debug(Object source, String method, Object ... params) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(DmJdbcUtil.formatTime("[DEBUG - ", "] ")) + Logger.formatTrace(source, method, params));
            }
        }
        catch (Exception exception) {}
    }

    public void debug(Object source, String method, String info) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(DmJdbcUtil.formatTime("[DEBUG - ", "] ")) + Logger.formatTrace(source, method, info));
            }
        }
        catch (Exception exception) {}
    }

    public void info(Object message, Throwable t) {
        try {
            if (this.isInfoEnabled()) {
                this.println(String.valueOf(DmJdbcUtil.formatTime("[INFO  - ", "] ")) + message.toString());
                this.printStackTrace(t);
            }
        }
        catch (Exception exception) {}
    }

    public void sql(Object message) {
        try {
            if (this.isSqlEnabled()) {
                this.println(String.valueOf(DmJdbcUtil.formatTime("[INFO  - ", "] ")) + message.toString());
            }
        }
        catch (Exception exception) {}
    }

    public void warn(Object message) {
        try {
            if (this.isWarnEnabled()) {
                this.println(String.valueOf(DmJdbcUtil.formatTime("[WARN  - ", "] ")) + message.toString());
            }
        }
        catch (Exception exception) {}
    }

    public void warn(Object message, Throwable t) {
        try {
            if (this.isWarnEnabled()) {
                this.println(String.valueOf(DmJdbcUtil.formatTime("[WARN  - ", "] ")) + message.toString());
                this.printStackTrace(t);
            }
        }
        catch (Exception exception) {}
    }

    public void error(Object message) {
        try {
            if (this.isErrorEnabled()) {
                this.println(String.valueOf(DmJdbcUtil.formatTime("[ERROR - ", "] ")) + message.toString());
            }
        }
        catch (Exception exception) {}
    }

    public void error(Object message, Throwable t) {
        try {
            if (this.isErrorEnabled()) {
                this.println(String.valueOf(DmJdbcUtil.formatTime("[ERROR - ", "] ")) + message.toString());
                this.printStackTrace(t);
            }
        }
        catch (Exception exception) {}
    }

    private void println(String msg) {
        LogWriter.getInstance().writeLine(StringUtil.trimToEmpty(msg));
    }

    private void printStackTrace(Throwable t) {
        if (t != null) {
            StringWriter out = new StringWriter(256);
            t.printStackTrace(new PrintWriter(out));
            LogWriter.getInstance().write(out.toString());
        }
    }

    private static String formatSource(Object source) {
        return String.valueOf(source.getClass().getSimpleName()) + "@" + Integer.toHexString(source.hashCode());
    }

    private static String formatTrace(Object source, String method, String info) {
        StringBuilder str = new StringBuilder();
        if (source != null) {
            str.append("{ " + Logger.formatSource(source) + " } ");
        }
        str.append(method).append("();  ");
        str.append(info);
        return str.toString();
    }

    private static String formatTrace(Object source, String method, Object ... params) {
        int i;
        StringBuilder str = new StringBuilder(128);
        if (source != null) {
            str.append("{ " + Logger.formatSource(source) + " } ");
        }
        str.append(String.valueOf(method) + "(");
        int paramStartIndex = 0;
        if (params != null && params.length > paramStartIndex) {
            i = paramStartIndex;
            while (i < params.length) {
                if (i != paramStartIndex) {
                    str.append(", ");
                }
                str.append(params[i].getClass().getSimpleName());
                ++i;
            }
        }
        str.append(");  ");
        if (params != null && params.length > paramStartIndex) {
            str.append("[PARAMS]: ");
            i = paramStartIndex;
            while (i < params.length) {
                if (i != 0) {
                    str.append(", ");
                }
                if (params[i] instanceof String) {
                    str.append("\"").append(params[i]).append("\"");
                } else {
                    str.append(params[i]);
                }
                ++i;
            }
            str.append("; ");
        }
        return str.toString();
    }
}

