/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dataConvertion.accessor.BaseAccessor;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.DmSvcConf;
import dm.sql.ARRAY;
import dm.sql.TypeData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DmdbArrayDataResultSet
implements ResultSet {
    private ARRAY m_array = null;
    private long m_startIndex = 1L;
    private int m_rowCount = 0;
    private int m_curRowNum = (int)(this.m_startIndex - 1L);
    private boolean m_isClosed = false;
    private boolean m_wasPrivColNull = false;
    private int m_direction = 1000;
    private int m_type = 1003;
    private int m_conCurrency = 1007;
    private int m_fetchSize = -1;

    DmdbArrayDataResultSet(ARRAY arr) {
        this.m_array = arr;
        this.m_rowCount = this.m_array.m_arrData.length;
        this.m_startIndex = 1L;
        this.m_curRowNum = (int)(this.m_startIndex - 1L);
    }

    public DmdbArrayDataResultSet(ARRAY arr, long index, int count) {
        this(arr);
        this.m_startIndex = index;
        this.m_rowCount = this.m_rowCount < count ? this.m_rowCount : count;
        this.m_curRowNum = (int)(this.m_startIndex - 1L);
    }

    private void checkClose() throws SQLException {
        if (this.m_isClosed) {
            DBError.throwSQLException(6034);
        }
    }

    private void checkCurrentRow() throws SQLException {
        this.checkClose();
        if ((long)this.m_curRowNum < this.m_startIndex && this.m_curRowNum > this.m_rowCount) {
            throw new SQLException(DmSvcConf.res.getString("error.cursorNotInResultSet"));
        }
    }

    private boolean checkIsNull(TypeData typeData) {
        this.m_wasPrivColNull = typeData.m_dataBuf == null && typeData.m_dumyData == null;
        return this.m_wasPrivColNull;
    }

    private void release() {
        this.m_array = null;
        this.m_rowCount = 0;
        this.m_startIndex = 1L;
        this.m_isClosed = true;
    }

    private void checkUpdatable() throws SQLException {
        throw new SQLException(DmSvcConf.res.getString("error.arrayRsUptNotSpt"));
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClose();
        if (this.m_rowCount > this.m_curRowNum) {
            ++this.m_curRowNum;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        if (this.m_isClosed) {
            return;
        }
        this.release();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.m_wasPrivColNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof String) {
            return (String)typeData.m_dumyData;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return false;
        }
        if (typeData.m_dumyData instanceof Boolean) {
            return (Boolean)typeData.m_dumyData;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getBoolean();
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0;
        }
        if (typeData.m_dumyData instanceof Byte) {
            return (Byte)typeData.m_dumyData;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getByte();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0;
        }
        if (typeData.m_dumyData instanceof Short) {
            return (Short)typeData.m_dumyData;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getShort();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0;
        }
        if (typeData.m_dumyData instanceof Integer) {
            return (Integer)typeData.m_dumyData;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getInt();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0L;
        }
        if (typeData.m_dumyData instanceof Long) {
            return (Long)typeData.m_dumyData;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getLong();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0.0f;
        }
        if (typeData.m_dumyData instanceof Float) {
            return ((Float)typeData.m_dumyData).longValue();
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getFloat();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0.0;
        }
        if (typeData.m_dumyData instanceof Double) {
            return (Double)typeData.m_dumyData;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getDouble();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal bg = this.getBigDecimal(columnIndex);
        if (bg == null) {
            return null;
        }
        return bg.setScale(scale, 4);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Byte[]) {
            return (byte[])typeData.m_dumyData;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Date) {
            return (Date)typeData.m_dumyData;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getDate();
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Time) {
            return (Time)typeData.m_dumyData;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getTime();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Timestamp) {
            return (Timestamp)typeData.m_dumyData;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getTimestamp();
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getAsciiStream();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getUnicodeStream();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getBinaryStream();
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public String getCursorName() throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        return typeData.m_dumyData;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return 0;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof BigDecimal) {
            return (BigDecimal)typeData.m_dumyData;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, columnIndex);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getBigDecimal();
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.m_curRowNum + 1 <= 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.m_curRowNum + 1 > this.m_rowCount;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.m_curRowNum + 1 == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.m_curRowNum + 1 == this.m_rowCount;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClose();
        if (this.m_rowCount <= 0) {
            return;
        }
        this.m_curRowNum = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClose();
        if (this.m_rowCount <= 0) {
            return;
        }
        this.m_curRowNum = this.m_rowCount;
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClose();
        if (this.m_rowCount > 0) {
            this.m_curRowNum = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClose();
        if (this.m_rowCount > 0) {
            this.m_curRowNum = this.m_rowCount - 1;
            return true;
        }
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        return this.m_curRowNum + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClose();
        if (Math.abs(row) > this.m_rowCount || row == 0) {
            return false;
        }
        if (row < 0) {
            this.m_curRowNum = row + this.m_rowCount;
            return true;
        }
        this.m_curRowNum = row - 1;
        return true;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClose();
        if (rows == 0) {
            return !this.isBeforeFirst() && !this.isAfterLast();
        }
        int realRow = this.m_curRowNum + rows;
        if (realRow + 1 > this.m_rowCount || realRow + 1 < 1) {
            return false;
        }
        this.m_curRowNum = realRow;
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClose();
        int realRow = this.m_curRowNum - 1;
        if (realRow < 0 || realRow >= this.m_rowCount) {
            return false;
        }
        this.m_curRowNum = realRow;
        return true;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.m_direction = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.m_direction;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.m_fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.m_fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this.m_type;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.m_conCurrency;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkUpdatable();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkUpdatable();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkUpdatable();
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkUpdatable();
        return null;
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, i, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Blob) {
            return (Blob)typeData.m_dumyData;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, i);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getBlob();
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, i, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Clob) {
            return (Clob)typeData.m_dumyData;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, i);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getClob();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, i, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof ARRAY) {
            return (Array)typeData.m_dumyData;
        }
        BaseAccessor accessor = this.m_array.getDataAccessor(this.m_curRowNum, i);
        accessor.setOutValue(typeData.m_dataBuf);
        return accessor.getArray();
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date date = this.getDate(columnIndex);
        if (date == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTime(date);
        return new Date(cal.getTimeInMillis());
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time time = this.getTime(columnIndex);
        if (time == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(time.getTime());
        return new Time(cal.getTimeInMillis());
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(columnIndex);
        if (timestamp == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(timestamp.getTime());
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        this.updateRef(this.findColumn(columnName), x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnName), x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.updateArray(this.findColumn(columnName), x);
    }
}

