/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.compression;

import com.emc.vipr.transform.TransformConstants;
import com.emc.vipr.transform.TransformException;
import com.emc.vipr.transform.TransformFactory;
import com.emc.vipr.transform.compression.CompressionInputTransform;
import com.emc.vipr.transform.compression.CompressionOutputTransform;
import com.emc.vipr.transform.compression.DeflateInputTransform;
import com.emc.vipr.transform.compression.DeflateOutputTransform;
import com.emc.vipr.transform.compression.LZMAInputTransform;
import com.emc.vipr.transform.compression.LZMAOutputTransform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionTransformFactory
extends TransformFactory<CompressionOutputTransform, CompressionInputTransform> {
    private static final Logger logger = LoggerFactory.getLogger(CompressionTransformFactory.class);
    public TransformConstants.CompressionMode compressMode = TransformConstants.DEFAULT_COMPRESSION_MODE;
    public int compressionLevel = 5;
    public static LzmaProfile[] LZMA_COMPRESSION_PROFILE = new LzmaProfile[]{new LzmaProfile(16384, 5, 0), new LzmaProfile(65536, 64, 0), new LzmaProfile(524288, 128, 0), new LzmaProfile(0x100000, 128, 0), new LzmaProfile(0x800000, 128, 0), new LzmaProfile(0x1000000, 128, 0), new LzmaProfile(0x1800000, 192, 0), new LzmaProfile(0x2000000, 224, 1), new LzmaProfile(0x3000000, 256, 1), new LzmaProfile(0x4000000, 273, 1)};

    public CompressionTransformFactory() {
        this.setPriority(1000);
    }

    public TransformConstants.CompressionMode getCompressMode() {
        return this.compressMode;
    }

    public void setCompressMode(TransformConstants.CompressionMode compressMode) {
        this.compressMode = compressMode;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @Override
    public CompressionOutputTransform getOutputTransform(OutputStream streamToEncodeTo, Map<String, String> metadataToEncode) throws IOException {
        switch (this.compressMode) {
            case Deflate: {
                return new DeflateOutputTransform(streamToEncodeTo, metadataToEncode, this.compressionLevel);
            }
            case LZMA: {
                return new LZMAOutputTransform(streamToEncodeTo, metadataToEncode, this.compressionLevel);
            }
        }
        throw new IllegalArgumentException("Unsupported compression method " + (Object)((Object)this.compressMode));
    }

    @Override
    public CompressionOutputTransform getOutputTransform(InputStream streamToEncode, Map<String, String> metadataToEncode) throws IOException, TransformException {
        switch (this.compressMode) {
            case Deflate: {
                return new DeflateOutputTransform(streamToEncode, metadataToEncode, this.compressionLevel);
            }
            case LZMA: {
                return new LZMAOutputTransform(streamToEncode, metadataToEncode, this.compressionLevel);
            }
        }
        throw new IllegalArgumentException("Unsupported compression method " + (Object)((Object)this.compressMode));
    }

    @Override
    public CompressionInputTransform getInputTransform(String transformConfig, InputStream streamToDecode, Map<String, String> metadata) throws IOException {
        String[] transformTuple = this.splitTransformConfig(transformConfig);
        if (!"COMP".equals(transformTuple[0])) {
            throw new IllegalArgumentException("Unsupported transform class: " + transformTuple[0]);
        }
        String[] configParams = transformTuple[1].split("/");
        if (configParams.length < 1) {
            throw new IllegalArgumentException("Could not decode configuration: " + configParams);
        }
        TransformConstants.CompressionMode mode = TransformConstants.CompressionMode.valueOf(configParams[0]);
        switch (mode) {
            case Deflate: {
                return new DeflateInputTransform(streamToDecode, metadata);
            }
            case LZMA: {
                return new LZMAInputTransform(streamToDecode, metadata);
            }
        }
        throw new IllegalArgumentException("Unknown compression method " + (Object)((Object)mode));
    }

    @Override
    public String getTransformClass() {
        return "COMP";
    }

    public boolean canDecode(String transformClass, String config, Map<String, String> metadata) {
        if (config == null) {
            logger.warn("Configuration string null");
            return false;
        }
        String[] configParams = config.split("/");
        if (configParams.length < 1) {
            logger.warn("Could not decode config string {}", (Object)config);
            return false;
        }
        try {
            TransformConstants.CompressionMode.valueOf(configParams[0]);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Invalid compression mode {}", (Object)configParams[0]);
            return false;
        }
        return this.getTransformClass().equals(transformClass);
    }

    public static long memoryRequiredForLzma(int compressionLevel) {
        return CompressionTransformFactory.memoryRequiredForLzma(LZMA_COMPRESSION_PROFILE[compressionLevel]);
    }

    public static long memoryRequiredForLzma(LzmaProfile profile) {
        return (long)((double)profile.dictionarySize * 11.5);
    }

    public static class LzmaProfile {
        int dictionarySize;
        int fastBytes;
        int matchFinder;
        int lc;
        int lp;
        int pb;

        public LzmaProfile(int dictionarySize, int fastBytes, int matchFinder) {
            this(dictionarySize, fastBytes, matchFinder, 3, 0, 2);
        }

        public LzmaProfile(int dictionarySize, int fastBytes, int matchFinder, int lc, int lp, int pb) {
            this.dictionarySize = dictionarySize;
            this.fastBytes = fastBytes;
            this.matchFinder = matchFinder;
            this.lc = lc;
            this.lp = lp;
            this.pb = pb;
        }
    }
}

