/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.fireblocks.sdk.ApiClient;
import com.fireblocks.sdk.ConfigurationOptions;
import com.fireblocks.sdk.InstanceTimeWrapper;
import com.fireblocks.sdk.UserAgentUtil;
import com.fireblocks.sdk.api.ApiUserApi;
import com.fireblocks.sdk.api.AssetsApi;
import com.fireblocks.sdk.api.AuditLogsApi;
import com.fireblocks.sdk.api.BlockchainsAssetsApi;
import com.fireblocks.sdk.api.ComplianceApi;
import com.fireblocks.sdk.api.ComplianceScreeningConfigurationApi;
import com.fireblocks.sdk.api.ConsoleUserApi;
import com.fireblocks.sdk.api.ContractInteractionsApi;
import com.fireblocks.sdk.api.ContractTemplatesApi;
import com.fireblocks.sdk.api.ContractsApi;
import com.fireblocks.sdk.api.CosignersBetaApi;
import com.fireblocks.sdk.api.DeployedContractsApi;
import com.fireblocks.sdk.api.ExchangeAccountsApi;
import com.fireblocks.sdk.api.ExternalWalletsApi;
import com.fireblocks.sdk.api.FiatAccountsApi;
import com.fireblocks.sdk.api.GasStationsApi;
import com.fireblocks.sdk.api.InternalWalletsApi;
import com.fireblocks.sdk.api.JobManagementApi;
import com.fireblocks.sdk.api.KeyLinkBetaApi;
import com.fireblocks.sdk.api.NetworkConnectionsApi;
import com.fireblocks.sdk.api.NftsApi;
import com.fireblocks.sdk.api.OffExchangesApi;
import com.fireblocks.sdk.api.OtaBetaApi;
import com.fireblocks.sdk.api.PaymentsPayoutApi;
import com.fireblocks.sdk.api.PolicyEditorBetaApi;
import com.fireblocks.sdk.api.ResetDeviceApi;
import com.fireblocks.sdk.api.SmartTransferApi;
import com.fireblocks.sdk.api.StakingBetaApi;
import com.fireblocks.sdk.api.TokenizationApi;
import com.fireblocks.sdk.api.TransactionsApi;
import com.fireblocks.sdk.api.TravelRuleBetaApi;
import com.fireblocks.sdk.api.UserGroupsBetaApi;
import com.fireblocks.sdk.api.UsersApi;
import com.fireblocks.sdk.api.VaultsApi;
import com.fireblocks.sdk.api.Web3ConnectionsApi;
import com.fireblocks.sdk.api.WebhooksApi;
import com.fireblocks.sdk.api.WhitelistIpAddressesApi;
import com.fireblocks.sdk.api.WorkspaceStatusBetaApi;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Flow;

public class Fireblocks {
    private final ApiClient apiClient;
    private final Algorithm signingAlgorithm;
    private final String apiKey;
    private final String userAgent;
    private ApiUserApi apiUser;
    private AssetsApi assets;
    private AuditLogsApi auditLogs;
    private BlockchainsAssetsApi blockchainsAssets;
    private ComplianceApi compliance;
    private ComplianceScreeningConfigurationApi complianceScreeningConfiguration;
    private ConsoleUserApi consoleUser;
    private ContractInteractionsApi contractInteractions;
    private ContractTemplatesApi contractTemplates;
    private ContractsApi contracts;
    private CosignersBetaApi cosignersBeta;
    private DeployedContractsApi deployedContracts;
    private ExchangeAccountsApi exchangeAccounts;
    private ExternalWalletsApi externalWallets;
    private FiatAccountsApi fiatAccounts;
    private GasStationsApi gasStations;
    private InternalWalletsApi internalWallets;
    private JobManagementApi jobManagement;
    private KeyLinkBetaApi keyLinkBeta;
    private NetworkConnectionsApi networkConnections;
    private NftsApi nfts;
    private OffExchangesApi offExchanges;
    private OtaBetaApi otaBeta;
    private PaymentsPayoutApi paymentsPayout;
    private PolicyEditorBetaApi policyEditorBeta;
    private ResetDeviceApi resetDevice;
    private SmartTransferApi smartTransfer;
    private StakingBetaApi stakingBeta;
    private TokenizationApi tokenization;
    private TransactionsApi transactions;
    private TravelRuleBetaApi travelRuleBeta;
    private UserGroupsBetaApi userGroupsBeta;
    private UsersApi users;
    private VaultsApi vaults;
    private Web3ConnectionsApi web3Connections;
    private WebhooksApi webhooks;
    private WhitelistIpAddressesApi whitelistIpAddresses;
    private WorkspaceStatusBetaApi workspaceStatusBeta;

    public Fireblocks(ConfigurationOptions conf) {
        this.apiKey = Optional.ofNullable(conf.getApiKey()).orElse(System.getenv("FIREBLOCKS_API_KEY"));
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            throw new IllegalArgumentException("apiKey is required either in the configuration or as environment variable FIREBLOCKS_API_KEY");
        }
        String secretKey = Optional.ofNullable(conf.getSecretKey()).orElse(System.getenv("FIREBLOCKS_SECRET_KEY"));
        if (secretKey == null || secretKey.isEmpty()) {
            throw new IllegalArgumentException("secretKey is required either in the configuration or as environment variable FIREBLOCKS_SECRET_KEY");
        }
        try {
            this.signingAlgorithm = Algorithm.RSA256(null, (RSAPrivateKey)this.getPrivateKey(secretKey));
        }
        catch (IllegalArgumentException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Invalid secretKey");
        }
        this.apiClient = new ApiClient();
        String basePath = Optional.ofNullable(conf.getBasePath()).orElse(System.getenv("FIREBLOCKS_BASE_PATH"));
        if (basePath == null || basePath.isEmpty()) {
            throw new IllegalArgumentException("basePath is required either in the configuration or as environment variable FIREBLOCKS_BASE_PATH");
        }
        this.apiClient.updateBaseUri(basePath);
        this.userAgent = UserAgentUtil.getUserAgent(conf.getAdditionalOptions());
        this.apiClient.setRequestInterceptor(request -> {
            try {
                request.header("Authorization", "Bearer " + this.signJwt((HttpRequest.Builder)request));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            request.header("Content-Type", "application/json");
            request.header("User-Agent", this.userAgent);
            request.header("X-API-Key", this.apiKey);
        });
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }

    private RSAPrivateKey getPrivateKey(String secretKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String keyContent = new String(secretKey.getBytes(), StandardCharsets.UTF_8).replaceAll("-----(BEGIN|END) PRIVATE KEY-----", "").replaceAll("\\s", "");
        byte[] contentBytes = Base64.getDecoder().decode(keyContent);
        return (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(contentBytes));
    }

    private String signJwt(HttpRequest.Builder builder) throws NoSuchAlgorithmException {
        HttpRequest request = builder.build();
        String path = request.uri().getRawPath() + Optional.ofNullable(request.uri().getRawQuery()).map(query -> "?" + query).orElse("");
        byte[] bytes = request.bodyPublisher().map(p -> {
            final HttpResponse.BodySubscriber<String> bodySubscriber = HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8);
            Flow.Subscriber<ByteBuffer> subscriber = new Flow.Subscriber<ByteBuffer>(){

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    bodySubscriber.onSubscribe(subscription);
                }

                @Override
                public void onNext(ByteBuffer item) {
                    bodySubscriber.onNext(List.of(item));
                }

                @Override
                public void onError(Throwable throwable) {
                    bodySubscriber.onError(throwable);
                }

                @Override
                public void onComplete() {
                    bodySubscriber.onComplete();
                }
            };
            p.subscribe(subscriber);
            return bodySubscriber.getBody().toCompletableFuture().join();
        }).orElse("").getBytes();
        bytes = MessageDigest.getInstance("SHA-256").digest(bytes);
        String bodyHash = this.bytesToHex(bytes);
        Instant now = InstanceTimeWrapper.now();
        Date issuedAt = Date.from(now);
        Date expiresAt = Date.from(now.plusSeconds(55L));
        return JWT.create().withClaim("uri", path).withClaim("nonce", UUID.randomUUID().toString()).withClaim("iat", Long.valueOf(issuedAt.getTime() / 1000L)).withClaim("exp", Long.valueOf(expiresAt.getTime() / 1000L)).withClaim("sub", this.apiKey).withClaim("bodyHash", bodyHash).sign(this.signingAlgorithm);
    }

    public ApiUserApi apiUser() {
        if (this.apiUser == null) {
            this.apiUser = new ApiUserApi(this.apiClient);
        }
        return this.apiUser;
    }

    public AssetsApi assets() {
        if (this.assets == null) {
            this.assets = new AssetsApi(this.apiClient);
        }
        return this.assets;
    }

    public AuditLogsApi auditLogs() {
        if (this.auditLogs == null) {
            this.auditLogs = new AuditLogsApi(this.apiClient);
        }
        return this.auditLogs;
    }

    public BlockchainsAssetsApi blockchainsAssets() {
        if (this.blockchainsAssets == null) {
            this.blockchainsAssets = new BlockchainsAssetsApi(this.apiClient);
        }
        return this.blockchainsAssets;
    }

    public ComplianceApi compliance() {
        if (this.compliance == null) {
            this.compliance = new ComplianceApi(this.apiClient);
        }
        return this.compliance;
    }

    public ComplianceScreeningConfigurationApi complianceScreeningConfiguration() {
        if (this.complianceScreeningConfiguration == null) {
            this.complianceScreeningConfiguration = new ComplianceScreeningConfigurationApi(this.apiClient);
        }
        return this.complianceScreeningConfiguration;
    }

    public ConsoleUserApi consoleUser() {
        if (this.consoleUser == null) {
            this.consoleUser = new ConsoleUserApi(this.apiClient);
        }
        return this.consoleUser;
    }

    public ContractInteractionsApi contractInteractions() {
        if (this.contractInteractions == null) {
            this.contractInteractions = new ContractInteractionsApi(this.apiClient);
        }
        return this.contractInteractions;
    }

    public ContractTemplatesApi contractTemplates() {
        if (this.contractTemplates == null) {
            this.contractTemplates = new ContractTemplatesApi(this.apiClient);
        }
        return this.contractTemplates;
    }

    public ContractsApi contracts() {
        if (this.contracts == null) {
            this.contracts = new ContractsApi(this.apiClient);
        }
        return this.contracts;
    }

    public CosignersBetaApi cosignersBeta() {
        if (this.cosignersBeta == null) {
            this.cosignersBeta = new CosignersBetaApi(this.apiClient);
        }
        return this.cosignersBeta;
    }

    public DeployedContractsApi deployedContracts() {
        if (this.deployedContracts == null) {
            this.deployedContracts = new DeployedContractsApi(this.apiClient);
        }
        return this.deployedContracts;
    }

    public ExchangeAccountsApi exchangeAccounts() {
        if (this.exchangeAccounts == null) {
            this.exchangeAccounts = new ExchangeAccountsApi(this.apiClient);
        }
        return this.exchangeAccounts;
    }

    public ExternalWalletsApi externalWallets() {
        if (this.externalWallets == null) {
            this.externalWallets = new ExternalWalletsApi(this.apiClient);
        }
        return this.externalWallets;
    }

    public FiatAccountsApi fiatAccounts() {
        if (this.fiatAccounts == null) {
            this.fiatAccounts = new FiatAccountsApi(this.apiClient);
        }
        return this.fiatAccounts;
    }

    public GasStationsApi gasStations() {
        if (this.gasStations == null) {
            this.gasStations = new GasStationsApi(this.apiClient);
        }
        return this.gasStations;
    }

    public InternalWalletsApi internalWallets() {
        if (this.internalWallets == null) {
            this.internalWallets = new InternalWalletsApi(this.apiClient);
        }
        return this.internalWallets;
    }

    public JobManagementApi jobManagement() {
        if (this.jobManagement == null) {
            this.jobManagement = new JobManagementApi(this.apiClient);
        }
        return this.jobManagement;
    }

    public KeyLinkBetaApi keyLinkBeta() {
        if (this.keyLinkBeta == null) {
            this.keyLinkBeta = new KeyLinkBetaApi(this.apiClient);
        }
        return this.keyLinkBeta;
    }

    public NetworkConnectionsApi networkConnections() {
        if (this.networkConnections == null) {
            this.networkConnections = new NetworkConnectionsApi(this.apiClient);
        }
        return this.networkConnections;
    }

    public NftsApi nfts() {
        if (this.nfts == null) {
            this.nfts = new NftsApi(this.apiClient);
        }
        return this.nfts;
    }

    public OffExchangesApi offExchanges() {
        if (this.offExchanges == null) {
            this.offExchanges = new OffExchangesApi(this.apiClient);
        }
        return this.offExchanges;
    }

    public OtaBetaApi otaBeta() {
        if (this.otaBeta == null) {
            this.otaBeta = new OtaBetaApi(this.apiClient);
        }
        return this.otaBeta;
    }

    public PaymentsPayoutApi paymentsPayout() {
        if (this.paymentsPayout == null) {
            this.paymentsPayout = new PaymentsPayoutApi(this.apiClient);
        }
        return this.paymentsPayout;
    }

    public PolicyEditorBetaApi policyEditorBeta() {
        if (this.policyEditorBeta == null) {
            this.policyEditorBeta = new PolicyEditorBetaApi(this.apiClient);
        }
        return this.policyEditorBeta;
    }

    public ResetDeviceApi resetDevice() {
        if (this.resetDevice == null) {
            this.resetDevice = new ResetDeviceApi(this.apiClient);
        }
        return this.resetDevice;
    }

    public SmartTransferApi smartTransfer() {
        if (this.smartTransfer == null) {
            this.smartTransfer = new SmartTransferApi(this.apiClient);
        }
        return this.smartTransfer;
    }

    public StakingBetaApi stakingBeta() {
        if (this.stakingBeta == null) {
            this.stakingBeta = new StakingBetaApi(this.apiClient);
        }
        return this.stakingBeta;
    }

    public TokenizationApi tokenization() {
        if (this.tokenization == null) {
            this.tokenization = new TokenizationApi(this.apiClient);
        }
        return this.tokenization;
    }

    public TransactionsApi transactions() {
        if (this.transactions == null) {
            this.transactions = new TransactionsApi(this.apiClient);
        }
        return this.transactions;
    }

    public TravelRuleBetaApi travelRuleBeta() {
        if (this.travelRuleBeta == null) {
            this.travelRuleBeta = new TravelRuleBetaApi(this.apiClient);
        }
        return this.travelRuleBeta;
    }

    public UserGroupsBetaApi userGroupsBeta() {
        if (this.userGroupsBeta == null) {
            this.userGroupsBeta = new UserGroupsBetaApi(this.apiClient);
        }
        return this.userGroupsBeta;
    }

    public UsersApi users() {
        if (this.users == null) {
            this.users = new UsersApi(this.apiClient);
        }
        return this.users;
    }

    public VaultsApi vaults() {
        if (this.vaults == null) {
            this.vaults = new VaultsApi(this.apiClient);
        }
        return this.vaults;
    }

    public Web3ConnectionsApi web3Connections() {
        if (this.web3Connections == null) {
            this.web3Connections = new Web3ConnectionsApi(this.apiClient);
        }
        return this.web3Connections;
    }

    public WebhooksApi webhooks() {
        if (this.webhooks == null) {
            this.webhooks = new WebhooksApi(this.apiClient);
        }
        return this.webhooks;
    }

    public WhitelistIpAddressesApi whitelistIpAddresses() {
        if (this.whitelistIpAddresses == null) {
            this.whitelistIpAddresses = new WhitelistIpAddressesApi(this.apiClient);
        }
        return this.whitelistIpAddresses;
    }

    public WorkspaceStatusBetaApi workspaceStatusBeta() {
        if (this.workspaceStatusBeta == null) {
            this.workspaceStatusBeta = new WorkspaceStatusBetaApi(this.apiClient);
        }
        return this.workspaceStatusBeta;
    }
}

