/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fireblocks.sdk.ApiClient;
import com.fireblocks.sdk.ApiException;
import com.fireblocks.sdk.ApiResponse;
import com.fireblocks.sdk.ValidationUtils;
import com.fireblocks.sdk.model.AddContractAssetRequest;
import com.fireblocks.sdk.model.CreateContractRequest;
import com.fireblocks.sdk.model.ExternalWalletAsset;
import com.fireblocks.sdk.model.UnmanagedWallet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class ContractsApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public ContractsApi() {
        this(new ApiClient());
    }

    public ContractsApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    private ApiException getApiException(String operationId, HttpResponse<String> response) {
        String message = this.formatExceptionMessage(operationId, response.statusCode(), response.body());
        return new ApiException(response.statusCode(), message, response.headers(), response.body());
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public CompletableFuture<ApiResponse<ExternalWalletAsset>> addContractAsset(String contractId, String assetId, AddContractAssetRequest addContractAssetRequest, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.addContractAssetRequestBuilder(contractId, assetId, addContractAssetRequest, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("addContractAsset", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (ExternalWalletAsset)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ExternalWalletAsset>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder addContractAssetRequestBuilder(String contractId, String assetId, AddContractAssetRequest addContractAssetRequest, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("addContractAsset", "contractId", contractId);
        ValidationUtils.assertParamExistsAndNotEmpty("addContractAsset", "assetId", assetId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/contracts/{contractId}/{assetId}".replace("{contractId}", ApiClient.urlEncode(contractId.toString())).replace("{assetId}", ApiClient.urlEncode(assetId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)addContractAssetRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<UnmanagedWallet>> createContract(CreateContractRequest createContractRequest, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.createContractRequestBuilder(createContractRequest, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("createContract", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (UnmanagedWallet)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<UnmanagedWallet>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder createContractRequestBuilder(CreateContractRequest createContractRequest, String idempotencyKey) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/contracts";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createContractRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<Void>> deleteContract(String contractId) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.deleteContractRequestBuilder(contractId);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("deleteContract", (HttpResponse<String>)localVarResponse));
                }
                return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null));
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder deleteContractRequestBuilder(String contractId) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("deleteContract", "contractId", contractId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/contracts/{contractId}".replace("{contractId}", ApiClient.urlEncode(contractId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<Void>> deleteContractAsset(String contractId, String assetId) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.deleteContractAssetRequestBuilder(contractId, assetId);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("deleteContractAsset", (HttpResponse<String>)localVarResponse));
                }
                return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null));
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder deleteContractAssetRequestBuilder(String contractId, String assetId) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("deleteContractAsset", "contractId", contractId);
        ValidationUtils.assertParamExistsAndNotEmpty("deleteContractAsset", "assetId", assetId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/contracts/{contractId}/{assetId}".replace("{contractId}", ApiClient.urlEncode(contractId.toString())).replace("{assetId}", ApiClient.urlEncode(assetId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<UnmanagedWallet>> getContract(String contractId) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getContractRequestBuilder(contractId);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getContract", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (UnmanagedWallet)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<UnmanagedWallet>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getContractRequestBuilder(String contractId) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("getContract", "contractId", contractId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/contracts/{contractId}".replace("{contractId}", ApiClient.urlEncode(contractId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<ExternalWalletAsset>> getContractAsset(String contractId, String assetId) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getContractAssetRequestBuilder(contractId, assetId);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getContractAsset", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (ExternalWalletAsset)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ExternalWalletAsset>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getContractAssetRequestBuilder(String contractId, String assetId) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("getContractAsset", "contractId", contractId);
        ValidationUtils.assertParamExistsAndNotEmpty("getContractAsset", "assetId", assetId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/contracts/{contractId}/{assetId}".replace("{contractId}", ApiClient.urlEncode(contractId.toString())).replace("{assetId}", ApiClient.urlEncode(assetId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<List<UnmanagedWallet>>> getContracts() throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getContractsRequestBuilder();
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getContracts", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (List)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<List<UnmanagedWallet>>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getContractsRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/contracts";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

