/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fireblocks.sdk.ApiClient;
import com.fireblocks.sdk.ApiException;
import com.fireblocks.sdk.ApiResponse;
import com.fireblocks.sdk.Pair;
import com.fireblocks.sdk.ValidationUtils;
import com.fireblocks.sdk.model.GetNFTsResponse;
import com.fireblocks.sdk.model.GetOwnershipTokensResponse;
import com.fireblocks.sdk.model.ListOwnedCollectionsResponse;
import com.fireblocks.sdk.model.ListOwnedTokensResponse;
import com.fireblocks.sdk.model.TokenOwnershipSpamUpdatePayload;
import com.fireblocks.sdk.model.TokenOwnershipStatusUpdatePayload;
import com.fireblocks.sdk.model.TokenResponse;
import com.fireblocks.sdk.model.UpdateTokenOwnershipStatusDto;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class NftsApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public NftsApi() {
        this(new ApiClient());
    }

    public NftsApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    private ApiException getApiException(String operationId, HttpResponse<String> response) {
        String message = this.formatExceptionMessage(operationId, response.statusCode(), response.body());
        return new ApiException(response.statusCode(), message, response.headers(), response.body());
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public CompletableFuture<ApiResponse<TokenResponse>> getNFT(String id) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getNFTRequestBuilder(id);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getNFT", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (TokenResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<TokenResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getNFTRequestBuilder(String id) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("getNFT", "id", id);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/nfts/tokens/{id}".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<GetNFTsResponse>> getNFTs(String ids, String pageCursor, BigDecimal pageSize, List<String> sort, String order) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getNFTsRequestBuilder(ids, pageCursor, pageSize, sort, order);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getNFTs", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (GetNFTsResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<GetNFTsResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getNFTsRequestBuilder(String ids, String pageCursor, BigDecimal pageSize, List<String> sort, String order) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("getNFTs", "ids", ids);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/nfts/tokens";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "ids";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("ids", ids));
        localVarQueryParameterBaseName = "pageCursor";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("pageCursor", pageCursor));
        localVarQueryParameterBaseName = "pageSize";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("pageSize", pageSize));
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("multi", "sort", sort));
        localVarQueryParameterBaseName = "order";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("order", order));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<GetOwnershipTokensResponse>> getOwnershipTokens(String blockchainDescriptor, String vaultAccountIds, String ncwId, String ncwAccountIds, String walletType, String ids, String collectionIds, String pageCursor, BigDecimal pageSize, List<String> sort, String order, String status, String search, String spam) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getOwnershipTokensRequestBuilder(blockchainDescriptor, vaultAccountIds, ncwId, ncwAccountIds, walletType, ids, collectionIds, pageCursor, pageSize, sort, order, status, search, spam);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getOwnershipTokens", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (GetOwnershipTokensResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<GetOwnershipTokensResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getOwnershipTokensRequestBuilder(String blockchainDescriptor, String vaultAccountIds, String ncwId, String ncwAccountIds, String walletType, String ids, String collectionIds, String pageCursor, BigDecimal pageSize, List<String> sort, String order, String status, String search, String spam) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/nfts/ownership/tokens";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "blockchainDescriptor";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("blockchainDescriptor", blockchainDescriptor));
        localVarQueryParameterBaseName = "vaultAccountIds";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("vaultAccountIds", vaultAccountIds));
        localVarQueryParameterBaseName = "ncwId";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("ncwId", ncwId));
        localVarQueryParameterBaseName = "ncwAccountIds";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("ncwAccountIds", ncwAccountIds));
        localVarQueryParameterBaseName = "walletType";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("walletType", walletType));
        localVarQueryParameterBaseName = "ids";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("ids", ids));
        localVarQueryParameterBaseName = "collectionIds";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("collectionIds", collectionIds));
        localVarQueryParameterBaseName = "pageCursor";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("pageCursor", pageCursor));
        localVarQueryParameterBaseName = "pageSize";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("pageSize", pageSize));
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("multi", "sort", sort));
        localVarQueryParameterBaseName = "order";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("order", order));
        localVarQueryParameterBaseName = "status";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("status", status));
        localVarQueryParameterBaseName = "search";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("search", search));
        localVarQueryParameterBaseName = "spam";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("spam", spam));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<ListOwnedCollectionsResponse>> listOwnedCollections(String ncwId, String walletType, String search, String pageCursor, BigDecimal pageSize, List<String> sort, String order, String status) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.listOwnedCollectionsRequestBuilder(ncwId, walletType, search, pageCursor, pageSize, sort, order, status);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("listOwnedCollections", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (ListOwnedCollectionsResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ListOwnedCollectionsResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder listOwnedCollectionsRequestBuilder(String ncwId, String walletType, String search, String pageCursor, BigDecimal pageSize, List<String> sort, String order, String status) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/nfts/ownership/collections";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "ncwId";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("ncwId", ncwId));
        localVarQueryParameterBaseName = "walletType";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("walletType", walletType));
        localVarQueryParameterBaseName = "search";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("search", search));
        localVarQueryParameterBaseName = "pageCursor";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("pageCursor", pageCursor));
        localVarQueryParameterBaseName = "pageSize";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("pageSize", pageSize));
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("multi", "sort", sort));
        localVarQueryParameterBaseName = "order";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("order", order));
        localVarQueryParameterBaseName = "status";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("status", status));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<ListOwnedTokensResponse>> listOwnedTokens(String ncwId, String walletType, String pageCursor, BigDecimal pageSize, List<String> sort, String order, String status, String search, String spam) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.listOwnedTokensRequestBuilder(ncwId, walletType, pageCursor, pageSize, sort, order, status, search, spam);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("listOwnedTokens", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (ListOwnedTokensResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ListOwnedTokensResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder listOwnedTokensRequestBuilder(String ncwId, String walletType, String pageCursor, BigDecimal pageSize, List<String> sort, String order, String status, String search, String spam) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/nfts/ownership/assets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "ncwId";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("ncwId", ncwId));
        localVarQueryParameterBaseName = "walletType";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("walletType", walletType));
        localVarQueryParameterBaseName = "pageCursor";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("pageCursor", pageCursor));
        localVarQueryParameterBaseName = "pageSize";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("pageSize", pageSize));
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("multi", "sort", sort));
        localVarQueryParameterBaseName = "order";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("order", order));
        localVarQueryParameterBaseName = "status";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("status", status));
        localVarQueryParameterBaseName = "search";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("search", search));
        localVarQueryParameterBaseName = "spam";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("spam", spam));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<Void>> refreshNFTMetadata(String id, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.refreshNFTMetadataRequestBuilder(id, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("refreshNFTMetadata", (HttpResponse<String>)localVarResponse));
                }
                return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null));
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder refreshNFTMetadataRequestBuilder(String id, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("refreshNFTMetadata", "id", id);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/nfts/tokens/{id}".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<Void>> updateOwnershipTokens(String blockchainDescriptor, String vaultAccountId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.updateOwnershipTokensRequestBuilder(blockchainDescriptor, vaultAccountId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("updateOwnershipTokens", (HttpResponse<String>)localVarResponse));
                }
                return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null));
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder updateOwnershipTokensRequestBuilder(String blockchainDescriptor, String vaultAccountId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("updateOwnershipTokens", "blockchainDescriptor", blockchainDescriptor);
        ValidationUtils.assertParamExistsAndNotEmpty("updateOwnershipTokens", "vaultAccountId", vaultAccountId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/nfts/ownership/tokens";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "blockchainDescriptor";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("blockchainDescriptor", blockchainDescriptor));
        localVarQueryParameterBaseName = "vaultAccountId";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("vaultAccountId", vaultAccountId));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<Void>> updateTokenOwnershipStatus(UpdateTokenOwnershipStatusDto updateTokenOwnershipStatusDto, String id, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.updateTokenOwnershipStatusRequestBuilder(updateTokenOwnershipStatusDto, id, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("updateTokenOwnershipStatus", (HttpResponse<String>)localVarResponse));
                }
                return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null));
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder updateTokenOwnershipStatusRequestBuilder(UpdateTokenOwnershipStatusDto updateTokenOwnershipStatusDto, String id, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("updateTokenOwnershipStatus", "updateTokenOwnershipStatusDto", updateTokenOwnershipStatusDto);
        ValidationUtils.assertParamExistsAndNotEmpty("updateTokenOwnershipStatus", "id", id);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/nfts/ownership/tokens/{id}/status".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateTokenOwnershipStatusDto);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<Void>> updateTokensOwnershipSpam(List<TokenOwnershipSpamUpdatePayload> tokenOwnershipSpamUpdatePayload, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.updateTokensOwnershipSpamRequestBuilder(tokenOwnershipSpamUpdatePayload, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("updateTokensOwnershipSpam", (HttpResponse<String>)localVarResponse));
                }
                return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null));
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder updateTokensOwnershipSpamRequestBuilder(List<TokenOwnershipSpamUpdatePayload> tokenOwnershipSpamUpdatePayload, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("updateTokensOwnershipSpam", "tokenOwnershipSpamUpdatePayload", tokenOwnershipSpamUpdatePayload);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/nfts/ownership/tokens/spam";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(tokenOwnershipSpamUpdatePayload);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<Void>> updateTokensOwnershipStatus(List<TokenOwnershipStatusUpdatePayload> tokenOwnershipStatusUpdatePayload, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.updateTokensOwnershipStatusRequestBuilder(tokenOwnershipStatusUpdatePayload, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("updateTokensOwnershipStatus", (HttpResponse<String>)localVarResponse));
                }
                return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null));
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder updateTokensOwnershipStatusRequestBuilder(List<TokenOwnershipStatusUpdatePayload> tokenOwnershipStatusUpdatePayload, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("updateTokensOwnershipStatus", "tokenOwnershipStatusUpdatePayload", tokenOwnershipStatusUpdatePayload);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/nfts/ownership/tokens/status";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(tokenOwnershipStatusUpdatePayload);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

