/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fireblocks.sdk.ApiClient;
import com.fireblocks.sdk.ApiException;
import com.fireblocks.sdk.ApiResponse;
import com.fireblocks.sdk.ValidationUtils;
import com.fireblocks.sdk.model.DraftReviewAndValidationResponse;
import com.fireblocks.sdk.model.PolicyAndValidationResponse;
import com.fireblocks.sdk.model.PolicyRules;
import com.fireblocks.sdk.model.PublishDraftRequest;
import com.fireblocks.sdk.model.PublishResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class PolicyEditorBetaApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public PolicyEditorBetaApi() {
        this(new ApiClient());
    }

    public PolicyEditorBetaApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    private ApiException getApiException(String operationId, HttpResponse<String> response) {
        String message = this.formatExceptionMessage(operationId, response.statusCode(), response.body());
        return new ApiException(response.statusCode(), message, response.headers(), response.body());
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public CompletableFuture<ApiResponse<PolicyAndValidationResponse>> getActivePolicy() throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getActivePolicyRequestBuilder();
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getActivePolicy", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (PolicyAndValidationResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<PolicyAndValidationResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getActivePolicyRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/tap/active_policy";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<DraftReviewAndValidationResponse>> getDraft() throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getDraftRequestBuilder();
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getDraft", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (DraftReviewAndValidationResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<DraftReviewAndValidationResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getDraftRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/tap/draft";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<PublishResult>> publishDraft(PublishDraftRequest publishDraftRequest, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.publishDraftRequestBuilder(publishDraftRequest, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("publishDraft", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (PublishResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<PublishResult>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder publishDraftRequestBuilder(PublishDraftRequest publishDraftRequest, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("publishDraft", "publishDraftRequest", publishDraftRequest);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/tap/draft";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)publishDraftRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<PublishResult>> publishPolicyRules(PolicyRules policyRules, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.publishPolicyRulesRequestBuilder(policyRules, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("publishPolicyRules", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (PublishResult)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<PublishResult>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder publishPolicyRulesRequestBuilder(PolicyRules policyRules, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("publishPolicyRules", "policyRules", policyRules);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/tap/publish";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)policyRules);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<DraftReviewAndValidationResponse>> updateDraft(PolicyRules policyRules, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.updateDraftRequestBuilder(policyRules, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("updateDraft", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (DraftReviewAndValidationResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<DraftReviewAndValidationResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder updateDraftRequestBuilder(PolicyRules policyRules, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("updateDraft", "policyRules", policyRules);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/tap/draft";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)policyRules);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

