/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fireblocks.sdk.ApiClient;
import com.fireblocks.sdk.ApiException;
import com.fireblocks.sdk.ApiResponse;
import com.fireblocks.sdk.Pair;
import com.fireblocks.sdk.ValidationUtils;
import com.fireblocks.sdk.model.SmartTransferCreateTicket;
import com.fireblocks.sdk.model.SmartTransferCreateTicketTerm;
import com.fireblocks.sdk.model.SmartTransferFundTerm;
import com.fireblocks.sdk.model.SmartTransferManuallyFundTerm;
import com.fireblocks.sdk.model.SmartTransferSetTicketExpiration;
import com.fireblocks.sdk.model.SmartTransferSetTicketExternalId;
import com.fireblocks.sdk.model.SmartTransferSetUserGroups;
import com.fireblocks.sdk.model.SmartTransferSubmitTicket;
import com.fireblocks.sdk.model.SmartTransferTicketFilteredResponse;
import com.fireblocks.sdk.model.SmartTransferTicketResponse;
import com.fireblocks.sdk.model.SmartTransferTicketTermResponse;
import com.fireblocks.sdk.model.SmartTransferUpdateTicketTerm;
import com.fireblocks.sdk.model.SmartTransferUserGroupsResponse;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class SmartTransferApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public SmartTransferApi() {
        this(new ApiClient());
    }

    public SmartTransferApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    private ApiException getApiException(String operationId, HttpResponse<String> response) {
        String message = this.formatExceptionMessage(operationId, response.statusCode(), response.body());
        return new ApiException(response.statusCode(), message, response.headers(), response.body());
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public CompletableFuture<ApiResponse<SmartTransferTicketResponse>> cancelTicket(String ticketId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.cancelTicketRequestBuilder(ticketId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("cancelTicket", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (SmartTransferTicketResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SmartTransferTicketResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder cancelTicketRequestBuilder(String ticketId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("cancelTicket", "ticketId", ticketId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers/{ticketId}/cancel".replace("{ticketId}", ApiClient.urlEncode(ticketId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<SmartTransferTicketResponse>> createTicket(SmartTransferCreateTicket smartTransferCreateTicket, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.createTicketRequestBuilder(smartTransferCreateTicket, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("createTicket", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (SmartTransferTicketResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SmartTransferTicketResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder createTicketRequestBuilder(SmartTransferCreateTicket smartTransferCreateTicket, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("createTicket", "smartTransferCreateTicket", smartTransferCreateTicket);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)smartTransferCreateTicket);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<SmartTransferTicketTermResponse>> createTicketTerm(SmartTransferCreateTicketTerm smartTransferCreateTicketTerm, String ticketId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.createTicketTermRequestBuilder(smartTransferCreateTicketTerm, ticketId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("createTicketTerm", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (SmartTransferTicketTermResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SmartTransferTicketTermResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder createTicketTermRequestBuilder(SmartTransferCreateTicketTerm smartTransferCreateTicketTerm, String ticketId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("createTicketTerm", "smartTransferCreateTicketTerm", smartTransferCreateTicketTerm);
        ValidationUtils.assertParamExistsAndNotEmpty("createTicketTerm", "ticketId", ticketId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers/{ticketId}/terms".replace("{ticketId}", ApiClient.urlEncode(ticketId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)smartTransferCreateTicketTerm);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<SmartTransferTicketResponse>> findTicketById(String ticketId) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.findTicketByIdRequestBuilder(ticketId);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("findTicketById", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (SmartTransferTicketResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SmartTransferTicketResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder findTicketByIdRequestBuilder(String ticketId) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("findTicketById", "ticketId", ticketId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers/{ticketId}".replace("{ticketId}", ApiClient.urlEncode(ticketId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<SmartTransferTicketTermResponse>> findTicketTermById(String ticketId, String termId) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.findTicketTermByIdRequestBuilder(ticketId, termId);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("findTicketTermById", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (SmartTransferTicketTermResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SmartTransferTicketTermResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder findTicketTermByIdRequestBuilder(String ticketId, String termId) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("findTicketTermById", "ticketId", ticketId);
        ValidationUtils.assertParamExistsAndNotEmpty("findTicketTermById", "termId", termId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers/{ticketId}/terms/{termId}".replace("{ticketId}", ApiClient.urlEncode(ticketId.toString())).replace("{termId}", ApiClient.urlEncode(termId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<SmartTransferTicketResponse>> fulfillTicket(String ticketId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.fulfillTicketRequestBuilder(ticketId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("fulfillTicket", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (SmartTransferTicketResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SmartTransferTicketResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder fulfillTicketRequestBuilder(String ticketId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("fulfillTicket", "ticketId", ticketId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers/{ticketId}/fulfill".replace("{ticketId}", ApiClient.urlEncode(ticketId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<SmartTransferTicketTermResponse>> fundTicketTerm(SmartTransferFundTerm smartTransferFundTerm, String ticketId, String termId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.fundTicketTermRequestBuilder(smartTransferFundTerm, ticketId, termId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("fundTicketTerm", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (SmartTransferTicketTermResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SmartTransferTicketTermResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder fundTicketTermRequestBuilder(SmartTransferFundTerm smartTransferFundTerm, String ticketId, String termId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("fundTicketTerm", "smartTransferFundTerm", smartTransferFundTerm);
        ValidationUtils.assertParamExistsAndNotEmpty("fundTicketTerm", "ticketId", ticketId);
        ValidationUtils.assertParamExistsAndNotEmpty("fundTicketTerm", "termId", termId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers/{ticketId}/terms/{termId}/fund".replace("{ticketId}", ApiClient.urlEncode(ticketId.toString())).replace("{termId}", ApiClient.urlEncode(termId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)smartTransferFundTerm);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<SmartTransferUserGroupsResponse>> getSmartTransferUserGroups() throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getSmartTransferUserGroupsRequestBuilder();
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getSmartTransferUserGroups", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (SmartTransferUserGroupsResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SmartTransferUserGroupsResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getSmartTransferUserGroupsRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers/settings/user-groups";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<SmartTransferTicketTermResponse>> manuallyFundTicketTerm(SmartTransferManuallyFundTerm smartTransferManuallyFundTerm, String ticketId, String termId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.manuallyFundTicketTermRequestBuilder(smartTransferManuallyFundTerm, ticketId, termId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("manuallyFundTicketTerm", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (SmartTransferTicketTermResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SmartTransferTicketTermResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder manuallyFundTicketTermRequestBuilder(SmartTransferManuallyFundTerm smartTransferManuallyFundTerm, String ticketId, String termId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("manuallyFundTicketTerm", "smartTransferManuallyFundTerm", smartTransferManuallyFundTerm);
        ValidationUtils.assertParamExistsAndNotEmpty("manuallyFundTicketTerm", "ticketId", ticketId);
        ValidationUtils.assertParamExistsAndNotEmpty("manuallyFundTicketTerm", "termId", termId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers/{ticketId}/terms/{termId}/manually-fund".replace("{ticketId}", ApiClient.urlEncode(ticketId.toString())).replace("{termId}", ApiClient.urlEncode(termId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)smartTransferManuallyFundTerm);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<Void>> removeTicketTerm(String ticketId, String termId) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.removeTicketTermRequestBuilder(ticketId, termId);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("removeTicketTerm", (HttpResponse<String>)localVarResponse));
                }
                return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null));
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder removeTicketTermRequestBuilder(String ticketId, String termId) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("removeTicketTerm", "ticketId", ticketId);
        ValidationUtils.assertParamExistsAndNotEmpty("removeTicketTerm", "termId", termId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers/{ticketId}/terms/{termId}".replace("{ticketId}", ApiClient.urlEncode(ticketId.toString())).replace("{termId}", ApiClient.urlEncode(termId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<SmartTransferTicketFilteredResponse>> searchTickets(String q, List<String> statuses, String networkId, Boolean createdByMe, OffsetDateTime expiresAfter, OffsetDateTime expiresBefore, String type, String externalRefId, String after, BigDecimal limit) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.searchTicketsRequestBuilder(q, statuses, networkId, createdByMe, expiresAfter, expiresBefore, type, externalRefId, after, limit);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("searchTickets", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (SmartTransferTicketFilteredResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SmartTransferTicketFilteredResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder searchTicketsRequestBuilder(String q, List<String> statuses, String networkId, Boolean createdByMe, OffsetDateTime expiresAfter, OffsetDateTime expiresBefore, String type, String externalRefId, String after, BigDecimal limit) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "q";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("q", q));
        localVarQueryParameterBaseName = "statuses";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("multi", "statuses", statuses));
        localVarQueryParameterBaseName = "networkId";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("networkId", networkId));
        localVarQueryParameterBaseName = "createdByMe";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("createdByMe", createdByMe));
        localVarQueryParameterBaseName = "expiresAfter";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("expiresAfter", expiresAfter));
        localVarQueryParameterBaseName = "expiresBefore";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("expiresBefore", expiresBefore));
        localVarQueryParameterBaseName = "type";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("type", type));
        localVarQueryParameterBaseName = "externalRefId";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("externalRefId", externalRefId));
        localVarQueryParameterBaseName = "after";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("after", after));
        localVarQueryParameterBaseName = "limit";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("limit", limit));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<SmartTransferTicketResponse>> setExternalRefId(SmartTransferSetTicketExternalId smartTransferSetTicketExternalId, String ticketId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.setExternalRefIdRequestBuilder(smartTransferSetTicketExternalId, ticketId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("setExternalRefId", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (SmartTransferTicketResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SmartTransferTicketResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder setExternalRefIdRequestBuilder(SmartTransferSetTicketExternalId smartTransferSetTicketExternalId, String ticketId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("setExternalRefId", "smartTransferSetTicketExternalId", smartTransferSetTicketExternalId);
        ValidationUtils.assertParamExistsAndNotEmpty("setExternalRefId", "ticketId", ticketId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers/{ticketId}/external-id".replace("{ticketId}", ApiClient.urlEncode(ticketId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)smartTransferSetTicketExternalId);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<SmartTransferTicketResponse>> setTicketExpiration(SmartTransferSetTicketExpiration smartTransferSetTicketExpiration, String ticketId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.setTicketExpirationRequestBuilder(smartTransferSetTicketExpiration, ticketId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("setTicketExpiration", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (SmartTransferTicketResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SmartTransferTicketResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder setTicketExpirationRequestBuilder(SmartTransferSetTicketExpiration smartTransferSetTicketExpiration, String ticketId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("setTicketExpiration", "smartTransferSetTicketExpiration", smartTransferSetTicketExpiration);
        ValidationUtils.assertParamExistsAndNotEmpty("setTicketExpiration", "ticketId", ticketId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers/{ticketId}/expires-in".replace("{ticketId}", ApiClient.urlEncode(ticketId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)smartTransferSetTicketExpiration);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<SmartTransferUserGroupsResponse>> setUserGroups(SmartTransferSetUserGroups smartTransferSetUserGroups, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.setUserGroupsRequestBuilder(smartTransferSetUserGroups, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("setUserGroups", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (SmartTransferUserGroupsResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SmartTransferUserGroupsResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder setUserGroupsRequestBuilder(SmartTransferSetUserGroups smartTransferSetUserGroups, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("setUserGroups", "smartTransferSetUserGroups", smartTransferSetUserGroups);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers/settings/user-groups";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)smartTransferSetUserGroups);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<SmartTransferTicketResponse>> submitTicket(SmartTransferSubmitTicket smartTransferSubmitTicket, String ticketId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.submitTicketRequestBuilder(smartTransferSubmitTicket, ticketId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("submitTicket", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (SmartTransferTicketResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SmartTransferTicketResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder submitTicketRequestBuilder(SmartTransferSubmitTicket smartTransferSubmitTicket, String ticketId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("submitTicket", "smartTransferSubmitTicket", smartTransferSubmitTicket);
        ValidationUtils.assertParamExistsAndNotEmpty("submitTicket", "ticketId", ticketId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers/{ticketId}/submit".replace("{ticketId}", ApiClient.urlEncode(ticketId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)smartTransferSubmitTicket);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<SmartTransferTicketTermResponse>> updateTicketTerm(SmartTransferUpdateTicketTerm smartTransferUpdateTicketTerm, String ticketId, String termId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.updateTicketTermRequestBuilder(smartTransferUpdateTicketTerm, ticketId, termId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("updateTicketTerm", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (SmartTransferTicketTermResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<SmartTransferTicketTermResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder updateTicketTermRequestBuilder(SmartTransferUpdateTicketTerm smartTransferUpdateTicketTerm, String ticketId, String termId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("updateTicketTerm", "smartTransferUpdateTicketTerm", smartTransferUpdateTicketTerm);
        ValidationUtils.assertParamExistsAndNotEmpty("updateTicketTerm", "ticketId", ticketId);
        ValidationUtils.assertParamExistsAndNotEmpty("updateTicketTerm", "termId", termId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/smart-transfers/{ticketId}/terms/{termId}".replace("{ticketId}", ApiClient.urlEncode(ticketId.toString())).replace("{termId}", ApiClient.urlEncode(termId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)smartTransferUpdateTicketTerm);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

