/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fireblocks.sdk.ApiClient;
import com.fireblocks.sdk.ApiException;
import com.fireblocks.sdk.ApiResponse;
import com.fireblocks.sdk.Pair;
import com.fireblocks.sdk.ValidationUtils;
import com.fireblocks.sdk.model.TravelRuleGetAllVASPsResponse;
import com.fireblocks.sdk.model.TravelRuleUpdateVASPDetails;
import com.fireblocks.sdk.model.TravelRuleVASP;
import com.fireblocks.sdk.model.TravelRuleValidateFullTransactionRequest;
import com.fireblocks.sdk.model.TravelRuleValidateTransactionRequest;
import com.fireblocks.sdk.model.TravelRuleValidateTransactionResponse;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class TravelRuleBetaApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public TravelRuleBetaApi() {
        this(new ApiClient());
    }

    public TravelRuleBetaApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    private ApiException getApiException(String operationId, HttpResponse<String> response) {
        String message = this.formatExceptionMessage(operationId, response.statusCode(), response.body());
        return new ApiException(response.statusCode(), message, response.headers(), response.body());
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public CompletableFuture<ApiResponse<TravelRuleVASP>> getVASPByDID(String did, String fields) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getVASPByDIDRequestBuilder(did, fields);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getVASPByDID", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (TravelRuleVASP)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<TravelRuleVASP>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getVASPByDIDRequestBuilder(String did, String fields) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("getVASPByDID", "did", did);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/screening/travel_rule/vasp/{did}".replace("{did}", ApiClient.urlEncode(did.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "fields";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("fields", fields));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<TravelRuleGetAllVASPsResponse>> getVASPs(String order, BigDecimal perPage, BigDecimal page, String fields) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getVASPsRequestBuilder(order, perPage, page, fields);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getVASPs", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (TravelRuleGetAllVASPsResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<TravelRuleGetAllVASPsResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getVASPsRequestBuilder(String order, BigDecimal perPage, BigDecimal page, String fields) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/screening/travel_rule/vasp";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "order";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("order", order));
        localVarQueryParameterBaseName = "per_page";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("per_page", perPage));
        localVarQueryParameterBaseName = "page";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("page", page));
        localVarQueryParameterBaseName = "fields";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("fields", fields));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<TravelRuleUpdateVASPDetails>> updateVasp(TravelRuleUpdateVASPDetails travelRuleUpdateVASPDetails, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.updateVaspRequestBuilder(travelRuleUpdateVASPDetails, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("updateVasp", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (TravelRuleUpdateVASPDetails)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<TravelRuleUpdateVASPDetails>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder updateVaspRequestBuilder(TravelRuleUpdateVASPDetails travelRuleUpdateVASPDetails, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("updateVasp", "travelRuleUpdateVASPDetails", travelRuleUpdateVASPDetails);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/screening/travel_rule/vasp/update";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)travelRuleUpdateVASPDetails);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<TravelRuleValidateTransactionResponse>> validateFullTravelRuleTransaction(TravelRuleValidateFullTransactionRequest travelRuleValidateFullTransactionRequest, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.validateFullTravelRuleTransactionRequestBuilder(travelRuleValidateFullTransactionRequest, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("validateFullTravelRuleTransaction", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (TravelRuleValidateTransactionResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<TravelRuleValidateTransactionResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder validateFullTravelRuleTransactionRequestBuilder(TravelRuleValidateFullTransactionRequest travelRuleValidateFullTransactionRequest, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("validateFullTravelRuleTransaction", "travelRuleValidateFullTransactionRequest", travelRuleValidateFullTransactionRequest);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/screening/travel_rule/transaction/validate/full";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)travelRuleValidateFullTransactionRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<TravelRuleValidateTransactionResponse>> validateTravelRuleTransaction(TravelRuleValidateTransactionRequest travelRuleValidateTransactionRequest, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.validateTravelRuleTransactionRequestBuilder(travelRuleValidateTransactionRequest, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("validateTravelRuleTransaction", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (TravelRuleValidateTransactionResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<TravelRuleValidateTransactionResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder validateTravelRuleTransactionRequestBuilder(TravelRuleValidateTransactionRequest travelRuleValidateTransactionRequest, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("validateTravelRuleTransaction", "travelRuleValidateTransactionRequest", travelRuleValidateTransactionRequest);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/screening/travel_rule/transaction/validate";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)travelRuleValidateTransactionRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

