/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fireblocks.sdk.ApiClient;
import com.fireblocks.sdk.ApiException;
import com.fireblocks.sdk.ApiResponse;
import com.fireblocks.sdk.ValidationUtils;
import com.fireblocks.sdk.model.CreateUserGroupResponse;
import com.fireblocks.sdk.model.UserGroupCreateRequest;
import com.fireblocks.sdk.model.UserGroupCreateResponse;
import com.fireblocks.sdk.model.UserGroupResponse;
import com.fireblocks.sdk.model.UserGroupUpdateRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class UserGroupsBetaApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public UserGroupsBetaApi() {
        this(new ApiClient());
    }

    public UserGroupsBetaApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    private ApiException getApiException(String operationId, HttpResponse<String> response) {
        String message = this.formatExceptionMessage(operationId, response.statusCode(), response.body());
        return new ApiException(response.statusCode(), message, response.headers(), response.body());
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public CompletableFuture<ApiResponse<CreateUserGroupResponse>> createUserGroup(UserGroupCreateRequest userGroupCreateRequest, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.createUserGroupRequestBuilder(userGroupCreateRequest, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("createUserGroup", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (CreateUserGroupResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<CreateUserGroupResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder createUserGroupRequestBuilder(UserGroupCreateRequest userGroupCreateRequest, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("createUserGroup", "userGroupCreateRequest", userGroupCreateRequest);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/management/user_groups";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)userGroupCreateRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<Void>> deleteUserGroup(String groupId) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.deleteUserGroupRequestBuilder(groupId);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("deleteUserGroup", (HttpResponse<String>)localVarResponse));
                }
                return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null));
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder deleteUserGroupRequestBuilder(String groupId) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("deleteUserGroup", "groupId", groupId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/management/user_groups/{groupId}".replace("{groupId}", ApiClient.urlEncode(groupId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<UserGroupResponse>> getUserGroup(String groupId) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getUserGroupRequestBuilder(groupId);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getUserGroup", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (UserGroupResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<UserGroupResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getUserGroupRequestBuilder(String groupId) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("getUserGroup", "groupId", groupId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/management/user_groups/{groupId}".replace("{groupId}", ApiClient.urlEncode(groupId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<List<UserGroupResponse>>> getUserGroups() throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getUserGroupsRequestBuilder();
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getUserGroups", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (List)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<List<UserGroupResponse>>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getUserGroupsRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/management/user_groups";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<UserGroupCreateResponse>> updateUserGroup(UserGroupUpdateRequest userGroupUpdateRequest, String groupId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.updateUserGroupRequestBuilder(userGroupUpdateRequest, groupId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("updateUserGroup", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (UserGroupCreateResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<UserGroupCreateResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder updateUserGroupRequestBuilder(UserGroupUpdateRequest userGroupUpdateRequest, String groupId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("updateUserGroup", "userGroupUpdateRequest", userGroupUpdateRequest);
        ValidationUtils.assertParamExistsAndNotEmpty("updateUserGroup", "groupId", groupId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/management/user_groups/{groupId}".replace("{groupId}", ApiClient.urlEncode(groupId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)userGroupUpdateRequest);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

