/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fireblocks.sdk.ApiClient;
import com.fireblocks.sdk.ApiException;
import com.fireblocks.sdk.ApiResponse;
import com.fireblocks.sdk.Pair;
import com.fireblocks.sdk.ValidationUtils;
import com.fireblocks.sdk.model.CreateAddressRequest;
import com.fireblocks.sdk.model.CreateAddressResponse;
import com.fireblocks.sdk.model.CreateAssetsRequest;
import com.fireblocks.sdk.model.CreateMultipleAccountsRequest;
import com.fireblocks.sdk.model.CreateVaultAccountRequest;
import com.fireblocks.sdk.model.CreateVaultAssetResponse;
import com.fireblocks.sdk.model.GetMaxSpendableAmountResponse;
import com.fireblocks.sdk.model.JobCreated;
import com.fireblocks.sdk.model.PaginatedAddressResponse;
import com.fireblocks.sdk.model.PaginatedAssetWalletResponse;
import com.fireblocks.sdk.model.PublicKeyInformation;
import com.fireblocks.sdk.model.RenameVaultAccountResponse;
import com.fireblocks.sdk.model.SetAutoFuelRequest;
import com.fireblocks.sdk.model.SetCustomerRefIdForAddressRequest;
import com.fireblocks.sdk.model.SetCustomerRefIdRequest;
import com.fireblocks.sdk.model.UnspentInputsResponse;
import com.fireblocks.sdk.model.UpdateVaultAccountAssetAddressRequest;
import com.fireblocks.sdk.model.UpdateVaultAccountRequest;
import com.fireblocks.sdk.model.VaultAccount;
import com.fireblocks.sdk.model.VaultAccountsPagedResponse;
import com.fireblocks.sdk.model.VaultActionStatus;
import com.fireblocks.sdk.model.VaultAsset;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class VaultsApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public VaultsApi() {
        this(new ApiClient());
    }

    public VaultsApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    private ApiException getApiException(String operationId, HttpResponse<String> response) {
        String message = this.formatExceptionMessage(operationId, response.statusCode(), response.body());
        return new ApiException(response.statusCode(), message, response.headers(), response.body());
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public CompletableFuture<ApiResponse<CreateVaultAssetResponse>> activateAssetForVaultAccount(String vaultAccountId, String assetId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.activateAssetForVaultAccountRequestBuilder(vaultAccountId, assetId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("activateAssetForVaultAccount", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (CreateVaultAssetResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<CreateVaultAssetResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder activateAssetForVaultAccountRequestBuilder(String vaultAccountId, String assetId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("activateAssetForVaultAccount", "vaultAccountId", vaultAccountId);
        ValidationUtils.assertParamExistsAndNotEmpty("activateAssetForVaultAccount", "assetId", assetId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/{assetId}/activate".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString())).replace("{assetId}", ApiClient.urlEncode(assetId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<CreateAddressResponse>> createLegacyAddress(String vaultAccountId, String assetId, String addressId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.createLegacyAddressRequestBuilder(vaultAccountId, assetId, addressId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("createLegacyAddress", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (CreateAddressResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<CreateAddressResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder createLegacyAddressRequestBuilder(String vaultAccountId, String assetId, String addressId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("createLegacyAddress", "vaultAccountId", vaultAccountId);
        ValidationUtils.assertParamExistsAndNotEmpty("createLegacyAddress", "assetId", assetId);
        ValidationUtils.assertParamExistsAndNotEmpty("createLegacyAddress", "addressId", addressId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/{assetId}/addresses/{addressId}/create_legacy".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString())).replace("{assetId}", ApiClient.urlEncode(assetId.toString())).replace("{addressId}", ApiClient.urlEncode(addressId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<JobCreated>> createMultipleAccounts(CreateMultipleAccountsRequest createMultipleAccountsRequest, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.createMultipleAccountsRequestBuilder(createMultipleAccountsRequest, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("createMultipleAccounts", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (JobCreated)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<JobCreated>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder createMultipleAccountsRequestBuilder(CreateMultipleAccountsRequest createMultipleAccountsRequest, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("createMultipleAccounts", "createMultipleAccountsRequest", createMultipleAccountsRequest);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/bulk";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createMultipleAccountsRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<VaultAccount>> createVaultAccount(CreateVaultAccountRequest createVaultAccountRequest, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.createVaultAccountRequestBuilder(createVaultAccountRequest, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("createVaultAccount", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (VaultAccount)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<VaultAccount>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder createVaultAccountRequestBuilder(CreateVaultAccountRequest createVaultAccountRequest, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("createVaultAccount", "createVaultAccountRequest", createVaultAccountRequest);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createVaultAccountRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<CreateVaultAssetResponse>> createVaultAccountAsset(String vaultAccountId, String assetId, CreateAssetsRequest createAssetsRequest, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.createVaultAccountAssetRequestBuilder(vaultAccountId, assetId, createAssetsRequest, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("createVaultAccountAsset", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (CreateVaultAssetResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<CreateVaultAssetResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder createVaultAccountAssetRequestBuilder(String vaultAccountId, String assetId, CreateAssetsRequest createAssetsRequest, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("createVaultAccountAsset", "vaultAccountId", vaultAccountId);
        ValidationUtils.assertParamExistsAndNotEmpty("createVaultAccountAsset", "assetId", assetId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/{assetId}".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString())).replace("{assetId}", ApiClient.urlEncode(assetId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createAssetsRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<CreateAddressResponse>> createVaultAccountAssetAddress(String vaultAccountId, String assetId, CreateAddressRequest createAddressRequest, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.createVaultAccountAssetAddressRequestBuilder(vaultAccountId, assetId, createAddressRequest, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("createVaultAccountAssetAddress", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (CreateAddressResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<CreateAddressResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder createVaultAccountAssetAddressRequestBuilder(String vaultAccountId, String assetId, CreateAddressRequest createAddressRequest, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("createVaultAccountAssetAddress", "vaultAccountId", vaultAccountId);
        ValidationUtils.assertParamExistsAndNotEmpty("createVaultAccountAssetAddress", "assetId", assetId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/{assetId}/addresses".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString())).replace("{assetId}", ApiClient.urlEncode(assetId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createAddressRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<PaginatedAssetWalletResponse>> getAssetWallets(BigDecimal totalAmountLargerThan, String assetId, String orderBy, String before, String after, BigDecimal limit) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getAssetWalletsRequestBuilder(totalAmountLargerThan, assetId, orderBy, before, after, limit);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getAssetWallets", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (PaginatedAssetWalletResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<PaginatedAssetWalletResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getAssetWalletsRequestBuilder(BigDecimal totalAmountLargerThan, String assetId, String orderBy, String before, String after, BigDecimal limit) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/asset_wallets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "totalAmountLargerThan";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("totalAmountLargerThan", totalAmountLargerThan));
        localVarQueryParameterBaseName = "assetId";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("assetId", assetId));
        localVarQueryParameterBaseName = "orderBy";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("orderBy", orderBy));
        localVarQueryParameterBaseName = "before";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("before", before));
        localVarQueryParameterBaseName = "after";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("after", after));
        localVarQueryParameterBaseName = "limit";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("limit", limit));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<GetMaxSpendableAmountResponse>> getMaxSpendableAmount(String vaultAccountId, String assetId, Boolean manualSignging) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getMaxSpendableAmountRequestBuilder(vaultAccountId, assetId, manualSignging);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getMaxSpendableAmount", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (GetMaxSpendableAmountResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<GetMaxSpendableAmountResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getMaxSpendableAmountRequestBuilder(String vaultAccountId, String assetId, Boolean manualSignging) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("getMaxSpendableAmount", "vaultAccountId", vaultAccountId);
        ValidationUtils.assertParamExistsAndNotEmpty("getMaxSpendableAmount", "assetId", assetId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/{assetId}/max_spendable_amount".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString())).replace("{assetId}", ApiClient.urlEncode(assetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "manualSignging";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("manualSignging", manualSignging));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<VaultAccountsPagedResponse>> getPagedVaultAccounts(String namePrefix, String nameSuffix, BigDecimal minAmountThreshold, String assetId, String orderBy, String before, String after, BigDecimal limit) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getPagedVaultAccountsRequestBuilder(namePrefix, nameSuffix, minAmountThreshold, assetId, orderBy, before, after, limit);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getPagedVaultAccounts", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (VaultAccountsPagedResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<VaultAccountsPagedResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getPagedVaultAccountsRequestBuilder(String namePrefix, String nameSuffix, BigDecimal minAmountThreshold, String assetId, String orderBy, String before, String after, BigDecimal limit) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts_paged";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "namePrefix";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("namePrefix", namePrefix));
        localVarQueryParameterBaseName = "nameSuffix";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("nameSuffix", nameSuffix));
        localVarQueryParameterBaseName = "minAmountThreshold";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("minAmountThreshold", minAmountThreshold));
        localVarQueryParameterBaseName = "assetId";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("assetId", assetId));
        localVarQueryParameterBaseName = "orderBy";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("orderBy", orderBy));
        localVarQueryParameterBaseName = "before";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("before", before));
        localVarQueryParameterBaseName = "after";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("after", after));
        localVarQueryParameterBaseName = "limit";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("limit", limit));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<PublicKeyInformation>> getPublicKeyInfo(String derivationPath, String algorithm, Boolean compressed) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getPublicKeyInfoRequestBuilder(derivationPath, algorithm, compressed);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getPublicKeyInfo", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (PublicKeyInformation)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<PublicKeyInformation>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getPublicKeyInfoRequestBuilder(String derivationPath, String algorithm, Boolean compressed) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("getPublicKeyInfo", "derivationPath", derivationPath);
        ValidationUtils.assertParamExistsAndNotEmpty("getPublicKeyInfo", "algorithm", algorithm);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/public_key_info";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "derivationPath";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("derivationPath", derivationPath));
        localVarQueryParameterBaseName = "algorithm";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("algorithm", algorithm));
        localVarQueryParameterBaseName = "compressed";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("compressed", compressed));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<PublicKeyInformation>> getPublicKeyInfoForAddress(String vaultAccountId, String assetId, BigDecimal change, BigDecimal addressIndex, Boolean compressed) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getPublicKeyInfoForAddressRequestBuilder(vaultAccountId, assetId, change, addressIndex, compressed);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getPublicKeyInfoForAddress", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (PublicKeyInformation)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<PublicKeyInformation>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getPublicKeyInfoForAddressRequestBuilder(String vaultAccountId, String assetId, BigDecimal change, BigDecimal addressIndex, Boolean compressed) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("getPublicKeyInfoForAddress", "vaultAccountId", vaultAccountId);
        ValidationUtils.assertParamExistsAndNotEmpty("getPublicKeyInfoForAddress", "assetId", assetId);
        ValidationUtils.assertParamExists("getPublicKeyInfoForAddress", "change", change);
        ValidationUtils.assertParamExists("getPublicKeyInfoForAddress", "addressIndex", addressIndex);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/{assetId}/{change}/{addressIndex}/public_key_info".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString())).replace("{assetId}", ApiClient.urlEncode(assetId.toString())).replace("{change}", ApiClient.urlEncode(change.toString())).replace("{addressIndex}", ApiClient.urlEncode(addressIndex.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "compressed";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("compressed", compressed));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<List<UnspentInputsResponse>>> getUnspentInputs(String vaultAccountId, String assetId) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getUnspentInputsRequestBuilder(vaultAccountId, assetId);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getUnspentInputs", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (List)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<List<UnspentInputsResponse>>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getUnspentInputsRequestBuilder(String vaultAccountId, String assetId) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("getUnspentInputs", "vaultAccountId", vaultAccountId);
        ValidationUtils.assertParamExistsAndNotEmpty("getUnspentInputs", "assetId", assetId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/{assetId}/unspent_inputs".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString())).replace("{assetId}", ApiClient.urlEncode(assetId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<VaultAccount>> getVaultAccount(String vaultAccountId) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getVaultAccountRequestBuilder(vaultAccountId);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getVaultAccount", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (VaultAccount)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<VaultAccount>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getVaultAccountRequestBuilder(String vaultAccountId) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("getVaultAccount", "vaultAccountId", vaultAccountId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<VaultAsset>> getVaultAccountAsset(String vaultAccountId, String assetId) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getVaultAccountAssetRequestBuilder(vaultAccountId, assetId);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getVaultAccountAsset", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (VaultAsset)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<VaultAsset>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getVaultAccountAssetRequestBuilder(String vaultAccountId, String assetId) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("getVaultAccountAsset", "vaultAccountId", vaultAccountId);
        ValidationUtils.assertParamExistsAndNotEmpty("getVaultAccountAsset", "assetId", assetId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/{assetId}".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString())).replace("{assetId}", ApiClient.urlEncode(assetId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<PaginatedAddressResponse>> getVaultAccountAssetAddressesPaginated(String vaultAccountId, String assetId, BigDecimal limit, String before, String after) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getVaultAccountAssetAddressesPaginatedRequestBuilder(vaultAccountId, assetId, limit, before, after);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getVaultAccountAssetAddressesPaginated", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (PaginatedAddressResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<PaginatedAddressResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getVaultAccountAssetAddressesPaginatedRequestBuilder(String vaultAccountId, String assetId, BigDecimal limit, String before, String after) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("getVaultAccountAssetAddressesPaginated", "vaultAccountId", vaultAccountId);
        ValidationUtils.assertParamExistsAndNotEmpty("getVaultAccountAssetAddressesPaginated", "assetId", assetId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/{assetId}/addresses_paginated".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString())).replace("{assetId}", ApiClient.urlEncode(assetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "limit";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("limit", limit));
        localVarQueryParameterBaseName = "before";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("before", before));
        localVarQueryParameterBaseName = "after";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("after", after));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<List<VaultAsset>>> getVaultAssets(String accountNamePrefix, String accountNameSuffix) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getVaultAssetsRequestBuilder(accountNamePrefix, accountNameSuffix);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getVaultAssets", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (List)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<List<VaultAsset>>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getVaultAssetsRequestBuilder(String accountNamePrefix, String accountNameSuffix) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/assets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "accountNamePrefix";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("accountNamePrefix", accountNamePrefix));
        localVarQueryParameterBaseName = "accountNameSuffix";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("accountNameSuffix", accountNameSuffix));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<VaultAsset>> getVaultBalanceByAsset(String assetId) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.getVaultBalanceByAssetRequestBuilder(assetId);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("getVaultBalanceByAsset", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (VaultAsset)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<VaultAsset>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder getVaultBalanceByAssetRequestBuilder(String assetId) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("getVaultBalanceByAsset", "assetId", assetId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/assets/{assetId}".replace("{assetId}", ApiClient.urlEncode(assetId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<VaultActionStatus>> hideVaultAccount(String vaultAccountId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.hideVaultAccountRequestBuilder(vaultAccountId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("hideVaultAccount", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (VaultActionStatus)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<VaultActionStatus>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder hideVaultAccountRequestBuilder(String vaultAccountId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("hideVaultAccount", "vaultAccountId", vaultAccountId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/hide".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<VaultActionStatus>> setCustomerRefIdForAddress(SetCustomerRefIdForAddressRequest setCustomerRefIdForAddressRequest, String vaultAccountId, String assetId, String addressId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.setCustomerRefIdForAddressRequestBuilder(setCustomerRefIdForAddressRequest, vaultAccountId, assetId, addressId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("setCustomerRefIdForAddress", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (VaultActionStatus)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<VaultActionStatus>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder setCustomerRefIdForAddressRequestBuilder(SetCustomerRefIdForAddressRequest setCustomerRefIdForAddressRequest, String vaultAccountId, String assetId, String addressId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("setCustomerRefIdForAddress", "setCustomerRefIdForAddressRequest", setCustomerRefIdForAddressRequest);
        ValidationUtils.assertParamExistsAndNotEmpty("setCustomerRefIdForAddress", "vaultAccountId", vaultAccountId);
        ValidationUtils.assertParamExistsAndNotEmpty("setCustomerRefIdForAddress", "assetId", assetId);
        ValidationUtils.assertParamExistsAndNotEmpty("setCustomerRefIdForAddress", "addressId", addressId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/{assetId}/addresses/{addressId}/set_customer_ref_id".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString())).replace("{assetId}", ApiClient.urlEncode(assetId.toString())).replace("{addressId}", ApiClient.urlEncode(addressId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)setCustomerRefIdForAddressRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<VaultActionStatus>> setVaultAccountAutoFuel(SetAutoFuelRequest setAutoFuelRequest, String vaultAccountId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.setVaultAccountAutoFuelRequestBuilder(setAutoFuelRequest, vaultAccountId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("setVaultAccountAutoFuel", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (VaultActionStatus)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<VaultActionStatus>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder setVaultAccountAutoFuelRequestBuilder(SetAutoFuelRequest setAutoFuelRequest, String vaultAccountId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("setVaultAccountAutoFuel", "setAutoFuelRequest", setAutoFuelRequest);
        ValidationUtils.assertParamExistsAndNotEmpty("setVaultAccountAutoFuel", "vaultAccountId", vaultAccountId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/set_auto_fuel".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)setAutoFuelRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<VaultActionStatus>> setVaultAccountCustomerRefId(SetCustomerRefIdRequest setCustomerRefIdRequest, String vaultAccountId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.setVaultAccountCustomerRefIdRequestBuilder(setCustomerRefIdRequest, vaultAccountId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("setVaultAccountCustomerRefId", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (VaultActionStatus)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<VaultActionStatus>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder setVaultAccountCustomerRefIdRequestBuilder(SetCustomerRefIdRequest setCustomerRefIdRequest, String vaultAccountId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("setVaultAccountCustomerRefId", "setCustomerRefIdRequest", setCustomerRefIdRequest);
        ValidationUtils.assertParamExistsAndNotEmpty("setVaultAccountCustomerRefId", "vaultAccountId", vaultAccountId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/set_customer_ref_id".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)setCustomerRefIdRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<VaultActionStatus>> unhideVaultAccount(String vaultAccountId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.unhideVaultAccountRequestBuilder(vaultAccountId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("unhideVaultAccount", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (VaultActionStatus)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<VaultActionStatus>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder unhideVaultAccountRequestBuilder(String vaultAccountId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("unhideVaultAccount", "vaultAccountId", vaultAccountId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/unhide".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<RenameVaultAccountResponse>> updateVaultAccount(UpdateVaultAccountRequest updateVaultAccountRequest, String vaultAccountId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.updateVaultAccountRequestBuilder(updateVaultAccountRequest, vaultAccountId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("updateVaultAccount", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (RenameVaultAccountResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<RenameVaultAccountResponse>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder updateVaultAccountRequestBuilder(UpdateVaultAccountRequest updateVaultAccountRequest, String vaultAccountId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExists("updateVaultAccount", "updateVaultAccountRequest", updateVaultAccountRequest);
        ValidationUtils.assertParamExistsAndNotEmpty("updateVaultAccount", "vaultAccountId", vaultAccountId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateVaultAccountRequest);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<VaultActionStatus>> updateVaultAccountAssetAddress(String vaultAccountId, String assetId, String addressId, UpdateVaultAccountAssetAddressRequest updateVaultAccountAssetAddressRequest, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.updateVaultAccountAssetAddressRequestBuilder(vaultAccountId, assetId, addressId, updateVaultAccountAssetAddressRequest, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("updateVaultAccountAssetAddress", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (VaultActionStatus)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<VaultActionStatus>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder updateVaultAccountAssetAddressRequestBuilder(String vaultAccountId, String assetId, String addressId, UpdateVaultAccountAssetAddressRequest updateVaultAccountAssetAddressRequest, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("updateVaultAccountAssetAddress", "vaultAccountId", vaultAccountId);
        ValidationUtils.assertParamExistsAndNotEmpty("updateVaultAccountAssetAddress", "assetId", assetId);
        ValidationUtils.assertParamExistsAndNotEmpty("updateVaultAccountAssetAddress", "addressId", addressId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/{assetId}/addresses/{addressId}".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString())).replace("{assetId}", ApiClient.urlEncode(assetId.toString())).replace("{addressId}", ApiClient.urlEncode(addressId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateVaultAccountAssetAddressRequest);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CompletableFuture<ApiResponse<VaultAsset>> updateVaultAccountAssetBalance(String vaultAccountId, String assetId, String idempotencyKey) throws ApiException {
        try {
            HttpRequest.Builder localVarRequestBuilder = this.updateVaultAccountAssetBalanceRequestBuilder(vaultAccountId, assetId, idempotencyKey);
            return this.memberVarHttpClient.sendAsync(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenComposeAsync(localVarResponse -> {
                if (this.memberVarAsyncResponseInterceptor != null) {
                    this.memberVarAsyncResponseInterceptor.accept((HttpResponse<String>)localVarResponse);
                }
                if (localVarResponse.statusCode() / 100 != 2) {
                    return CompletableFuture.failedFuture(this.getApiException("updateVaultAccountAssetBalance", (HttpResponse<String>)localVarResponse));
                }
                try {
                    String responseBody = (String)localVarResponse.body();
                    return CompletableFuture.completedFuture(new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody == null || responseBody.isBlank() ? null : (VaultAsset)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<VaultAsset>(){}))));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(new ApiException(e));
                }
            });
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private HttpRequest.Builder updateVaultAccountAssetBalanceRequestBuilder(String vaultAccountId, String assetId, String idempotencyKey) throws ApiException {
        ValidationUtils.assertParamExistsAndNotEmpty("updateVaultAccountAssetBalance", "vaultAccountId", vaultAccountId);
        ValidationUtils.assertParamExistsAndNotEmpty("updateVaultAccountAssetBalance", "assetId", assetId);
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/vault/accounts/{vaultAccountId}/{assetId}/balance".replace("{vaultAccountId}", ApiClient.urlEncode(vaultAccountId.toString())).replace("{assetId}", ApiClient.urlEncode(assetId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (idempotencyKey != null) {
            localVarRequestBuilder.header("Idempotency-Key", idempotencyKey.toString());
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

