/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.UserRole;
import com.fireblocks.sdk.model.UserStatus;
import com.fireblocks.sdk.model.UserType;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "name", "role", "enabled", "status", "userType"})
public class APIUser {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ROLE = "role";
    private UserRole role;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_STATUS = "status";
    private UserStatus status;
    public static final String JSON_PROPERTY_USER_TYPE = "userType";
    private UserType userType;

    public APIUser id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public APIUser name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public APIUser role(UserRole role) {
        this.role = role;
        return this;
    }

    @Nullable
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserRole getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRole(UserRole role) {
        this.role = role;
    }

    public APIUser enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public APIUser status(UserStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(UserStatus status) {
        this.status = status;
    }

    public APIUser userType(UserType userType) {
        this.userType = userType;
        return this;
    }

    @Nullable
    @JsonProperty(value="userType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserType getUserType() {
        return this.userType;
    }

    @JsonProperty(value="userType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIUser apIUser = (APIUser)o;
        return Objects.equals(this.id, apIUser.id) && Objects.equals(this.name, apIUser.name) && Objects.equals((Object)this.role, (Object)apIUser.role) && Objects.equals(this.enabled, apIUser.enabled) && Objects.equals((Object)this.status, (Object)apIUser.status) && Objects.equals((Object)this.userType, (Object)apIUser.userType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.role, this.enabled, this.status, this.userType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APIUser {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    userType: ").append(this.toIndentedString((Object)this.userType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRole() != null) {
            joiner.add(String.format("%srole%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getRole()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getEnabled() != null) {
            joiner.add(String.format("%senabled%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEnabled()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatus() != null) {
            joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUserType() != null) {
            joiner.add(String.format("%suserType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getUserType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

