/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fireblocks.sdk.model.Parameter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "stateMutability", "type", "inputs", "outputs", "description"})
public class AbiFunction {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STATE_MUTABILITY = "stateMutability";
    private StateMutabilityEnum stateMutability;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_INPUTS = "inputs";
    private List<Parameter> inputs = new ArrayList<Parameter>();
    public static final String JSON_PROPERTY_OUTPUTS = "outputs";
    private List<Parameter> outputs;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public AbiFunction name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public AbiFunction stateMutability(StateMutabilityEnum stateMutability) {
        this.stateMutability = stateMutability;
        return this;
    }

    @Nullable
    @JsonProperty(value="stateMutability")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateMutabilityEnum getStateMutability() {
        return this.stateMutability;
    }

    @JsonProperty(value="stateMutability")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStateMutability(StateMutabilityEnum stateMutability) {
        this.stateMutability = stateMutability;
    }

    public AbiFunction type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public AbiFunction inputs(List<Parameter> inputs) {
        this.inputs = inputs;
        return this;
    }

    public AbiFunction addInputsItem(Parameter inputsItem) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<Parameter>();
        }
        this.inputs.add(inputsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="inputs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Parameter> getInputs() {
        return this.inputs;
    }

    @JsonProperty(value="inputs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInputs(List<Parameter> inputs) {
        this.inputs = inputs;
    }

    public AbiFunction outputs(List<Parameter> outputs) {
        this.outputs = outputs;
        return this;
    }

    public AbiFunction addOutputsItem(Parameter outputsItem) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<Parameter>();
        }
        this.outputs.add(outputsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="outputs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Parameter> getOutputs() {
        return this.outputs;
    }

    @JsonProperty(value="outputs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutputs(List<Parameter> outputs) {
        this.outputs = outputs;
    }

    public AbiFunction description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbiFunction abiFunction = (AbiFunction)o;
        return Objects.equals(this.name, abiFunction.name) && Objects.equals((Object)this.stateMutability, (Object)abiFunction.stateMutability) && Objects.equals((Object)this.type, (Object)abiFunction.type) && Objects.equals(this.inputs, abiFunction.inputs) && Objects.equals(this.outputs, abiFunction.outputs) && Objects.equals(this.description, abiFunction.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.stateMutability, this.type, this.inputs, this.outputs, this.description});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AbiFunction {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    stateMutability: ").append(this.toIndentedString((Object)this.stateMutability)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        sb.append("    outputs: ").append(this.toIndentedString(this.outputs)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStateMutability() != null) {
            joiner.add(String.format("%sstateMutability%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getStateMutability()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getInputs() != null) {
            for (i = 0; i < this.getInputs().size(); ++i) {
                if (this.getInputs().get(i) == null) continue;
                joiner.add(this.getInputs().get(i).toUrlQueryString(String.format("%sinputs%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getOutputs() != null) {
            for (i = 0; i < this.getOutputs().size(); ++i) {
                if (this.getOutputs().get(i) == null) continue;
                joiner.add(this.getOutputs().get(i).toUrlQueryString(String.format("%soutputs%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getDescription() != null) {
            joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum TypeEnum {
        CONSTRUCTOR("constructor"),
        FUNCTION("function"),
        ERROR("error"),
        EVENT("event"),
        RECEIVE("receive"),
        FALLBACK("fallback");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StateMutabilityEnum {
        PURE("pure"),
        VIEW("view"),
        NONPAYABLE("nonpayable"),
        PAYABLE("payable");

        private String value;

        private StateMutabilityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateMutabilityEnum fromValue(String value) {
            for (StateMutabilityEnum b : StateMutabilityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

