/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.AccountType;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"accountId", "accountType"})
public class Account {
    public static final String JSON_PROPERTY_ACCOUNT_ID = "accountId";
    private String accountId;
    public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
    private AccountType accountType;

    public Account accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="accountId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="accountId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public Account accountType(AccountType accountType) {
        this.accountType = accountType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="accountType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AccountType getAccountType() {
        return this.accountType;
    }

    @JsonProperty(value="accountType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Objects.equals(this.accountId, account.accountId) && Objects.equals((Object)this.accountType, (Object)account.accountType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.accountType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAccountId() != null) {
            joiner.add(String.format("%saccountId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAccountId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAccountType() != null) {
            joiner.add(String.format("%saccountType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getAccountType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

