/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum AccountType {
    EXCHANGE_ACCOUNT("EXCHANGE_ACCOUNT"),
    UNMANAGED_WALLET("UNMANAGED_WALLET"),
    VAULT_ACCOUNT("VAULT_ACCOUNT"),
    NETWORK_CONNECTION("NETWORK_CONNECTION"),
    FIAT_ACCOUNT("FIAT_ACCOUNT");

    private String value;

    private AccountType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static AccountType fromValue(String value) {
        for (AccountType b : AccountType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

