/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"amount", "requestedAmount", "netAmount", "amountUSD"})
public class AmountInfo {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private String amount;
    public static final String JSON_PROPERTY_REQUESTED_AMOUNT = "requestedAmount";
    private String requestedAmount;
    public static final String JSON_PROPERTY_NET_AMOUNT = "netAmount";
    private String netAmount;
    public static final String JSON_PROPERTY_AMOUNT_U_S_D = "amountUSD";
    private String amountUSD;

    public AmountInfo amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(String amount) {
        this.amount = amount;
    }

    public AmountInfo requestedAmount(String requestedAmount) {
        this.requestedAmount = requestedAmount;
        return this;
    }

    @Nullable
    @JsonProperty(value="requestedAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequestedAmount() {
        return this.requestedAmount;
    }

    @JsonProperty(value="requestedAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestedAmount(String requestedAmount) {
        this.requestedAmount = requestedAmount;
    }

    public AmountInfo netAmount(String netAmount) {
        this.netAmount = netAmount;
        return this;
    }

    @Nullable
    @JsonProperty(value="netAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetAmount() {
        return this.netAmount;
    }

    @JsonProperty(value="netAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetAmount(String netAmount) {
        this.netAmount = netAmount;
    }

    public AmountInfo amountUSD(String amountUSD) {
        this.amountUSD = amountUSD;
        return this;
    }

    @Nullable
    @JsonProperty(value="amountUSD")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAmountUSD() {
        return this.amountUSD;
    }

    @JsonProperty(value="amountUSD")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountUSD(String amountUSD) {
        this.amountUSD = amountUSD;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmountInfo amountInfo = (AmountInfo)o;
        return Objects.equals(this.amount, amountInfo.amount) && Objects.equals(this.requestedAmount, amountInfo.requestedAmount) && Objects.equals(this.netAmount, amountInfo.netAmount) && Objects.equals(this.amountUSD, amountInfo.amountUSD);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.requestedAmount, this.netAmount, this.amountUSD);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AmountInfo {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    requestedAmount: ").append(this.toIndentedString(this.requestedAmount)).append("\n");
        sb.append("    netAmount: ").append(this.toIndentedString(this.netAmount)).append("\n");
        sb.append("    amountUSD: ").append(this.toIndentedString(this.amountUSD)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAmount() != null) {
            joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRequestedAmount() != null) {
            joiner.add(String.format("%srequestedAmount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRequestedAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getNetAmount() != null) {
            joiner.add(String.format("%snetAmount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNetAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAmountUSD() != null) {
            joiner.add(String.format("%samountUSD%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAmountUSD()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

