/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "lastSeen"})
public class ApiKey {
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_LAST_SEEN = "lastSeen";
    private OffsetDateTime lastSeen;

    public ApiKey id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(UUID id) {
        this.id = id;
    }

    public ApiKey lastSeen(OffsetDateTime lastSeen) {
        this.lastSeen = lastSeen;
        return this;
    }

    @Nonnull
    @JsonProperty(value="lastSeen")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getLastSeen() {
        return this.lastSeen;
    }

    @JsonProperty(value="lastSeen")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastSeen(OffsetDateTime lastSeen) {
        this.lastSeen = lastSeen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiKey apiKey = (ApiKey)o;
        return Objects.equals(this.id, apiKey.id) && Objects.equals(this.lastSeen, apiKey.lastSeen);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.lastSeen);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiKey {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastSeen: ").append(this.toIndentedString(this.lastSeen)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLastSeen() != null) {
            joiner.add(String.format("%slastSeen%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLastSeen()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

