/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fireblocks.sdk.model.AssetResponseMetadata;
import com.fireblocks.sdk.model.AssetResponseOnchain;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"legacyId", "assetClass", "onchain", "metadata"})
public class AssetResponse {
    public static final String JSON_PROPERTY_LEGACY_ID = "legacyId";
    private String legacyId;
    public static final String JSON_PROPERTY_ASSET_CLASS = "assetClass";
    private AssetClassEnum assetClass;
    public static final String JSON_PROPERTY_ONCHAIN = "onchain";
    private AssetResponseOnchain onchain;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private AssetResponseMetadata metadata;

    public AssetResponse legacyId(String legacyId) {
        this.legacyId = legacyId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="legacyId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLegacyId() {
        return this.legacyId;
    }

    @JsonProperty(value="legacyId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLegacyId(String legacyId) {
        this.legacyId = legacyId;
    }

    public AssetResponse assetClass(AssetClassEnum assetClass) {
        this.assetClass = assetClass;
        return this;
    }

    @Nonnull
    @JsonProperty(value="assetClass")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AssetClassEnum getAssetClass() {
        return this.assetClass;
    }

    @JsonProperty(value="assetClass")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAssetClass(AssetClassEnum assetClass) {
        this.assetClass = assetClass;
    }

    public AssetResponse onchain(AssetResponseOnchain onchain) {
        this.onchain = onchain;
        return this;
    }

    @Nonnull
    @JsonProperty(value="onchain")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AssetResponseOnchain getOnchain() {
        return this.onchain;
    }

    @JsonProperty(value="onchain")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOnchain(AssetResponseOnchain onchain) {
        this.onchain = onchain;
    }

    public AssetResponse metadata(AssetResponseMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AssetResponseMetadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMetadata(AssetResponseMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetResponse assetResponse = (AssetResponse)o;
        return Objects.equals(this.legacyId, assetResponse.legacyId) && Objects.equals((Object)this.assetClass, (Object)assetResponse.assetClass) && Objects.equals(this.onchain, assetResponse.onchain) && Objects.equals(this.metadata, assetResponse.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.legacyId, this.assetClass, this.onchain, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetResponse {\n");
        sb.append("    legacyId: ").append(this.toIndentedString(this.legacyId)).append("\n");
        sb.append("    assetClass: ").append(this.toIndentedString((Object)this.assetClass)).append("\n");
        sb.append("    onchain: ").append(this.toIndentedString(this.onchain)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getLegacyId() != null) {
            joiner.add(String.format("%slegacyId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLegacyId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAssetClass() != null) {
            joiner.add(String.format("%sassetClass%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getAssetClass()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getOnchain() != null) {
            joiner.add(this.getOnchain().toUrlQueryString((String)prefix + JSON_PROPERTY_ONCHAIN + suffix));
        }
        if (this.getMetadata() != null) {
            joiner.add(this.getMetadata().toUrlQueryString((String)prefix + JSON_PROPERTY_METADATA + suffix));
        }
        return joiner.toString();
    }

    public static enum AssetClassEnum {
        NATIVE("NATIVE"),
        FT("FT"),
        NFT("NFT"),
        SFT("SFT");

        private String value;

        private AssetClassEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AssetClassEnum fromValue(String value) {
            for (AssetClassEnum b : AssetClassEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

