/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "imageURL", "link"})
public class AuditorData {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_IMAGE_U_R_L = "imageURL";
    private String imageURL;
    public static final String JSON_PROPERTY_LINK = "link";
    private String link;

    public AuditorData name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public AuditorData imageURL(String imageURL) {
        this.imageURL = imageURL;
        return this;
    }

    @Nonnull
    @JsonProperty(value="imageURL")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getImageURL() {
        return this.imageURL;
    }

    @JsonProperty(value="imageURL")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setImageURL(String imageURL) {
        this.imageURL = imageURL;
    }

    public AuditorData link(String link) {
        this.link = link;
        return this;
    }

    @Nonnull
    @JsonProperty(value="link")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLink() {
        return this.link;
    }

    @JsonProperty(value="link")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLink(String link) {
        this.link = link;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditorData auditorData = (AuditorData)o;
        return Objects.equals(this.name, auditorData.name) && Objects.equals(this.imageURL, auditorData.imageURL) && Objects.equals(this.link, auditorData.link);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.imageURL, this.link);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditorData {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    imageURL: ").append(this.toIndentedString(this.imageURL)).append("\n");
        sb.append("    link: ").append(this.toIndentedString(this.link)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getImageURL() != null) {
            joiner.add(String.format("%simageURL%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getImageURL()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLink() != null) {
            joiner.add(String.format("%slink%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLink()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

