/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"th", "users"})
public class AuthorizationGroups {
    public static final String JSON_PROPERTY_TH = "th";
    private BigDecimal th;
    public static final String JSON_PROPERTY_USERS = "users";
    private Map<String, InnerEnum> users = new HashMap<String, InnerEnum>();

    public AuthorizationGroups th(BigDecimal th) {
        this.th = th;
        return this;
    }

    @Nullable
    @JsonProperty(value="th")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getTh() {
        return this.th;
    }

    @JsonProperty(value="th")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTh(BigDecimal th) {
        this.th = th;
    }

    public AuthorizationGroups users(Map<String, InnerEnum> users) {
        this.users = users;
        return this;
    }

    public AuthorizationGroups putUsersItem(String key, InnerEnum usersItem) {
        if (this.users == null) {
            this.users = new HashMap<String, InnerEnum>();
        }
        this.users.put(key, usersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="users")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, InnerEnum> getUsers() {
        return this.users;
    }

    @JsonProperty(value="users")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsers(Map<String, InnerEnum> users) {
        this.users = users;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationGroups authorizationGroups = (AuthorizationGroups)o;
        return Objects.equals(this.th, authorizationGroups.th) && Objects.equals(this.users, authorizationGroups.users);
    }

    public int hashCode() {
        return Objects.hash(this.th, this.users);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationGroups {\n");
        sb.append("    th: ").append(this.toIndentedString(this.th)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTh() != null) {
            joiner.add(String.format("%sth%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTh()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUsers() != null) {
            for (String _key : this.getUsers().keySet()) {
                joiner.add(String.format("%susers%s%s=%s", new Object[]{prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getUsers().get(_key), URLEncoder.encode(String.valueOf((Object)this.getUsers().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")}));
            }
        }
        return joiner.toString();
    }

    public static enum InnerEnum {
        PENDING_AUTHORIZATION("PENDING_AUTHORIZATION"),
        APPROVED("APPROVED"),
        REJECTED("REJECTED"),
        NA("NA");

        private String value;

        private InnerEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InnerEnum fromValue(String value) {
            for (InnerEnum b : InnerEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

