/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "name", "symbol", "standard", "blockchainDescriptor", "contractAddress"})
public class CollectionOwnershipResponse {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SYMBOL = "symbol";
    private String symbol;
    public static final String JSON_PROPERTY_STANDARD = "standard";
    private String standard;
    public static final String JSON_PROPERTY_BLOCKCHAIN_DESCRIPTOR = "blockchainDescriptor";
    private BlockchainDescriptorEnum blockchainDescriptor;
    public static final String JSON_PROPERTY_CONTRACT_ADDRESS = "contractAddress";
    private String contractAddress;

    public CollectionOwnershipResponse id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public CollectionOwnershipResponse name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public CollectionOwnershipResponse symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nullable
    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSymbol() {
        return this.symbol;
    }

    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public CollectionOwnershipResponse standard(String standard) {
        this.standard = standard;
        return this;
    }

    @Nullable
    @JsonProperty(value="standard")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStandard() {
        return this.standard;
    }

    @JsonProperty(value="standard")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStandard(String standard) {
        this.standard = standard;
    }

    public CollectionOwnershipResponse blockchainDescriptor(BlockchainDescriptorEnum blockchainDescriptor) {
        this.blockchainDescriptor = blockchainDescriptor;
        return this;
    }

    @Nonnull
    @JsonProperty(value="blockchainDescriptor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BlockchainDescriptorEnum getBlockchainDescriptor() {
        return this.blockchainDescriptor;
    }

    @JsonProperty(value="blockchainDescriptor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBlockchainDescriptor(BlockchainDescriptorEnum blockchainDescriptor) {
        this.blockchainDescriptor = blockchainDescriptor;
    }

    public CollectionOwnershipResponse contractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
        return this;
    }

    @Nullable
    @JsonProperty(value="contractAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContractAddress() {
        return this.contractAddress;
    }

    @JsonProperty(value="contractAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionOwnershipResponse collectionOwnershipResponse = (CollectionOwnershipResponse)o;
        return Objects.equals(this.id, collectionOwnershipResponse.id) && Objects.equals(this.name, collectionOwnershipResponse.name) && Objects.equals(this.symbol, collectionOwnershipResponse.symbol) && Objects.equals(this.standard, collectionOwnershipResponse.standard) && Objects.equals((Object)this.blockchainDescriptor, (Object)collectionOwnershipResponse.blockchainDescriptor) && Objects.equals(this.contractAddress, collectionOwnershipResponse.contractAddress);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.symbol, this.standard, this.blockchainDescriptor, this.contractAddress});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CollectionOwnershipResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    standard: ").append(this.toIndentedString(this.standard)).append("\n");
        sb.append("    blockchainDescriptor: ").append(this.toIndentedString((Object)this.blockchainDescriptor)).append("\n");
        sb.append("    contractAddress: ").append(this.toIndentedString(this.contractAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSymbol() != null) {
            joiner.add(String.format("%ssymbol%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSymbol()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStandard() != null) {
            joiner.add(String.format("%sstandard%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStandard()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getBlockchainDescriptor() != null) {
            joiner.add(String.format("%sblockchainDescriptor%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getBlockchainDescriptor()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getContractAddress() != null) {
            joiner.add(String.format("%scontractAddress%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContractAddress()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum BlockchainDescriptorEnum {
        ETH("ETH"),
        ETH_TEST3("ETH_TEST3"),
        ETH_TEST5("ETH_TEST5"),
        ETH_TEST6("ETH_TEST6"),
        POLYGON("POLYGON"),
        POLYGON_TEST_MUMBAI("POLYGON_TEST_MUMBAI"),
        AMOY_POLYGON_TEST("AMOY_POLYGON_TEST"),
        XTZ("XTZ"),
        XTZ_TEST("XTZ_TEST"),
        BASECHAIN_ETH("BASECHAIN_ETH"),
        BASECHAIN_ETH_TEST3("BASECHAIN_ETH_TEST3"),
        ETHERLINK("ETHERLINK"),
        ETHERLINK_TEST("ETHERLINK_TEST"),
        MANTLE("MANTLE"),
        MANTLE_TEST("MANTLE_TEST"),
        GUN_GUNZILLA_TEST("GUN_GUNZILLA_TEST");

        private String value;

        private BlockchainDescriptorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BlockchainDescriptorEnum fromValue(String value) {
            for (BlockchainDescriptorEnum b : BlockchainDescriptorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

