/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.CollectionTokenMetadataAttributeDto;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "description", "image", "animation_url", "external_url", "attributes"})
public class CollectionTokenMetadataDto {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_IMAGE = "image";
    private String image;
    public static final String JSON_PROPERTY_ANIMATION_URL = "animation_url";
    private String animationUrl;
    public static final String JSON_PROPERTY_EXTERNAL_URL = "external_url";
    private String externalUrl;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private List<CollectionTokenMetadataAttributeDto> attributes;

    public CollectionTokenMetadataDto name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CollectionTokenMetadataDto description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CollectionTokenMetadataDto image(String image) {
        this.image = image;
        return this;
    }

    @Nullable
    @JsonProperty(value="image")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImage() {
        return this.image;
    }

    @JsonProperty(value="image")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImage(String image) {
        this.image = image;
    }

    public CollectionTokenMetadataDto animationUrl(String animationUrl) {
        this.animationUrl = animationUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="animation_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAnimationUrl() {
        return this.animationUrl;
    }

    @JsonProperty(value="animation_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnimationUrl(String animationUrl) {
        this.animationUrl = animationUrl;
    }

    public CollectionTokenMetadataDto externalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="external_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalUrl() {
        return this.externalUrl;
    }

    @JsonProperty(value="external_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    public CollectionTokenMetadataDto attributes(List<CollectionTokenMetadataAttributeDto> attributes) {
        this.attributes = attributes;
        return this;
    }

    public CollectionTokenMetadataDto addAttributesItem(CollectionTokenMetadataAttributeDto attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<CollectionTokenMetadataAttributeDto>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CollectionTokenMetadataAttributeDto> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(List<CollectionTokenMetadataAttributeDto> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionTokenMetadataDto collectionTokenMetadataDto = (CollectionTokenMetadataDto)o;
        return Objects.equals(this.name, collectionTokenMetadataDto.name) && Objects.equals(this.description, collectionTokenMetadataDto.description) && Objects.equals(this.image, collectionTokenMetadataDto.image) && Objects.equals(this.animationUrl, collectionTokenMetadataDto.animationUrl) && Objects.equals(this.externalUrl, collectionTokenMetadataDto.externalUrl) && Objects.equals(this.attributes, collectionTokenMetadataDto.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.image, this.animationUrl, this.externalUrl, this.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CollectionTokenMetadataDto {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    animationUrl: ").append(this.toIndentedString(this.animationUrl)).append("\n");
        sb.append("    externalUrl: ").append(this.toIndentedString(this.externalUrl)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDescription() != null) {
            joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getImage() != null) {
            joiner.add(String.format("%simage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getImage()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAnimationUrl() != null) {
            joiner.add(String.format("%sanimation_url%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAnimationUrl()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getExternalUrl() != null) {
            joiner.add(String.format("%sexternal_url%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getExternalUrl()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAttributes() != null) {
            for (int i = 0; i < this.getAttributes().size(); ++i) {
                if (this.getAttributes().get(i) == null) continue;
                joiner.add(this.getAttributes().get(i).toUrlQueryString(String.format("%sattributes%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

